/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.pos;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.stanbol.enhancer.nlp.pos.LexicalCategory;

public enum Pos {
    AttributiveAdjective(LexicalCategory.Adjective),
    CharacteristicAdjective(LexicalCategory.Adjective),
    PeriodicAdjective(LexicalCategory.Adjective),
    PossessiveAdjective(LexicalCategory.Adjective),
    PredicativeAdjective(LexicalCategory.Adjective),
    RelativeAdjective(LexicalCategory.Adjective),
    SubstantiveAdjective(LexicalCategory.Adjective),
    OrdinalAdjective(LexicalCategory.Adjective),
    QualifierAdjective(LexicalCategory.Adjective, LexicalCategory.Quantifier),
    RelationalAdjective(LexicalCategory.Adjective),
    Circumposition(LexicalCategory.Adposition),
    Postposition(LexicalCategory.Adposition),
    Preposition(LexicalCategory.Adposition),
    CompoundPreposition(Preposition),
    FusedPreposition(Preposition),
    SimplePreposition(Preposition),
    AdjectivalAdverb(LexicalCategory.Adverb),
    CausalAdverb(LexicalCategory.Adverb),
    DegreeAdverb(LexicalCategory.Adverb),
    LocationAdverb(LexicalCategory.Adverb),
    MannerAdverb(LexicalCategory.Adverb),
    ModifierAdverb(LexicalCategory.Adverb),
    NegativeAdverb(LexicalCategory.Adverb),
    PronominalAdverb(LexicalCategory.Adverb),
    DemonstrativeAdverb(PronominalAdverb),
    VerbalAdverb(LexicalCategory.Adverb),
    WHTypeAdverbs(LexicalCategory.Adverb),
    ExclamatoryAdverb(WHTypeAdverbs),
    InterrogativeAdverb(WHTypeAdverbs),
    RelativeAdverb(WHTypeAdverbs),
    ConjunctionPhrase(LexicalCategory.Conjuction),
    CoordinatingConjunction(LexicalCategory.Conjuction),
    CorrelativeCoordinatingConjunction(CoordinatingConjunction),
    InitialCoordinatingConjunction(CoordinatingConjunction),
    NonInitialCoordinatingConjunction(CoordinatingConjunction),
    RepetitiveCoordinatingConjunction(CoordinatingConjunction),
    SimpleCoordinatingConjunction(CoordinatingConjunction),
    SubordinatingConjunction(LexicalCategory.Conjuction),
    SubordinatingConjunctionWithComparative(SubordinatingConjunction),
    SubordinatingConjunctionWithFiniteClause(SubordinatingConjunction),
    SubordinatingConjunctionWithInfinite(SubordinatingConjunction),
    SubordinatingConjunctionWithNegation(SubordinatingConjunction),
    SubordinatingConjunctionWithoutNegation(SubordinatingConjunction),
    ZeroComplementizer(SubordinatingConjunction),
    Interjection(LexicalCategory.Conjuction),
    CommonNoun(LexicalCategory.Noun),
    HonorificCommonNoun(CommonNoun),
    TitleNoun(CommonNoun),
    UnitNoun(CommonNoun),
    SpatiotemporalNoun(CommonNoun),
    RelationNoun(CommonNoun),
    CountableNoun(LexicalCategory.Noun),
    MassNoun(LexicalCategory.Noun),
    ProperNoun(LexicalCategory.Noun),
    DiminutiveNoun(LexicalCategory.Noun),
    NominalQuantifier(LexicalCategory.Noun, LexicalCategory.Quantifier),
    VoiceNoun(LexicalCategory.Noun),
    Determiner(LexicalCategory.PronounOrDeterminer),
    Article(Determiner),
    DefiniteArticle(Article),
    CliticDefiniteArticle(DefiniteArticle),
    FullDefiniteArticle(DefiniteArticle),
    ShortDefiniteArticle(DefiniteArticle),
    FusedPrepArt(Preposition, Article),
    IndefiniteArticle(Article),
    PartitiveArticle(Article),
    PossessiveArticle(Article),
    NonspecificDeterminer(Article),
    SpecificArticle(Article),
    CliticSpecificArticle(SpecificArticle),
    EmphaticDeterminer(Determiner),
    IndefiniteDeterminer(Determiner),
    NegativeDeterminer(IndefiniteDeterminer),
    PartitiveDeterminer(Determiner),
    UniquitiveDeterminer(Determiner),
    WHDeterminer(Determiner),
    ExclamatoryDeterminer(WHDeterminer),
    InterrogativeDeterminer(WHDeterminer),
    RelativeDeterminer(WHDeterminer),
    ReflexiveDeterminer(Determiner),
    Pronoun(LexicalCategory.PronounOrDeterminer),
    AttributivePronoun(Determiner, Pronoun),
    DemonstrativeDeterminer(AttributivePronoun),
    DemonstrativePronoun(Pronoun),
    DifferentialPronoun(Pronoun),
    DistributivePronoun(Pronoun),
    IndefinitePronoun(Pronoun),
    NonspecificPronoun(IndefinitePronoun),
    ImpersonalPronoun(IndefinitePronoun),
    NegativePronoun(IndefinitePronoun),
    LocativePronoun(Pronoun),
    PersReflPronoun(Pronoun),
    DeterminalPronoun(PersReflPronoun),
    FirstPersonPronoun(PersReflPronoun),
    PersonalPronoun(PersReflPronoun),
    ZeroPronoun(PersonalPronoun),
    AffixedPersonalPronoun(PersonalPronoun),
    StrongPersonalPronoun(PersonalPronoun),
    WeakPersonalPronoun(PersonalPronoun),
    ReciprocalPronoun(PersReflPronoun),
    ReflexivePronoun(PersReflPronoun),
    SecondPersonPronoun(PersReflPronoun),
    FamiliarSecondPersonPronoun(SecondPersonPronoun),
    PoliteSecondPersonPronoun(SecondPersonPronoun),
    ThirdPersonPronoun(PersReflPronoun),
    PossessivePronoun(Pronoun),
    PossessiveDeterminer(AttributivePronoun, PossessivePronoun),
    ReflexivePossessiveDeterminer(ReflexiveDeterminer, PossessiveDeterminer),
    SubstitutivePronoun(Pronoun),
    WHPronoun(Pronoun),
    ExclamatoryPronoun(WHPronoun),
    InterrogativePronoun(WHPronoun),
    RelativePronoun(WHPronoun),
    AllusivePronoun(Pronoun),
    ConditionalPronoun(Pronoun),
    EmphaticPronoun(Pronoun),
    MainPunctuation(LexicalCategory.Punctuation),
    SentenceFinalPunctuation(MainPunctuation),
    QuestionMark(SentenceFinalPunctuation),
    Point(SentenceFinalPunctuation),
    ExclamativePoint(MainPunctuation),
    InterrogativePunctuation(MainPunctuation),
    SecondaryPunctuation(LexicalCategory.Punctuation),
    ParentheticalPunctuation(SecondaryPunctuation),
    LeftParentheticalPunctuation(ParentheticalPunctuation),
    OpenAngleBracket(LeftParentheticalPunctuation),
    OpenSquareBracket(LeftParentheticalPunctuation),
    InvertedComma(LeftParentheticalPunctuation),
    InvertedQuestionMark(LeftParentheticalPunctuation),
    OpenBracket(LeftParentheticalPunctuation),
    OpenCurlyBracket(LeftParentheticalPunctuation),
    OpenParenthesis(LeftParentheticalPunctuation),
    RightParentheticalPunctuation(ParentheticalPunctuation),
    CloseAngleBracket(RightParentheticalPunctuation),
    CloseSquareBracket(RightParentheticalPunctuation),
    CloseBracket(RightParentheticalPunctuation),
    CloseCurlyBracket(RightParentheticalPunctuation),
    CloseParenthesis(RightParentheticalPunctuation),
    SentenceMedialPunctuation(SecondaryPunctuation),
    Colon(SentenceMedialPunctuation),
    Comma(SentenceMedialPunctuation),
    Hyphen(SentenceMedialPunctuation),
    SemiColon(SentenceMedialPunctuation),
    SuspensionPoints(SentenceMedialPunctuation),
    Quote(SecondaryPunctuation),
    CloseQuote(Quote),
    OpenQuote(Quote),
    Slash(SecondaryPunctuation),
    DualQuantifier(LexicalCategory.Quantifier),
    Numeral(LexicalCategory.Quantifier),
    ApproximateNumeral(Numeral),
    CardinalNumber(Numeral),
    CollectiveNumeral(Numeral),
    NominalNumber(Numeral),
    OrdinalNumber(Numeral),
    Fraction(Numeral),
    PaucalQuantifier(LexicalCategory.Quantifier),
    PluralQuantifier(LexicalCategory.Quantifier),
    ProQuantifier(LexicalCategory.Quantifier, Pronoun),
    DemonstrativeQuantifier(ProQuantifier),
    IndefiniteQuantifier(ProQuantifier),
    InterrogativeQuantifier(ProQuantifier),
    RelativeQuantifier(ProQuantifier),
    SingularQuantifier(LexicalCategory.Quantifier),
    MultiplicativeNumeral(LexicalCategory.Quantifier),
    Abbreviation(LexicalCategory.Residual),
    AbbreviatedPronoun(Pronoun, Abbreviation),
    Acronym(LexicalCategory.Residual),
    Date(LexicalCategory.Residual),
    Foreign(LexicalCategory.Residual),
    Formula(LexicalCategory.Residual),
    LayoutElement(LexicalCategory.Residual),
    ListMarker(LayoutElement),
    Bullet(LayoutElement),
    Image(LayoutElement),
    Symbol(LexicalCategory.Residual),
    Typo(LexicalCategory.Residual),
    CaseMarker(LexicalCategory.Unique),
    Classifier(LexicalCategory.Unique),
    DiscourseMarker(LexicalCategory.Unique),
    Intensifier(LexicalCategory.Unique),
    Izafat(LexicalCategory.Unique),
    MultiplicativeMarker(LexicalCategory.Unique),
    Particle(LexicalCategory.Unique),
    AdjectivalParticle(Particle),
    ContrastiveParticle(Particle),
    EmphaticParticle(Particle, Intensifier),
    ContrastiveEmphaticParticle(EmphaticParticle, ContrastiveParticle),
    ExclusiveEmphaticParticle(EmphaticParticle),
    InclusiveEmphaticParticle(EmphaticParticle),
    ExistentialParticle(Particle),
    PreverbalParticle(Particle),
    VerbalParticle(Particle),
    AspectParticle(VerbalParticle),
    ModalityMarkingAdverb(LexicalCategory.Adverb, VerbalParticle),
    SubjunctiveParticle(VerbalParticle),
    TenseMarkingParticle(VerbalParticle),
    FutureParticle(TenseMarkingParticle),
    VoiceParticle(VerbalParticle),
    InfinitiveParticle(VerbalParticle),
    ComparativeParticle(Particle),
    ConditionalParticule(CoordinatingConjunction, Particle),
    CoordinationParticle(Particle),
    DistinctiveParticle(Particle),
    InterrogativeParticle(Particle),
    ModalParticle(Particle),
    NegativeParticle(Particle),
    AffirmativeParticle(Particle),
    PossessiveParticle(Particle),
    RelativeParticle(Particle),
    SuperlativeParticle(Particle),
    PossessionMarker(LexicalCategory.Unique),
    Expletive(LexicalCategory.Unique),
    ExpletivePronoun(ThirdPersonPronoun, Expletive),
    ExpletiveArgument(ExpletivePronoun),
    ExpletiveCorrelate(ExpletivePronoun),
    StructuralExpletive(ExpletivePronoun),
    AuxiliaryVerb(LexicalCategory.Verb),
    Copula(AuxiliaryVerb),
    ModalVerb(AuxiliaryVerb),
    StrictAuxiliaryVerb(AuxiliaryVerb),
    AspectMarkingAuxiliary(StrictAuxiliaryVerb),
    TenseMarkingAuxiliary(StrictAuxiliaryVerb),
    BeAuxiliary(StrictAuxiliaryVerb),
    HaveAuxiliary(StrictAuxiliaryVerb),
    FiniteVerb(LexicalCategory.Verb),
    ConditionalVerb(FiniteVerb),
    ImperativeVerb(FiniteVerb),
    IndicativeVerb(FiniteVerb),
    SubjunctiveVerb(FiniteVerb),
    LightVerb(LexicalCategory.Verb),
    NonFiniteVerb(LexicalCategory.Verb),
    Gerund(NonFiniteVerb),
    Infinitive(NonFiniteVerb),
    Participle(NonFiniteVerb),
    AdverbialParticiple(LexicalCategory.Adverb, Participle),
    ConditionalParticiple(Participle),
    PastParticiple(Participle),
    PresentParticiple(Participle),
    Ing("ing", Gerund, Participle),
    ParticipleAdjective(LexicalCategory.Adjective, Participle),
    PastParticipleAdjective(ParticipleAdjective, PastParticiple),
    PresentParticipleAdjective(ParticipleAdjective, PresentParticiple),
    Supine(NonFiniteVerb),
    VerbalNoun(CommonNoun, NonFiniteVerb),
    MainVerb(LexicalCategory.Verb),
    AgentiveVerb(MainVerb),
    AspirationalVerb(MainVerb),
    HonorificVerb(MainVerb),
    Impersonal(MainVerb),
    NonAgentiveVerb(MainVerb);

    static final String OLIA_NAMESPACE = "http://purl.org/olia/olia.owl#";
    private final Set<LexicalCategory> categories;
    private final Collection<Pos> parents;
    private final IRI uri;
    private static final Map<Pos, Set<Pos>> transitiveClosureMap;

    private Pos(LexicalCategory category) {
        this(null, category, (LexicalCategory)null);
    }

    private Pos(LexicalCategory category, LexicalCategory additional) {
        this(null, category, additional);
    }

    private Pos(String name, LexicalCategory category, LexicalCategory additional) {
        this.uri = new IRI(OLIA_NAMESPACE + (name == null ? this.name() : name));
        this.categories = EnumSet.of(category);
        if (additional != null) {
            this.categories.add(additional);
        }
        this.parents = Collections.emptySet();
    }

    private Pos(Pos ... parent) {
        this((String)null, (LexicalCategory)null, parent);
    }

    private Pos(String name, Pos ... parent) {
        this(name, (LexicalCategory)null, parent);
    }

    private Pos(LexicalCategory category, Pos ... parent) {
        this(null, category, parent);
    }

    private Pos(String name, LexicalCategory category, Pos ... parent) {
        this.uri = new IRI(OLIA_NAMESPACE + (name == null ? this.name() : name));
        this.parents = parent == null || parent.length < 1 ? Collections.EMPTY_SET : Arrays.asList(parent);
        this.categories = category == null ? EnumSet.noneOf(LexicalCategory.class) : EnumSet.of(category);
        HashSet<Pos> toProcess = new HashSet<Pos>(this.parents);
        while (!toProcess.isEmpty()) {
            Iterator it = toProcess.iterator();
            Pos p = (Pos)((Object)it.next());
            it.remove();
            this.categories.addAll(p.categories);
            toProcess.addAll(p.parents);
        }
    }

    public Set<LexicalCategory> categories() {
        return this.categories;
    }

    public boolean isParent() {
        return this.parents.isEmpty();
    }

    public Collection<Pos> parents() {
        return this.parents;
    }

    public IRI getUri() {
        return this.uri;
    }

    public Set<Pos> hierarchy() {
        return transitiveClosureMap.get((Object)this);
    }

    public String toString() {
        return String.format("olia:%s", this.uri.getUnicodeString().substring(OLIA_NAMESPACE.length()));
    }

    static {
        transitiveClosureMap = new EnumMap<Pos, Set<Pos>>(Pos.class);
        for (Pos pos : Pos.values()) {
            EnumSet<Pos> parents = EnumSet.of(pos);
            for (Pos posParent : pos.parents()) {
                Set<Pos> transParents = transitiveClosureMap.get((Object)posParent);
                if (transParents != null) {
                    parents.addAll(transParents);
                    continue;
                }
                if (posParent == null) continue;
                parents.add(posParent);
            }
            transitiveClosureMap.put(pos, parents);
        }
    }
}

