/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.morpho;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.commons.rdf.IRI;

public enum Tense {
    NotAnchored("NotTemporallyAnchored"),
    Absolute("AbsoluteTense"),
    CloseFuture(Absolute),
    Future(Absolute),
    HodiernalFuture(Future),
    ImmediateFuture(Future),
    NearFuture(Future),
    PostHodiernalFuture(Future),
    RemoteFuture(Future),
    SimpleFuture(Future),
    Past(Absolute),
    HesternalPast(Past),
    HodiernalPast(Past),
    ImmediatePast(Past),
    RecentPast(Past),
    RemotePast(Past),
    SimplePast(Past),
    StillPast(Past),
    Imperfect(StillPast),
    Aorist(Past),
    Perfect(Absolute),
    PreHodiernalPast(Absolute),
    Present(Absolute),
    Transgressive(Present),
    AbsoluteRelative("AbsoluteRelativeTense"),
    FutureInFuture(AbsoluteRelative),
    FutureInPast(AbsoluteRelative),
    PastPerfect("PastPerfectTense", AbsoluteRelative),
    PastInFuture(AbsoluteRelative),
    PluperfectTense(AbsoluteRelative),
    Relative("RelativeTense"),
    FuturePerfect(Relative),
    RelativePast(Relative),
    RelativePresent(Relative);

    static final String OLIA_NAMESPACE = "http://purl.org/olia/olia.owl#";
    IRI uri;
    Tense parent;
    private static final Map<Tense, Set<Tense>> transitiveClosureMap;

    private Tense() {
        this(null, null);
    }

    private Tense(Tense parent) {
        this(null, parent);
    }

    private Tense(String name) {
        this(name, null);
    }

    private Tense(String name, Tense parent) {
        this.uri = new IRI(OLIA_NAMESPACE + (name == null ? this.name() : name));
        this.parent = parent;
    }

    public Tense getParent() {
        return this.parent;
    }

    public Set<Tense> getTenses() {
        return transitiveClosureMap.get((Object)this);
    }

    public IRI getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri.getUnicodeString();
    }

    static {
        transitiveClosureMap = new EnumMap<Tense, Set<Tense>>(Tense.class);
        for (Tense tense : Tense.values()) {
            EnumSet<Tense> parents = EnumSet.of(tense);
            Set<Tense> transParents = transitiveClosureMap.get((Object)tense.getParent());
            if (transParents != null) {
                parents.addAll(transParents);
            } else if (tense.getParent() != null) {
                parents.add(tense.getParent());
            }
            transitiveClosureMap.put(tense, parents);
        }
    }
}

