/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.morpho;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.stanbol.enhancer.nlp.morpho.CaseTag;
import org.apache.stanbol.enhancer.nlp.morpho.Definitness;
import org.apache.stanbol.enhancer.nlp.morpho.GenderTag;
import org.apache.stanbol.enhancer.nlp.morpho.NumberTag;
import org.apache.stanbol.enhancer.nlp.morpho.Person;
import org.apache.stanbol.enhancer.nlp.morpho.TenseTag;
import org.apache.stanbol.enhancer.nlp.morpho.VerbMoodTag;
import org.apache.stanbol.enhancer.nlp.pos.PosTag;

public class MorphoFeatures {
    private final String lemma;
    private Object posTags;
    private Object genderTags;
    private Object numberTags;
    private Object caseFeatureTags;
    private Object personValue;
    private Object definitnessValue;
    private Object verbFormTags;
    private Object tenseTags;

    public MorphoFeatures(String lemma) {
        if (lemma == null || lemma.isEmpty()) {
            throw new IllegalArgumentException("The parsed lemma MUST NOT be NULL nor empty!");
        }
        this.lemma = lemma;
    }

    public final String getLemma() {
        return this.lemma;
    }

    public final void addCase(CaseTag caseFeature) {
        this.caseFeatureTags = MorphoFeatures.addTo(this.caseFeatureTags, caseFeature, CaseTag.class);
    }

    public final CaseTag getCase() {
        return MorphoFeatures.getValue(this.caseFeatureTags, CaseTag.class);
    }

    public final List<CaseTag> getCaseList() {
        return MorphoFeatures.getValues(this.caseFeatureTags, CaseTag.class);
    }

    public final void addDefinitness(Definitness definitness) {
        this.definitnessValue = MorphoFeatures.addTo(this.definitnessValue, definitness, Definitness.class);
    }

    public final Definitness getDefinitness() {
        return MorphoFeatures.getValue(this.definitnessValue, Definitness.class);
    }

    public final List<Definitness> getDefinitnessList() {
        return MorphoFeatures.getValues(this.definitnessValue, Definitness.class);
    }

    public final void addGender(GenderTag gender) {
        this.genderTags = MorphoFeatures.addTo(this.genderTags, gender, GenderTag.class);
    }

    public final GenderTag getGender() {
        return MorphoFeatures.getValue(this.genderTags, GenderTag.class);
    }

    public final List<GenderTag> getGenderList() {
        return MorphoFeatures.getValues(this.genderTags, GenderTag.class);
    }

    public final void addNumber(NumberTag number) {
        this.numberTags = MorphoFeatures.addTo(this.numberTags, number, NumberTag.class);
    }

    public final NumberTag getNumber() {
        return MorphoFeatures.getValue(this.numberTags, NumberTag.class);
    }

    public final List<NumberTag> getNumberList() {
        return MorphoFeatures.getValues(this.numberTags, NumberTag.class);
    }

    public void addPerson(Person person) {
        this.personValue = MorphoFeatures.addTo(this.personValue, person, Person.class);
    }

    public final Person getPerson() {
        return MorphoFeatures.getValue(this.personValue, Person.class);
    }

    public final List<Person> getPersonList() {
        return MorphoFeatures.getValues(this.personValue, Person.class);
    }

    public void addPos(PosTag pos) {
        this.posTags = MorphoFeatures.addTo(this.posTags, pos, PosTag.class);
    }

    public final PosTag getPos() {
        return MorphoFeatures.getValue(this.posTags, PosTag.class);
    }

    public final List<PosTag> getPosList() {
        return MorphoFeatures.getValues(this.posTags, PosTag.class);
    }

    public void addTense(TenseTag tense) {
        this.tenseTags = MorphoFeatures.addTo(this.tenseTags, tense, TenseTag.class);
    }

    public final TenseTag getTense() {
        return MorphoFeatures.getValue(this.tenseTags, TenseTag.class);
    }

    public final List<TenseTag> getTenseList() {
        return MorphoFeatures.getValues(this.tenseTags, TenseTag.class);
    }

    public void addVerbForm(VerbMoodTag verbForm) {
        this.verbFormTags = MorphoFeatures.addTo(this.verbFormTags, verbForm, VerbMoodTag.class);
    }

    public final VerbMoodTag getVerbMood() {
        return MorphoFeatures.getValue(this.verbFormTags, VerbMoodTag.class);
    }

    public final List<VerbMoodTag> getVerbMoodList() {
        return MorphoFeatures.getValues(this.verbFormTags, VerbMoodTag.class);
    }

    public int hashCode() {
        return this.lemma.hashCode() + (this.posTags != null ? this.posTags.hashCode() : 0) + (this.genderTags != null ? this.genderTags.hashCode() : 0) + (this.personValue != null ? this.personValue.hashCode() : 0) + (this.caseFeatureTags != null ? this.caseFeatureTags.hashCode() : 0) + (this.definitnessValue != null ? this.definitnessValue.hashCode() : 0) + (this.verbFormTags != null ? this.verbFormTags.hashCode() : 0) + (this.tenseTags != null ? this.tenseTags.hashCode() : 0);
    }

    public boolean equals(Object o) {
        if (o instanceof MorphoFeatures && this.lemma.equals(((MorphoFeatures)o).lemma)) {
            MorphoFeatures lt = (MorphoFeatures)o;
            return (this.genderTags != null && this.genderTags.equals(lt.genderTags) || this.genderTags == null && lt.genderTags == null) && (this.caseFeatureTags != null && this.caseFeatureTags.equals(lt.caseFeatureTags) || this.caseFeatureTags == null && lt.caseFeatureTags == null) && (this.tenseTags != null && this.tenseTags.equals(lt.tenseTags) || this.tenseTags == null && lt.tenseTags == null) && (this.numberTags != null && this.numberTags.equals(lt.numberTags) || this.numberTags == null && lt.numberTags == null) && (this.definitnessValue != null && this.definitnessValue.equals(lt.definitnessValue) || this.definitnessValue == null && lt.definitnessValue == null) && (this.personValue != null && this.personValue.equals(lt.personValue) || this.personValue == null && lt.personValue == null) && (this.verbFormTags != null && this.verbFormTags.equals(lt.verbFormTags) || this.verbFormTags == null && lt.verbFormTags == null);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MorphoTag( lemma:");
        sb.append(this.lemma);
        if (this.posTags != null) {
            sb.append("| ").append(this.posTags);
        }
        if (this.genderTags != null) {
            sb.append("| ").append(this.genderTags);
        }
        if (this.numberTags != null) {
            sb.append("| ").append(this.numberTags);
        }
        if (this.personValue != null) {
            sb.append("| ").append(this.personValue);
        }
        if (this.definitnessValue != null) {
            sb.append("| ").append(this.definitnessValue);
        }
        if (this.caseFeatureTags != null) {
            sb.append("| ").append(this.caseFeatureTags);
        }
        if (this.verbFormTags != null) {
            sb.append("| ").append(this.verbFormTags);
        }
        if (this.tenseTags != null) {
            sb.append("|tense:").append(this.tenseTags);
        }
        sb.append(')');
        return sb.toString();
    }

    private static <T> Object addTo(Object field, T value, Class<T> clazz) {
        if (value == null) {
            return field;
        }
        if (field == null) {
            return value;
        }
        if (field instanceof List) {
            ((Collection)field).add(value);
            return field;
        }
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(field);
        list.add(value);
        return list;
    }

    private static <T> T getValue(Object field, Class<T> clazz) {
        if (field == null) {
            return null;
        }
        if (field instanceof List) {
            return (T)((List)field).get(0);
        }
        return (T)field;
    }

    private static <T> List<T> getValues(Object field, Class<T> clazz) {
        if (field == null) {
            return Collections.EMPTY_LIST;
        }
        if (field instanceof List) {
            return (List)field;
        }
        return Collections.singletonList(field);
    }
}

