/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model.tag;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.enhancer.nlp.model.tag.Tag;

public class TagSet<T extends Tag<T>>
implements Iterable<T> {
    private final String name;
    private final Set<String> languages;
    private final Map<String, T> tag2PosTag = new HashMap<String, T>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public TagSet(String name, String ... languages) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The parsed name MUST NOT be NULL!");
        }
        this.name = name;
        if (languages != null && languages.length > 0) {
            HashSet<String> langSet = new HashSet<String>(Arrays.asList(languages));
            langSet.remove(null);
            this.languages = Collections.unmodifiableSet(langSet);
        } else {
            this.languages = Collections.emptySet();
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    public void addTag(T tag) {
        if (tag != null) {
            if (((Tag)tag).getAnnotationModel() != null || this.equals(((Tag)tag).getAnnotationModel())) {
                throw new IllegalStateException("Unable to add " + tag + " to " + this + "because it is already assigned to " + ((Tag)tag).getAnnotationModel());
            }
            ((Tag)tag).setAnnotationModel(this);
            Tag oldTag = (Tag)this.tag2PosTag.put(((Tag)tag).getTag(), tag);
            if (oldTag != null && this.equals(oldTag.getAnnotationModel())) {
                oldTag.setAnnotationModel(null);
            }
        }
    }

    public T getTag(String tag) {
        return (T)((Tag)this.tag2PosTag.get(tag));
    }

    @Override
    public Iterator<T> iterator() {
        return this.tag2PosTag.values().iterator();
    }

    public String toString() {
        return String.format("AnnotationModel [name: %s |lanuages: %s]", this.getName(), this.languages);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TagSet && this.name.equals(((TagSet)obj).name);
    }
}

