/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model.impl;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.apache.stanbol.enhancer.nlp.model.Span;
import org.apache.stanbol.enhancer.nlp.model.SpanTypeEnum;
import org.apache.stanbol.enhancer.nlp.model.impl.AnalysedTextImpl;
import org.apache.stanbol.enhancer.nlp.model.impl.AnnotatedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpanImpl
extends AnnotatedImpl
implements Span {
    private static final Logger log = LoggerFactory.getLogger(SpanImpl.class);
    protected final int[] span;
    private SoftReference<String> textReference = null;
    protected AnalysedTextImpl context;
    protected final SpanTypeEnum type;

    protected SpanImpl(SpanTypeEnum type, int start, int end) {
        assert (type != null) : "The parsed SpanType MUST NOT be NULL!";
        if (start < 0 || end < start) {
            throw new IllegalArgumentException("Illegal span [" + start + ',' + end + ']');
        }
        this.type = type;
        this.span = new int[]{start, end};
    }

    protected SpanImpl(AnalysedTextImpl analysedText, SpanTypeEnum type, Span relativeTo, int start, int end) {
        this(type, relativeTo == null ? start : relativeTo.getStart() + start, relativeTo == null ? end : relativeTo.getStart() + end);
        this.setContext(analysedText);
        if (relativeTo != null && relativeTo.getEnd() < this.getEnd()) {
            throw new IllegalArgumentException("Illegal span [" + start + ',' + end + "] for " + (Object)((Object)type) + " relative to " + relativeTo + " : Span of the " + " contained Token MUST NOT extend the others!");
        }
    }

    protected void setContext(AnalysedTextImpl analysedText) {
        assert (analysedText != null) : "The parsed AnalysedText MUST NOT be NULL!";
        this.context = analysedText;
    }

    @Override
    public SpanTypeEnum getType() {
        return this.type;
    }

    @Override
    public int getStart() {
        return this.span[0];
    }

    @Override
    public int getEnd() {
        return this.span[1];
    }

    @Override
    public final AnalysedTextImpl getContext() {
        return this.context;
    }

    @Override
    public String getSpan() {
        String spanText;
        String string = spanText = this.textReference == null ? null : this.textReference.get();
        if (spanText == null) {
            spanText = this.getContext().getText().subSequence(this.span[0], this.span[1]).toString();
            this.textReference = new SoftReference<String>(spanText);
        }
        return spanText;
    }

    public int hashCode() {
        return Arrays.hashCode(this.span);
    }

    public boolean equals(Object obj) {
        return obj instanceof SpanImpl && this.getType() == ((Span)obj).getType() && Arrays.equals(this.span, ((SpanImpl)obj).span);
    }

    public String toString() {
        return String.format("%s: %s", new Object[]{this.type, Arrays.toString(this.span)});
    }

    @Override
    public int compareTo(Span o) {
        int start;
        if (this.context != null && o.getContext() != null && !this.context.equals(o.getContext())) {
            log.warn("Comparing Spans with different Context. This is not an intended usage of this class as start|end|type parameters do not have a natural oder over different texts.");
            log.info("This will sort Spans based on start|end|type parameters regardless that the might be over different texts!");
        }
        int n = this.span[0] < o.getStart() ? -1 : (start = this.span[0] == o.getStart() ? 0 : 1);
        if (start == 0) {
            int end = this.span[1] < o.getEnd() ? 1 : (this.span[1] == o.getEnd() ? 0 : -1);
            int o1 = this.getType().ordinal();
            int o2 = o.getType().ordinal();
            return end != 0 ? end : (o1 < o2 ? -1 : (o1 == o2 ? 0 : 1));
        }
        return start;
    }
}

