/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.stanbol.enhancer.nlp.model.Section;
import org.apache.stanbol.enhancer.nlp.model.Span;
import org.apache.stanbol.enhancer.nlp.model.SpanTypeEnum;
import org.apache.stanbol.enhancer.nlp.model.Token;
import org.apache.stanbol.enhancer.nlp.model.impl.AnalysedTextImpl;
import org.apache.stanbol.enhancer.nlp.model.impl.SpanImpl;
import org.apache.stanbol.enhancer.nlp.model.impl.TokenImpl;

public abstract class SectionImpl
extends SpanImpl
implements Section {
    public SectionImpl(SpanTypeEnum type, int start, int end) {
        super(type, start, end);
        assert (type != SpanTypeEnum.Token) : "The SpanType 'Token' is NOT a Section - can not cover other spans!";
    }

    public SectionImpl(AnalysedTextImpl at, SpanTypeEnum type, Span relativeTo, int start, int end) {
        super(at, type, relativeTo, start, end);
        assert (type != SpanTypeEnum.Token) : "The SpanType 'Token' is NOT a Section - can not cover other spans!";
    }

    @Override
    public Iterator<Span> getEnclosed(final Set<SpanTypeEnum> types) {
        return IteratorUtils.filteredIterator(this.getIterator(), (Predicate)new Predicate(){

            public boolean evaluate(Object span) {
                return types.contains((Object)((Span)span).getType());
            }
        });
    }

    @Override
    public Iterator<Span> getEnclosed(final Set<SpanTypeEnum> types, int startOffset, int endOffset) {
        if (startOffset >= this.span[1] - this.span[0]) {
            return Collections.emptySet().iterator();
        }
        int endIdx = this.span[0] + endOffset;
        int startIdx = startOffset < 0 ? this.span[0] : this.span[0] + startOffset;
        if (endIdx <= startIdx) {
            return Collections.emptySet().iterator();
        }
        if (endIdx > this.span[1]) {
            endIdx = this.span[1];
        }
        return IteratorUtils.filteredIterator(this.getIterator(new SubSetHelperSpan(startIdx, endIdx)), (Predicate)new Predicate(){

            public boolean evaluate(Object span) {
                return types.contains((Object)((Span)span).getType());
            }
        });
    }

    protected Iterator<Span> getIterator() {
        return this.getIterator(null);
    }

    protected Iterator<Span> getIterator(final SubSetHelperSpan section) {
        final SubSetHelperSpan end = new SubSetHelperSpan(section == null ? this.getEnd() : section.getEnd());
        return new Iterator<Span>(){
            boolean init = false;
            boolean removed = true;
            private Span span = section == null ? SectionImpl.this : section;

            @Override
            public boolean hasNext() {
                return this.getNext() != null;
            }

            private Span getNext() {
                Span next = SectionImpl.this.context.spans.higherKey(this.span);
                return next == null || next.compareTo(end) >= 0 ? null : next;
            }

            @Override
            public Span next() {
                this.init = true;
                this.span = this.getNext();
                this.removed = false;
                if (this.span == null) {
                    throw new NoSuchElementException();
                }
                return this.span;
            }

            @Override
            public void remove() {
                if (!this.init) {
                    throw new IllegalStateException("remove can not be called before the first call to next");
                }
                if (this.removed) {
                    throw new IllegalStateException("the current Span was already removed!");
                }
                SectionImpl.this.context.spans.remove(this.span);
                this.removed = true;
            }
        };
    }

    @Override
    public Token addToken(int start, int end) {
        return this.register(new TokenImpl(this.context, this, start, end));
    }

    protected <T extends Span> T register(T span) {
        Span current = (Span)this.context.spans.get(span);
        if (current == null) {
            this.context.spans.put(span, span);
            return span;
        }
        return (T)current;
    }

    @Override
    public Iterator<Token> getTokens() {
        return this.filter(Token.class);
    }

    protected <T extends Span> Iterator<T> filter(Class<T> clazz) {
        return IteratorUtils.filteredIterator(this.getIterator(), (Predicate)new InstanceofPredicate(clazz));
    }

    class SubSetHelperSpan
    extends SpanImpl
    implements Span {
        protected SubSetHelperSpan(int start, int end) {
            super(SpanTypeEnum.Text, start, end);
            this.setContext(SectionImpl.this.context);
        }

        protected SubSetHelperSpan(int pos) {
            super(SpanTypeEnum.Token, pos, Integer.MAX_VALUE);
            this.setContext(SectionImpl.this.context);
        }
    }
}

