/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.enhancer.nlp.model.annotation.Annotated;
import org.apache.stanbol.enhancer.nlp.model.annotation.Annotation;
import org.apache.stanbol.enhancer.nlp.model.annotation.Value;

public class AnnotatedImpl
implements Annotated {
    private Map<String, Object> annotations;

    @Override
    public Set<String> getKeys() {
        return this.annotations == null ? Collections.EMPTY_SET : this.annotations.keySet();
    }

    @Override
    public final Value<?> getValue(String key) {
        if (this.annotations == null) {
            return null;
        }
        Object value = this.annotations.get(key);
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value != null) {
            return ((Value[])value)[0];
        }
        return null;
    }

    @Override
    public final List<Value<?>> getValues(String key) {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        Object value = this.annotations.get(key);
        if (value instanceof Value) {
            List<Value<?>> singleton = Collections.singletonList((Value)value);
            return singleton;
        }
        if (value != null) {
            return Arrays.asList((Value[])value);
        }
        return Collections.emptyList();
    }

    @Override
    public final <V> Value<V> getAnnotation(Annotation<V> annotation) {
        if (this.annotations == null) {
            return null;
        }
        Object value = this.annotations.get(annotation.getKey());
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value != null) {
            return ((Value[])value)[0];
        }
        return null;
    }

    @Override
    public final <V> List<Value<V>> getAnnotations(Annotation<V> annotation) {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        Object value = this.annotations.get(annotation.getKey());
        if (value instanceof Value) {
            List<Value<V>> singleton = Collections.singletonList((Value)value);
            return singleton;
        }
        if (value != null) {
            return Arrays.asList((Value[])value);
        }
        return Collections.emptyList();
    }

    @Override
    public <V> void addAnnotations(Annotation<V> annotation, List<Value<V>> values) {
        this.addValuesInternal(annotation.getKey(), values);
    }

    @Override
    public void addValues(String key, List<Value<?>> values) {
        this.addValuesInternal(key, values);
    }

    private void addValuesInternal(String key, List<?> values) {
        Object newValues;
        if (values == null || values.isEmpty()) {
            return;
        }
        Map<String, Object> map = this.initAnnotations();
        Object currentValue = this.annotations.get(key);
        if (currentValue == null) {
            if (values.size() == 1) {
                newValues = values.get(0);
            } else {
                newValues = values.toArray(new Value[values.size()]);
                Arrays.sort((Value[])newValues, Value.PROBABILITY_COMPARATOR);
            }
        } else if (currentValue instanceof Value) {
            newValues = new Value[values.size() + 1];
            ((Value[])newValues)[0] = (Value)currentValue;
            int index = 1;
            for (Object value : values) {
                ((Value[])newValues)[index] = (Value)value;
                ++index;
            }
            Arrays.sort((Value[])newValues, Value.PROBABILITY_COMPARATOR);
        } else {
            int length = ((Value[])currentValue).length;
            newValues = new Value[values.size() + length];
            System.arraycopy(currentValue, 0, newValues, 0, length);
            for (Object value : values) {
                ((Value[])newValues)[length] = (Value)value;
                ++length;
            }
            Arrays.sort((Value[])newValues, Value.PROBABILITY_COMPARATOR);
        }
        map.put(key, newValues);
    }

    @Override
    public <V> void setAnnotations(Annotation<V> annotation, List<Value<V>> values) {
        this.setValuesInternal(annotation.getKey(), values);
    }

    @Override
    public void setValues(String key, List<Value<?>> values) {
        this.setValuesInternal(key, values);
    }

    private void setValuesInternal(String key, List<?> values) {
        Map<String, Object> map = this.initAnnotations();
        if (values == null || values.isEmpty()) {
            map.remove(key);
        } else if (values.size() == 1) {
            map.put(key, values.get(0));
        } else {
            Value[] copy = values.toArray(new Value[values.size()]);
            Arrays.sort(copy, Value.PROBABILITY_COMPARATOR);
            map.put(key, copy);
        }
    }

    private Map<String, Object> initAnnotations() {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, Object>();
        }
        return this.annotations;
    }

    @Override
    public <V> void addAnnotation(Annotation<V> annotation, Value<V> value) {
        this.addValue(annotation.getKey(), value);
    }

    @Override
    public void addValue(String key, Value<?> value) {
        if (value != null) {
            Map<String, Object> map = this.initAnnotations();
            Object currentValue = map.get(key);
            if (currentValue == null) {
                map.put(key, value);
            } else if (currentValue instanceof Value) {
                Value[] newValues = new Value[]{(Value)currentValue, value};
                Arrays.sort(newValues, Value.PROBABILITY_COMPARATOR);
                map.put(key, newValues);
            } else {
                int length = ((Value[])currentValue).length;
                Value[] newValues = new Value[length + 1];
                System.arraycopy(currentValue, 0, newValues, 0, length);
                newValues[length] = value;
                Arrays.sort(newValues, Value.PROBABILITY_COMPARATOR);
                map.put(key, newValues);
            }
        }
    }

    @Override
    public <V> void setAnnotation(Annotation<V> annotation, Value<V> value) {
        this.setValue(annotation.getKey(), value);
    }

    @Override
    public void setValue(String key, Value<?> value) {
        if (this.annotations == null && value == null) {
            return;
        }
        Map<String, Object> map = this.initAnnotations();
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }
}

