/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model.impl;

import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.Chunk;
import org.apache.stanbol.enhancer.nlp.model.Sentence;
import org.apache.stanbol.enhancer.nlp.model.Span;
import org.apache.stanbol.enhancer.nlp.model.SpanTypeEnum;
import org.apache.stanbol.enhancer.nlp.model.impl.ChunkImpl;
import org.apache.stanbol.enhancer.nlp.model.impl.SectionImpl;
import org.apache.stanbol.enhancer.nlp.model.impl.SentenceImpl;
import org.apache.stanbol.enhancer.servicesapi.Blob;

public class AnalysedTextImpl
extends SectionImpl
implements AnalysedText {
    private final Blob blob;
    private String text;
    protected NavigableMap<Span, Span> spans = new TreeMap<Span, Span>();

    public AnalysedTextImpl(Blob blob, String text) {
        super(SpanTypeEnum.Text, 0, text.length());
        this.setContext(this);
        this.blob = blob;
        this.text = text;
    }

    @Override
    public SpanTypeEnum getType() {
        return SpanTypeEnum.Text;
    }

    @Override
    public SentenceImpl addSentence(int start, int end) {
        return this.register(new SentenceImpl(this.context, this, start, end));
    }

    @Override
    public Iterator<Sentence> getSentences() {
        return this.filter(Sentence.class);
    }

    @Override
    public ChunkImpl addChunk(int start, int end) {
        return this.register(new ChunkImpl(this.context, this, start, end));
    }

    @Override
    public Iterator<Chunk> getChunks() {
        return this.filter(Chunk.class);
    }

    public final Blob getAnalysedBlob() {
        return this.blob;
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public Blob getBlob() {
        return this.blob;
    }
}

