/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model.annotation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class Value<T> {
    public static final double UNKNOWN_PROBABILITY = -1.0;
    private final T value;
    private final double probability;
    public static final Comparator<Value<?>> PROBABILITY_COMPARATOR = new Comparator<Value<?>>(){

        @Override
        public int compare(Value<?> o1, Value<?> o2) {
            return Double.compare(((Value)o2).probability, ((Value)o1).probability);
        }
    };

    public Value(T value) {
        this(value, -1.0);
    }

    public Value(T value, double probability) {
        if (value == null) {
            throw new IllegalArgumentException("The parsed Value MUST NOT be NULL!");
        }
        this.value = value;
        if (probability != -1.0 && (probability > 1.0 || probability < 0.0)) {
            throw new IllegalArgumentException("Probabilities MUST BE in the range [0..1]");
        }
        this.probability = probability;
    }

    public final T value() {
        return this.value;
    }

    public final double probability() {
        return this.probability;
    }

    public static <T> Value<T> value(T value) {
        return new Value<T>(value);
    }

    public static <T> Value<T> value(T value, double probability) {
        return new Value<T>(value, probability);
    }

    public static <T> List<Value<T>> values(T ... values) {
        ArrayList<Value<T>> valList = new ArrayList<Value<T>>(values.length);
        for (T value : values) {
            valList.add(new Value<T>(value));
        }
        return valList;
    }

    public static <T> List<Value<T>> values(T[] values, double[] probabilities) {
        return Value.values(values, probabilities, values.length);
    }

    public static <T> List<Value<T>> values(T[] values, double[] probabilities, int elements) {
        ArrayList<Value<T>> valList = new ArrayList<Value<T>>(elements);
        for (int i = 0; i < elements; ++i) {
            valList.add(new Value<T>(values[i], probabilities[i]));
        }
        return valList;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.probability);
        return this.value.hashCode() + (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof Value && this.value.equals(((Value)obj).value) && this.probability == ((Value)obj).probability;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Value [");
        sb.append(this.value.toString()).append(']');
        if (this.probability != -1.0) {
            sb.append(".prob=").append(this.probability);
        }
        return sb.toString();
    }
}

