/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.Section;
import org.apache.stanbol.enhancer.nlp.model.Span;
import org.apache.stanbol.enhancer.nlp.model.SpanTypeEnum;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysedTextUtils {
    private static final Logger log = LoggerFactory.getLogger(AnalysedTextUtils.class);

    private AnalysedTextUtils() {
    }

    public static AnalysedText getAnalysedText(ContentItem ci) {
        ci.getLock().readLock().lock();
        try {
            AnalysedText analysedText = (AnalysedText)ci.getPart(AnalysedText.ANALYSED_TEXT_URI, AnalysedText.class);
            return analysedText;
        }
        catch (NoSuchPartException e) {
            AnalysedText analysedText = null;
            return analysedText;
        }
        finally {
            ci.getLock().readLock().unlock();
        }
    }

    public static <T extends Span> List<T> asList(Iterator<T> it) {
        if (it == null || !it.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList spans = new ArrayList();
        AnalysedTextUtils.appandToList(it, spans);
        return spans;
    }

    public static <T extends Span> void appandToList(Iterator<T> it, List<? super T> list) {
        if (it != null) {
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
    }

    public static <T extends Span> SortedSet<T> asSet(Iterator<T> it) {
        TreeSet spans = new TreeSet();
        AnalysedTextUtils.addToSet(it, spans);
        return spans;
    }

    public static <T extends Span> void addToSet(Iterator<T> it, Set<? super T> set) {
        if (it != null) {
            while (it.hasNext()) {
                set.add(it.next());
            }
        }
    }

    public static Iterator<Span> getSpansInSpans(Section section, SpanTypeEnum level1, final SpanTypeEnum level2) {
        if (level1 == SpanTypeEnum.Token) {
            throw new IllegalArgumentException("The SpanType for level1 MUST refer to a Section (Chunk, Sentence, TextSection or Text)");
        }
        final Iterator<Span> level1It = section.getEnclosed(EnumSet.of(level1));
        return new Iterator<Span>(){
            Iterator<Span> level2It = null;

            @Override
            public boolean hasNext() {
                if (this.level2It != null && this.level2It.hasNext()) {
                    return true;
                }
                while (level1It.hasNext()) {
                    this.level2It = ((Section)level1It.next()).getEnclosed(EnumSet.of(level2));
                    if (!this.level2It.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Span next() {
                this.hasNext();
                return this.level2It.next();
            }

            @Override
            public void remove() {
                this.level2It.remove();
            }
        };
    }
}

