/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.model;

import java.io.IOException;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.impl.AnalysedTextFactoryImpl;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;

public abstract class AnalysedTextFactory {
    private static AnalysedTextFactory defaultInstance = new AnalysedTextFactoryImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AnalysedText createAnalysedText(ContentItem ci, Blob blob) throws IOException {
        ci.getLock().readLock().lock();
        try {
            AnalysedText existing = (AnalysedText)ci.getPart(AnalysedText.ANALYSED_TEXT_URI, AnalysedText.class);
            throw new IllegalStateException("The AnalysedText ContentPart already exists (impl: " + existing.getClass().getSimpleName() + "| blob: " + existing.getBlob().getMimeType() + ")");
        }
        catch (NoSuchPartException existing) {
            ci.getLock().readLock().unlock();
        }
        catch (ClassCastException e) {
            try {
                throw new IllegalStateException("A ContentPart with the URI '" + AnalysedText.ANALYSED_TEXT_URI + "' already exists but the parts " + "type is not compatible with " + AnalysedText.class.getSimpleName() + "!", e);
            }
            catch (Throwable throwable) {
                ci.getLock().readLock().unlock();
                throw throwable;
            }
        }
        AnalysedText at = this.createAnalysedText(blob);
        ci.getLock().writeLock().lock();
        try {
            ci.addPart(AnalysedText.ANALYSED_TEXT_URI, (Object)at);
        }
        finally {
            ci.getLock().writeLock().unlock();
        }
        return at;
    }

    public abstract AnalysedText createAnalysedText(Blob var1) throws IOException;

    public static final AnalysedTextFactory getDefaultInstance() {
        return defaultInstance;
    }
}

