/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.dependency;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.enhancer.nlp.dependency.GrammaticalRelationCategory;

public enum GrammaticalRelation {
    Complement(GrammaticalRelationCategory.Argument),
    Dependent(GrammaticalRelationCategory.DependencyLabel),
    Modifier(Dependent),
    Object(Complement),
    AbbreviationModifier(Modifier),
    AdjectivalComplement(Complement),
    AdjectivalModifier(Modifier),
    AdverbialClauseModifier(Modifier),
    AdverbialModifier(Modifier),
    Agent(GrammaticalRelationCategory.Argument),
    AppositionalModifier(Modifier),
    Attributive(Complement),
    Auxiliary(Dependent),
    ClausalComplementWithExternalSubject(Complement),
    ClausalComplementWithInternalSubject(Complement),
    Subject(GrammaticalRelationCategory.Argument),
    ClausalSubject(Subject),
    Complementizer(Complement),
    CompountNumberElement(Modifier),
    Conjunct(Dependent),
    ControllingSubject(GrammaticalRelationCategory.SemanticDependent),
    Coordination(Dependent),
    Copula(GrammaticalRelationCategory.Auxiliary),
    Determiner(Modifier),
    DirectObject(Object),
    Discourse(Modifier),
    Expletive(Dependent),
    IndirectObject(Object),
    InfinitivalModifier(Modifier),
    Marker(Complement),
    MeasurePhraseModifier(Modifier),
    MultiWordExpression(Modifier),
    NegationModifier(AdverbialModifier),
    NominalSubject(Subject),
    NounCompoundModifier(Modifier),
    NounPhraseAsAdverbialModifier(Modifier),
    NumericModifier(Modifier),
    ObjectOfPreposition(Object),
    Parataxis(Dependent),
    ParticipalModifier(Modifier),
    PassiveAuxiliary(GrammaticalRelationCategory.Auxiliary),
    PassiveClausalSubject(ClausalSubject),
    PassiveNominalSubject(NominalSubject),
    PhrasalVerbParticle(Modifier),
    PossessionModifier(Modifier),
    PossessiveModifier(Modifier),
    Preconjunct(Modifier),
    Predeterminer(Modifier),
    PrepositionalModifier(Modifier),
    PrepositionalClausalModifier(PrepositionalModifier),
    PrepositionalComplement(Complement),
    Punctuation(Dependent),
    PurposeClauseModifier(Modifier),
    QuantifierModifier(Modifier),
    Referent(Dependent),
    Relative(Complement),
    RelativeClauseModifier(Modifier),
    Root(GrammaticalRelationCategory.DependencyLabel),
    TemporalModifier(NounPhraseAsAdverbialModifier);

    private GrammaticalRelationCategory category;
    private GrammaticalRelation parent;
    private static final Map<GrammaticalRelation, Set<GrammaticalRelation>> transitiveClosureMap;

    private GrammaticalRelation(GrammaticalRelationCategory category) {
        this(category, null);
    }

    private GrammaticalRelation(GrammaticalRelation parent) {
        this(null, parent);
    }

    private GrammaticalRelation(GrammaticalRelationCategory category, GrammaticalRelation parent) {
        this.parent = parent;
        this.category = category;
    }

    public GrammaticalRelationCategory getCategory() {
        return this.category;
    }

    public GrammaticalRelation getParent() {
        return this.parent;
    }

    public Set<GrammaticalRelation> hierarchy() {
        return transitiveClosureMap.get((Object)this);
    }

    static {
        transitiveClosureMap = new EnumMap<GrammaticalRelation, Set<GrammaticalRelation>>(GrammaticalRelation.class);
        for (GrammaticalRelation relation : GrammaticalRelation.values()) {
            EnumSet<GrammaticalRelation> parents = EnumSet.of(relation);
            GrammaticalRelation relationParent = relation.getParent();
            Set<GrammaticalRelation> transParents = transitiveClosureMap.get((Object)relationParent);
            if (transParents != null) {
                parents.addAll(transParents);
            } else if (relationParent != null) {
                parents.add(relationParent);
            }
            transitiveClosureMap.put(relation, parents);
        }
    }
}

