/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.dependency;

import org.apache.stanbol.enhancer.nlp.dependency.GrammaticalRelationTag;
import org.apache.stanbol.enhancer.nlp.model.Span;

public class DependencyRelation {
    private GrammaticalRelationTag grammaticalRelationTag;
    private boolean isDependent;
    private Span partner;

    public DependencyRelation(GrammaticalRelationTag grammaticalRelationTag, boolean isDependent, Span partner) {
        if (grammaticalRelationTag == null) {
            throw new IllegalArgumentException("The grammatical relation tag cannot be null");
        }
        this.grammaticalRelationTag = grammaticalRelationTag;
        this.isDependent = isDependent;
        this.partner = partner;
    }

    public GrammaticalRelationTag getGrammaticalRelationTag() {
        return this.grammaticalRelationTag;
    }

    public boolean isDependent() {
        return this.isDependent;
    }

    public Span getPartner() {
        return this.partner;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.grammaticalRelationTag.hashCode();
        result = 31 * result + (this.isDependent ? 1231 : 1237);
        result = 31 * result + (this.partner == null ? 0 : this.partner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyRelation other = (DependencyRelation)obj;
        if (this.partner == null ? other.partner != null : !this.partner.equals(other.partner)) {
            return false;
        }
        return this.grammaticalRelationTag.equals(other.grammaticalRelationTag) && this.isDependent == other.isDependent;
    }
}

