/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.coref;

import java.util.Collections;
import java.util.Set;
import org.apache.stanbol.enhancer.nlp.model.Span;

public class CorefFeature {
    private boolean isRepresentative;
    private Set<Span> mentions;

    public CorefFeature(boolean isRepresentative, Set<Span> mentions) {
        if (mentions == null || mentions.isEmpty()) {
            throw new IllegalArgumentException("The mentions set cannot be null or empty");
        }
        this.isRepresentative = isRepresentative;
        this.mentions = Collections.unmodifiableSet(mentions);
    }

    public boolean isRepresentative() {
        return this.isRepresentative;
    }

    public Set<Span> getMentions() {
        return this.mentions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isRepresentative ? 1231 : 1237);
        result = 31 * result + this.mentions.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorefFeature other = (CorefFeature)obj;
        return this.isRepresentative == other.isRepresentative && this.mentions.equals(other.mentions);
    }
}

