/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.json.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.servlet.ServletContext;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.felix.scr.annotations.Reference;
import org.apache.stanbol.enhancer.nlp.json.AnalyzedTextSerializer;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json"})
public class AnalyzedTextWriter
implements MessageBodyWriter<AnalysedText> {
    Logger log = LoggerFactory.getLogger(AnalyzedTextWriter.class);
    @Context
    protected ServletContext servletContext;
    @Reference
    protected AnalyzedTextSerializer serializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final AnalyzedTextSerializer getSerializer() {
        if (this.serializer == null) {
            AnalyzedTextWriter analyzedTextWriter = this;
            synchronized (analyzedTextWriter) {
                ServiceReference reference;
                if (this.serializer != null) {
                    return this.serializer;
                }
                Object s = this.servletContext.getAttribute(AnalyzedTextSerializer.class.getName());
                if (s != null && s instanceof AnalyzedTextSerializer) {
                    this.serializer = (AnalyzedTextSerializer)s;
                    return this.serializer;
                }
                Object bc = this.servletContext.getAttribute(BundleContext.class.getName());
                if (bc != null && bc instanceof BundleContext && (reference = ((BundleContext)bc).getServiceReference(AnalyzedTextSerializer.class.getName())) != null) {
                    this.serializer = (AnalyzedTextSerializer)((BundleContext)bc).getService(reference);
                    return this.serializer;
                }
                this.serializer = AnalyzedTextSerializer.getDefaultInstance();
            }
        }
        return this.serializer;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return AnalysedText.class.isAssignableFrom(type);
    }

    public long getSize(AnalysedText t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(AnalysedText at, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String charsetName = (String)mediaType.getParameters().get("charset");
        Charset charset = null;
        if (charsetName != null) {
            try {
                charset = Charset.forName(charsetName);
            }
            catch (IllegalCharsetNameException e) {
                this.log.warn("Unable to use charset defined by the parsed MediaType '" + mediaType + "! Fallback to default (UTF-8).", (Throwable)e);
            }
            catch (UnsupportedCharsetException e) {
                this.log.warn("Charset defined by the parsed MediaType '" + mediaType + " is not supported! Fallback to default (UTF-8).", (Throwable)e);
            }
        }
        this.getSerializer().serialize(at, entityStream, charset);
    }
}

