/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.json.valuetype.impl;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.nlp.json.JsonUtils;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeParser;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeSerializer;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.pos.LexicalCategory;
import org.apache.stanbol.enhancer.nlp.pos.Pos;
import org.apache.stanbol.enhancer.nlp.pos.PosTag;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE)
@Service(value={ValueTypeParser.class, ValueTypeSerializer.class})
@Property(name="type", value={"org.apache.stanbol.enhancer.nlp.pos.PosTag"})
public class PosTagSupport
implements ValueTypeParser<PosTag>,
ValueTypeSerializer<PosTag> {
    public static final String TYPE_VALUE = "org.apache.stanbol.enhancer.nlp.pos.PosTag";
    Map<PosTagInfo, PosTag> posTagCache = Collections.synchronizedMap(new LinkedHashMap<PosTagInfo, PosTag>(16, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<PosTagInfo, PosTag> arg0) {
            return this.size() > 1024;
        }
    });

    @Override
    public Class<PosTag> getType() {
        return PosTag.class;
    }

    @Override
    public PosTag parse(ObjectNode jValue, AnalysedText at) {
        PosTagInfo tagInfo = new PosTagInfo();
        JsonNode tag = jValue.path("tag");
        if (!tag.isTextual()) {
            throw new IllegalStateException("Unable to parse PosTag. The value of the 'tag' field MUST have a textual value (json: " + jValue + ")");
        }
        tagInfo.tag = tag.getTextValue();
        tagInfo.categories = jValue.has("lc") ? JsonUtils.parseEnum(jValue, "lc", LexicalCategory.class) : EnumSet.noneOf(LexicalCategory.class);
        tagInfo.pos = jValue.has("pos") ? JsonUtils.parseEnum(jValue, "pos", Pos.class) : EnumSet.noneOf(Pos.class);
        PosTag posTag = this.posTagCache.get(tagInfo);
        if (posTag == null) {
            posTag = new PosTag(tagInfo.tag, tagInfo.categories, tagInfo.pos);
            this.posTagCache.put(tagInfo, posTag);
        }
        return posTag;
    }

    @Override
    public ObjectNode serialize(ObjectMapper mapper, PosTag value) {
        ObjectNode jPosTag = mapper.createObjectNode();
        jPosTag.put("tag", value.getTag());
        if (value.getPos().size() == 1) {
            jPosTag.put("pos", ((Pos)value.getPos().iterator().next()).ordinal());
        } else if (!value.getPos().isEmpty()) {
            ArrayNode jPos = mapper.createArrayNode();
            for (Pos pos : value.getPos()) {
                jPos.add(pos.ordinal());
            }
            jPosTag.put("pos", (JsonNode)jPos);
        }
        if (!value.getCategories().isEmpty()) {
            EnumSet<LexicalCategory> categories = EnumSet.noneOf(LexicalCategory.class);
            categories.addAll(value.getCategories());
            for (Pos pos : value.getPos()) {
                categories.removeAll(pos.categories());
            }
            if (categories.size() == 1) {
                jPosTag.put("lc", ((LexicalCategory)categories.iterator().next()).ordinal());
            } else if (!categories.isEmpty()) {
                ArrayNode jCategory = mapper.createArrayNode();
                for (LexicalCategory lc : categories) {
                    jCategory.add(lc.ordinal());
                }
                jPosTag.put("lc", (JsonNode)jCategory);
            }
        }
        return jPosTag;
    }

    private class PosTagInfo {
        protected String tag;
        protected EnumSet<LexicalCategory> categories;
        protected EnumSet<Pos> pos;

        private PosTagInfo() {
        }

        public int hashCode() {
            return this.tag.hashCode() + (this.categories != null ? this.categories.hashCode() : 0) + (this.pos != null ? this.pos.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof PosTagInfo && this.tag.equals(this.tag) && this.categories.equals(this.categories) && this.pos.equals(this.pos);
        }
    }
}

