/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.json.valuetype.impl;

import java.util.EnumSet;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.nlp.json.JsonUtils;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeParser;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeParserRegistry;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeSerializer;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeSerializerRegistry;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.morpho.Case;
import org.apache.stanbol.enhancer.nlp.morpho.CaseTag;
import org.apache.stanbol.enhancer.nlp.morpho.Definitness;
import org.apache.stanbol.enhancer.nlp.morpho.Gender;
import org.apache.stanbol.enhancer.nlp.morpho.GenderTag;
import org.apache.stanbol.enhancer.nlp.morpho.MorphoFeatures;
import org.apache.stanbol.enhancer.nlp.morpho.NumberFeature;
import org.apache.stanbol.enhancer.nlp.morpho.NumberTag;
import org.apache.stanbol.enhancer.nlp.morpho.Person;
import org.apache.stanbol.enhancer.nlp.morpho.Tense;
import org.apache.stanbol.enhancer.nlp.morpho.TenseTag;
import org.apache.stanbol.enhancer.nlp.morpho.VerbMood;
import org.apache.stanbol.enhancer.nlp.morpho.VerbMoodTag;
import org.apache.stanbol.enhancer.nlp.pos.PosTag;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE)
@Service(value={ValueTypeParser.class, ValueTypeSerializer.class})
@Property(name="type", value={"org.apache.stanbol.enhancer.nlp.morpho.MorphoFeatures"})
public class MorphoFeaturesSupport
implements ValueTypeParser<MorphoFeatures>,
ValueTypeSerializer<MorphoFeatures> {
    private final Logger log = LoggerFactory.getLogger(MorphoFeaturesSupport.class);
    public static final String TYPE_VALUE = "org.apache.stanbol.enhancer.nlp.morpho.MorphoFeatures";
    @Reference
    protected ValueTypeSerializerRegistry serializerRegistry;
    @Reference
    protected ValueTypeParserRegistry parserRegistry;

    protected ValueTypeSerializer<PosTag> getPosTagSerializer() {
        if (this.serializerRegistry == null) {
            this.serializerRegistry = ValueTypeSerializerRegistry.getInstance();
        }
        return this.serializerRegistry.getSerializer(PosTag.class);
    }

    protected ValueTypeParser<PosTag> getPosTagParser() {
        if (this.parserRegistry == null) {
            this.parserRegistry = ValueTypeParserRegistry.getInstance();
        }
        return this.parserRegistry.getParser(PosTag.class);
    }

    @Override
    public Class<MorphoFeatures> getType() {
        return MorphoFeatures.class;
    }

    @Override
    public ObjectNode serialize(ObjectMapper mapper, MorphoFeatures morpho) {
        List verbMoodList;
        List tenseList;
        List posList;
        List persons;
        List numberList;
        List genderList;
        List definitnesses;
        ObjectNode jMorpho = mapper.createObjectNode();
        jMorpho.put("lemma", morpho.getLemma());
        List caseList = morpho.getCaseList();
        if (!caseList.isEmpty()) {
            ArrayNode jCases = mapper.createArrayNode();
            for (Object caseTag : caseList) {
                ObjectNode jCase = mapper.createObjectNode();
                jCase.put("tag", caseTag.getTag());
                if (caseTag.getCase() != null) {
                    jCase.put("type", caseTag.getCase().name());
                }
                jCases.add((JsonNode)jCase);
            }
            jMorpho.put("case", (JsonNode)jCases);
        }
        if (!(definitnesses = morpho.getDefinitnessList()).isEmpty()) {
            if (definitnesses.size() == 1) {
                jMorpho.put("definitness", ((Definitness)definitnesses.get(0)).name());
            } else {
                ArrayNode jDefinitnesses = mapper.createArrayNode();
                for (Definitness d : definitnesses) {
                    jDefinitnesses.add(d.name());
                }
                jMorpho.put("definitness", (JsonNode)jDefinitnesses);
            }
        }
        if (!(genderList = morpho.getGenderList()).isEmpty()) {
            ArrayNode jGenders = mapper.createArrayNode();
            for (GenderTag genderTag : genderList) {
                ObjectNode jGender = mapper.createObjectNode();
                jGender.put("tag", genderTag.getTag());
                if (genderTag.getGender() != null) {
                    jGender.put("type", genderTag.getGender().name());
                }
                jGenders.add((JsonNode)jGender);
            }
            jMorpho.put("gender", (JsonNode)jGenders);
        }
        if (!(numberList = morpho.getNumberList()).isEmpty()) {
            ArrayNode jNumbers = mapper.createArrayNode();
            for (Object numberTag : numberList) {
                ObjectNode jNumber = mapper.createObjectNode();
                jNumber.put("tag", numberTag.getTag());
                if (numberTag.getNumber() != null) {
                    jNumber.put("type", numberTag.getNumber().name());
                }
                jNumbers.add((JsonNode)jNumber);
            }
            jMorpho.put("number", (JsonNode)jNumbers);
        }
        if (!(persons = morpho.getPersonList()).isEmpty()) {
            if (persons.size() == 1) {
                jMorpho.put("person", ((Person)persons.get(0)).name());
            } else {
                ArrayNode jPersons = mapper.createArrayNode();
                for (Person d : persons) {
                    jPersons.add(d.name());
                }
                jMorpho.put("person", (JsonNode)jPersons);
            }
        }
        if (!(posList = morpho.getPosList()).isEmpty()) {
            ArrayNode jPosTags = mapper.createArrayNode();
            for (PosTag posTag : posList) {
                jPosTags.add((JsonNode)this.getPosTagSerializer().serialize(mapper, posTag));
            }
            jMorpho.put("pos", (JsonNode)jPosTags);
        }
        if (!(tenseList = morpho.getTenseList()).isEmpty()) {
            ArrayNode jTenses = mapper.createArrayNode();
            for (TenseTag tenseTag : tenseList) {
                ObjectNode jTense = mapper.createObjectNode();
                jTense.put("tag", tenseTag.getTag());
                if (tenseTag.getTense() != null) {
                    jTense.put("type", tenseTag.getTense().name());
                }
                jTenses.add((JsonNode)jTense);
            }
            jMorpho.put("tense", (JsonNode)jTenses);
        }
        if (!(verbMoodList = morpho.getVerbMoodList()).isEmpty()) {
            ArrayNode jMoods = mapper.createArrayNode();
            for (VerbMoodTag verbMoodTag : verbMoodList) {
                ObjectNode jMood = mapper.createObjectNode();
                jMood.put("tag", verbMoodTag.getTag());
                if (verbMoodTag.getVerbForm() != null) {
                    jMood.put("type", verbMoodTag.getVerbForm().name());
                }
                jMoods.add((JsonNode)jMood);
            }
            jMorpho.put("verb-mood", (JsonNode)jMoods);
        }
        return jMorpho;
    }

    @Override
    public MorphoFeatures parse(ObjectNode jMorpho, AnalysedText at) {
        EnumSet<Case> type;
        JsonNode tag;
        JsonNode member;
        int i;
        JsonNode jLemma = jMorpho.path("lemma");
        if (!jLemma.isTextual()) {
            throw new IllegalStateException("Field 'lemma' MUST provide a String value (parsed JSON: " + jMorpho);
        }
        MorphoFeatures morpho = new MorphoFeatures(jLemma.asText());
        JsonNode node = jMorpho.path("case");
        if (node.isArray()) {
            ArrayNode jCases = (ArrayNode)node;
            for (i = 0; i < jCases.size(); ++i) {
                member = jCases.get(i);
                if (member.isObject()) {
                    ObjectNode jCase = (ObjectNode)member;
                    tag = jCase.path("tag");
                    if (tag.isTextual()) {
                        type = JsonUtils.parseEnum(jCase, "type", Case.class);
                        if (type.isEmpty()) {
                            morpho.addCase(new CaseTag(tag.getTextValue()));
                            continue;
                        }
                        morpho.addCase(new CaseTag(tag.getTextValue(), (Case)type.iterator().next()));
                        continue;
                    }
                    this.log.warn("Unable to parse CaseTag becuase 'tag' value is missing or is not a String (json: " + jCase.toString() + ")");
                    continue;
                }
                this.log.warn("Unable to parse CaseTag from " + member.toString());
            }
        } else if (!node.isMissingNode()) {
            this.log.warn("Unable to parse CaseTags (Json Array expected as value for field 'case' but was " + node);
        }
        if (jMorpho.has("definitness")) {
            for (Definitness d : JsonUtils.parseEnum(jMorpho, "definitness", Definitness.class)) {
                morpho.addDefinitness(d);
            }
        }
        if ((node = jMorpho.path("gender")).isArray()) {
            ArrayNode jGenders = (ArrayNode)node;
            for (i = 0; i < jGenders.size(); ++i) {
                member = jGenders.get(i);
                if (member.isObject()) {
                    ObjectNode jGender = (ObjectNode)member;
                    tag = jGender.path("tag");
                    if (tag.isTextual()) {
                        type = JsonUtils.parseEnum(jGender, "type", Gender.class);
                        if (type.isEmpty()) {
                            morpho.addGender(new GenderTag(tag.getTextValue()));
                            continue;
                        }
                        morpho.addGender(new GenderTag(tag.getTextValue(), (Gender)type.iterator().next()));
                        continue;
                    }
                    this.log.warn("Unable to parse GenderTag becuase 'tag' value is missing or is not a String (json: " + jGender.toString() + ")");
                    continue;
                }
                this.log.warn("Unable to parse GenderTag from " + member.toString());
            }
        } else if (!node.isMissingNode()) {
            this.log.warn("Unable to parse GenderTag (Json Array expected as value for field 'case' but was " + node);
        }
        if ((node = jMorpho.path("number")).isArray()) {
            ArrayNode jNumbers = (ArrayNode)node;
            for (i = 0; i < jNumbers.size(); ++i) {
                member = jNumbers.get(i);
                if (member.isObject()) {
                    ObjectNode jNumber = (ObjectNode)member;
                    tag = jNumber.path("tag");
                    if (tag.isTextual()) {
                        type = JsonUtils.parseEnum(jNumber, "type", NumberFeature.class);
                        if (type.isEmpty()) {
                            morpho.addNumber(new NumberTag(tag.getTextValue()));
                            continue;
                        }
                        morpho.addNumber(new NumberTag(tag.getTextValue(), (NumberFeature)type.iterator().next()));
                        continue;
                    }
                    this.log.warn("Unable to parse NumberTag becuase 'tag' value is missing or is not a String (json: " + jNumber.toString() + ")");
                    continue;
                }
                this.log.warn("Unable to parse NumberTag from " + member.toString());
            }
        } else if (!node.isMissingNode()) {
            this.log.warn("Unable to parse NumberTag (Json Array expected as value for field 'case' but was " + node);
        }
        if (jMorpho.has("person")) {
            for (Person p : JsonUtils.parseEnum(jMorpho, "person", Person.class)) {
                morpho.addPerson(p);
            }
        }
        if ((node = jMorpho.path("pos")).isArray()) {
            ArrayNode jPosTags = (ArrayNode)node;
            for (i = 0; i < jPosTags.size(); ++i) {
                member = jPosTags.get(i);
                if (member.isObject()) {
                    ObjectNode jPosTag = (ObjectNode)member;
                    morpho.addPos(this.getPosTagParser().parse(jPosTag, at));
                    continue;
                }
                this.log.warn("Unable to parse PosTag from " + member.toString());
            }
        } else if (!node.isMissingNode()) {
            this.log.warn("Unable to parse PosTag (Json Array expected as value for field 'case' but was " + node);
        }
        if ((node = jMorpho.path("tense")).isArray()) {
            ArrayNode jTenses = (ArrayNode)node;
            for (i = 0; i < jTenses.size(); ++i) {
                member = jTenses.get(i);
                if (member.isObject()) {
                    ObjectNode jTense = (ObjectNode)member;
                    tag = jTense.path("tag");
                    if (tag.isTextual()) {
                        type = JsonUtils.parseEnum(jTense, "type", Tense.class);
                        if (type.isEmpty()) {
                            morpho.addTense(new TenseTag(tag.getTextValue()));
                            continue;
                        }
                        morpho.addTense(new TenseTag(tag.getTextValue(), (Tense)type.iterator().next()));
                        continue;
                    }
                    this.log.warn("Unable to parse TenseTag becuase 'tag' value is missing or is not a String (json: " + jTense.toString() + ")");
                    continue;
                }
                this.log.warn("Unable to parse TenseTag from " + member.toString());
            }
        } else if (!node.isMissingNode()) {
            this.log.warn("Unable to parse TenseTag (Json Array expected as value for field 'case' but was " + node);
        }
        if ((node = jMorpho.path("verb-mood")).isArray()) {
            ArrayNode jVerbMoods = (ArrayNode)node;
            for (i = 0; i < jVerbMoods.size(); ++i) {
                member = jVerbMoods.get(i);
                if (member.isObject()) {
                    ObjectNode jVerbMood = (ObjectNode)member;
                    tag = jVerbMood.path("tag");
                    if (tag.isTextual()) {
                        type = JsonUtils.parseEnum(jVerbMood, "type", VerbMood.class);
                        if (type.isEmpty()) {
                            morpho.addVerbForm(new VerbMoodTag(tag.getTextValue()));
                            continue;
                        }
                        morpho.addVerbForm(new VerbMoodTag(tag.getTextValue(), (VerbMood)type.iterator().next()));
                        continue;
                    }
                    this.log.warn("Unable to parse VerbMoodTag becuase 'tag' value is missing or is not a String (json: " + jVerbMood.toString() + ")");
                    continue;
                }
                this.log.warn("Unable to parse VerbMoodTag from " + member.toString());
            }
        } else if (!node.isMissingNode()) {
            this.log.warn("Unable to parse VerbMoodTag (Json Array expected as value for field 'case' but was " + node);
        }
        return morpho;
    }

    protected void bindSerializerRegistry(ValueTypeSerializerRegistry valueTypeSerializerRegistry) {
        this.serializerRegistry = valueTypeSerializerRegistry;
    }

    protected void unbindSerializerRegistry(ValueTypeSerializerRegistry valueTypeSerializerRegistry) {
        if (this.serializerRegistry == valueTypeSerializerRegistry) {
            this.serializerRegistry = null;
        }
    }

    protected void bindParserRegistry(ValueTypeParserRegistry valueTypeParserRegistry) {
        this.parserRegistry = valueTypeParserRegistry;
    }

    protected void unbindParserRegistry(ValueTypeParserRegistry valueTypeParserRegistry) {
        if (this.parserRegistry == valueTypeParserRegistry) {
            this.parserRegistry = null;
        }
    }
}

