/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.json.valuetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeSerializer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE)
@Service(value={ValueTypeSerializerRegistry.class})
public class ValueTypeSerializerRegistry {
    private final Logger log = LoggerFactory.getLogger(ValueTypeSerializerRegistry.class);
    private static ValueTypeSerializerRegistry instance;
    ReadWriteLock serializerLock = new ReentrantReadWriteLock();
    private boolean inOsgi;
    Map<Class<?>, ValueTypeSerializer<?>> valueTypeSerializers;
    Map<Class<?>, List<ServiceReference>> valueTypeSerializerRefs;
    ServiceTracker serializerTracker;

    public static final ValueTypeSerializerRegistry getInstance() {
        if (instance == null) {
            instance = new ValueTypeSerializerRegistry();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ValueTypeSerializer<T> getSerializer(Class<T> type) {
        if (!this.inOsgi && this.valueTypeSerializers == null) {
            this.initValueTypeSerializer();
        }
        if (!this.inOsgi) {
            this.serializerLock.readLock().lock();
            try {
                ValueTypeSerializer<?> valueTypeSerializer = this.valueTypeSerializers.get(type);
                return valueTypeSerializer;
            }
            finally {
                this.serializerLock.readLock().unlock();
            }
        }
        ServiceTracker serializerTracker = this.serializerTracker;
        if (this.valueTypeSerializerRefs == null && serializerTracker != null) {
            ServiceTracker serviceTracker = serializerTracker;
            synchronized (serviceTracker) {
                if (this.valueTypeSerializerRefs == null) {
                    this.valueTypeSerializerRefs = new HashMap();
                    serializerTracker.open();
                }
            }
        }
        this.serializerLock.readLock().lock();
        try {
            List<ServiceReference> refs = this.valueTypeSerializerRefs.get(type);
            ValueTypeSerializer valueTypeSerializer = refs == null || refs.isEmpty() ? null : (ValueTypeSerializer)serializerTracker.getService(refs.get(refs.size() - 1));
            return valueTypeSerializer;
        }
        finally {
            this.serializerLock.readLock().unlock();
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.inOsgi = true;
        BundleContext bc = ctx.getBundleContext();
        this.serializerTracker = new ServiceTracker(bc, ValueTypeSerializer.class.getName(), (ServiceTrackerCustomizer)new SerializerTracker(bc));
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.inOsgi = false;
        this.serializerTracker.close();
        this.serializerTracker = null;
        this.serializerLock.writeLock().lock();
        try {
            if (this.valueTypeSerializers != null) {
                this.valueTypeSerializers.clear();
                this.valueTypeSerializers = null;
            }
            if (this.valueTypeSerializerRefs != null) {
                this.valueTypeSerializerRefs.clear();
                this.valueTypeSerializerRefs = null;
            }
        }
        finally {
            this.serializerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initValueTypeSerializer() {
        this.serializerLock.writeLock().lock();
        try {
            if (this.valueTypeSerializers == null) {
                this.valueTypeSerializers = new HashMap();
                ServiceLoader<ValueTypeSerializer> loader = ServiceLoader.load(ValueTypeSerializer.class);
                for (ValueTypeSerializer vts : loader) {
                    ValueTypeSerializer<?> serializer = this.valueTypeSerializers.get(vts.getType());
                    if (serializer != null) {
                        this.log.warn("Multiple Serializers for type {} (keep: {}, ignoreing: {}", new Object[]{vts.getType(), serializer, vts});
                        continue;
                    }
                    this.valueTypeSerializers.put(vts.getType(), vts);
                }
            }
        }
        finally {
            this.serializerLock.writeLock().unlock();
        }
    }

    private final class SerializerTracker
    implements ServiceTrackerCustomizer {
        private final BundleContext bc;

        private SerializerTracker(BundleContext bc) {
            this.bc = bc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            ValueTypeSerializer service = (ValueTypeSerializer)this.bc.getService(reference);
            if (service != null) {
                ValueTypeSerializerRegistry.this.serializerLock.writeLock().lock();
                try {
                    List<ServiceReference> refs = ValueTypeSerializerRegistry.this.valueTypeSerializerRefs.get(service.getType());
                    if (refs == null) {
                        refs = new ArrayList<ServiceReference>(2);
                        ValueTypeSerializerRegistry.this.valueTypeSerializerRefs.put(service.getType(), refs);
                    }
                    refs.add(reference);
                    if (refs.size() > 1) {
                        Collections.sort(refs);
                    }
                }
                finally {
                    ValueTypeSerializerRegistry.this.serializerLock.writeLock().unlock();
                }
            }
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference reference, Object service) {
            ValueTypeSerializer vts = (ValueTypeSerializer)service;
            ValueTypeSerializerRegistry.this.serializerLock.writeLock().lock();
            try {
                List<ServiceReference> refs = ValueTypeSerializerRegistry.this.valueTypeSerializerRefs.get(vts.getType());
                if (refs != null && refs.remove(reference) && refs.isEmpty() && ValueTypeSerializerRegistry.this.valueTypeSerializers != null) {
                    ValueTypeSerializerRegistry.this.valueTypeSerializers.remove(vts.getType());
                }
            }
            finally {
                ValueTypeSerializerRegistry.this.serializerLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference reference, Object service) {
            ValueTypeSerializer vts = (ValueTypeSerializer)service;
            try {
                List<ServiceReference> refs = ValueTypeSerializerRegistry.this.valueTypeSerializerRefs.get(vts.getType());
                if (refs != null) {
                    refs.remove(reference);
                } else {
                    refs = new ArrayList<ServiceReference>(2);
                    ValueTypeSerializerRegistry.this.valueTypeSerializerRefs.put(vts.getType(), refs);
                }
                refs.add(reference);
                if (refs.size() > 1) {
                    Collections.sort(refs);
                }
            }
            finally {
                ValueTypeSerializerRegistry.this.serializerLock.writeLock().unlock();
            }
        }
    }
}

