/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.json.valuetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeParser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE)
@Service(value={ValueTypeParserRegistry.class})
public class ValueTypeParserRegistry {
    private final Logger log = LoggerFactory.getLogger(ValueTypeParserRegistry.class);
    private static ValueTypeParserRegistry instance;
    ReadWriteLock parserLock = new ReentrantReadWriteLock();
    private boolean inOsgi;
    Map<Class<?>, ValueTypeParser<?>> valueTypeParsers;
    Map<Class<?>, List<ServiceReference>> valueTypeParserRefs;
    ServiceTracker parserTracker;

    public static final ValueTypeParserRegistry getInstance() {
        if (instance == null) {
            instance = new ValueTypeParserRegistry();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ValueTypeParser<T> getParser(Class<T> type) {
        if (!this.inOsgi && this.valueTypeParsers == null) {
            this.initValueTypeParser();
        }
        if (!this.inOsgi) {
            this.parserLock.readLock().lock();
            try {
                ValueTypeParser<?> valueTypeParser = this.valueTypeParsers.get(type);
                return valueTypeParser;
            }
            finally {
                this.parserLock.readLock().unlock();
            }
        }
        ServiceTracker parserTracker = this.parserTracker;
        if (this.valueTypeParserRefs == null && parserTracker != null) {
            ServiceTracker serviceTracker = parserTracker;
            synchronized (serviceTracker) {
                if (this.valueTypeParserRefs == null) {
                    this.valueTypeParserRefs = new HashMap();
                    parserTracker.open();
                }
            }
        }
        this.parserLock.readLock().lock();
        try {
            List<ServiceReference> refs = this.valueTypeParserRefs.get(type);
            ValueTypeParser valueTypeParser = refs == null || refs.isEmpty() ? null : (ValueTypeParser)parserTracker.getService(refs.get(refs.size() - 1));
            return valueTypeParser;
        }
        finally {
            this.parserLock.readLock().unlock();
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.inOsgi = true;
        BundleContext bc = ctx.getBundleContext();
        this.parserTracker = new ServiceTracker(bc, ValueTypeParser.class.getName(), (ServiceTrackerCustomizer)new ParserTracker(bc));
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.inOsgi = false;
        if (this.parserTracker != null) {
            this.parserTracker.close();
            this.parserTracker = null;
        }
        this.parserLock.writeLock().lock();
        try {
            if (this.valueTypeParsers != null) {
                this.valueTypeParsers.clear();
                this.valueTypeParsers = null;
            }
            if (this.valueTypeParserRefs != null) {
                this.valueTypeParserRefs.clear();
                this.valueTypeParserRefs = null;
            }
        }
        finally {
            this.parserLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initValueTypeParser() {
        this.parserLock.writeLock().lock();
        try {
            if (this.valueTypeParsers == null) {
                this.valueTypeParsers = new HashMap();
                ServiceLoader<ValueTypeParser> loader = ServiceLoader.load(ValueTypeParser.class);
                Iterator<ValueTypeParser> it = loader.iterator();
                while (it.hasNext()) {
                    try {
                        ValueTypeParser vts = it.next();
                        ValueTypeParser<?> serializer = this.valueTypeParsers.get(vts.getType());
                        if (serializer != null) {
                            this.log.warn("Multiple Parsers for type {} (keep: {}, ignoreing: {}", new Object[]{vts.getType(), serializer, vts});
                            continue;
                        }
                        this.valueTypeParsers.put(vts.getType(), vts);
                    }
                    catch (NoClassDefFoundError e) {
                        this.log.warn("Unable to load a ValueTypeParser service because class '" + e.getMessage() + " could not be loaded! This may happen if the " + "classpath mixes different versions of o.a.stanbol.enhancer.nlp* " + "modules!");
                    }
                }
            }
        }
        finally {
            this.parserLock.writeLock().unlock();
        }
    }

    private final class ParserTracker
    implements ServiceTrackerCustomizer {
        private final BundleContext bc;

        private ParserTracker(BundleContext bc) {
            this.bc = bc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            ValueTypeParser service = (ValueTypeParser)this.bc.getService(reference);
            ValueTypeParserRegistry.this.parserLock.writeLock().lock();
            try {
                List<ServiceReference> refs = ValueTypeParserRegistry.this.valueTypeParserRefs.get(service.getType());
                if (refs == null) {
                    refs = new ArrayList<ServiceReference>(2);
                    ValueTypeParserRegistry.this.valueTypeParserRefs.put(service.getType(), refs);
                }
                refs.add(reference);
                if (refs.size() > 1) {
                    Collections.sort(refs);
                }
            }
            finally {
                ValueTypeParserRegistry.this.parserLock.writeLock().unlock();
            }
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference reference, Object service) {
            ValueTypeParser vts = (ValueTypeParser)service;
            ValueTypeParserRegistry.this.parserLock.writeLock().lock();
            try {
                List<ServiceReference> refs = ValueTypeParserRegistry.this.valueTypeParserRefs.get(vts.getType());
                if (refs != null && refs.remove(reference) && refs.isEmpty() && ValueTypeParserRegistry.this.valueTypeParsers != null) {
                    ValueTypeParserRegistry.this.valueTypeParsers.remove(vts.getType());
                }
            }
            finally {
                ValueTypeParserRegistry.this.parserLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference reference, Object service) {
            ValueTypeParser vts = (ValueTypeParser)service;
            try {
                List<ServiceReference> refs = ValueTypeParserRegistry.this.valueTypeParserRefs.get(vts.getType());
                if (refs != null) {
                    refs.remove(reference);
                } else {
                    refs = new ArrayList<ServiceReference>(2);
                    ValueTypeParserRegistry.this.valueTypeParserRefs.put(vts.getType(), refs);
                }
                refs.add(reference);
                if (refs.size() > 1) {
                    Collections.sort(refs);
                }
            }
            finally {
                ValueTypeParserRegistry.this.parserLock.writeLock().unlock();
            }
        }
    }
}

