/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeSerializer;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeSerializerRegistry;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.Span;
import org.apache.stanbol.enhancer.nlp.model.SpanTypeEnum;
import org.apache.stanbol.enhancer.nlp.model.annotation.Value;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE)
@Service(value={AnalyzedTextSerializer.class})
public class AnalyzedTextSerializer {
    Logger log = LoggerFactory.getLogger(AnalyzedTextSerializer.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static AnalyzedTextSerializer defaultInstance;
    protected ObjectMapper mapper = new ObjectMapper();
    @Reference
    protected ValueTypeSerializerRegistry valueTypeSerializerRegistry;

    public static final AnalyzedTextSerializer getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new AnalyzedTextSerializer(ValueTypeSerializerRegistry.getInstance());
        }
        return defaultInstance;
    }

    public AnalyzedTextSerializer() {
    }

    public AnalyzedTextSerializer(ValueTypeSerializerRegistry vtsr) {
        if (vtsr == null) {
            throw new IllegalArgumentException("The parsed ValueTypeSerializerRegistry MUST NOT be NULL!");
        }
        this.valueTypeSerializerRegistry = vtsr;
    }

    public void serialize(AnalysedText at, OutputStream out, Charset charset) throws IOException {
        if (at == null) {
            throw new IllegalArgumentException("The parsed AnalysedText MUST NOT be NULL!");
        }
        if (out == null) {
            throw new IllegalArgumentException("The parsed OutputStream MUST NOT be NULL");
        }
        if (charset == null) {
            charset = UTF8;
        }
        JsonFactory jsonFactory = this.mapper.getJsonFactory();
        JsonGenerator jg = jsonFactory.createJsonGenerator((Writer)new OutputStreamWriter(out, charset));
        jg.useDefaultPrettyPrinter();
        jg.writeStartObject();
        jg.writeArrayFieldStart("spans");
        jg.writeTree((JsonNode)this.writeSpan((Span)at));
        Iterator it = at.getEnclosed(EnumSet.allOf(SpanTypeEnum.class));
        while (it.hasNext()) {
            jg.writeTree((JsonNode)this.writeSpan((Span)it.next()));
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
    }

    private ObjectNode writeSpan(Span span) throws IOException {
        this.log.trace("wirte {}", (Object)span);
        ObjectNode jSpan = this.mapper.createObjectNode();
        jSpan.put("type", span.getType().name());
        jSpan.put("start", span.getStart());
        jSpan.put("end", span.getEnd());
        for (String key : span.getKeys()) {
            List values = span.getValues(key);
            if (values.size() == 1) {
                jSpan.put(key, (JsonNode)this.writeValue((Value)values.get(0)));
                continue;
            }
            ArrayNode jValues = jSpan.putArray(key);
            for (Value value : values) {
                jValues.add((JsonNode)this.writeValue(value));
            }
            jSpan.put(key, (JsonNode)jValues);
        }
        this.log.trace(" ... {}", (Object)jSpan);
        return jSpan;
    }

    private ObjectNode writeValue(Value<?> value) {
        ObjectNode jValue;
        Class<?> valueType = value.value().getClass();
        ValueTypeSerializer<?> vts = this.valueTypeSerializerRegistry.getSerializer(valueType);
        if (vts != null) {
            jValue = vts.serialize(this.mapper, value.value());
        } else {
            jValue = this.mapper.createObjectNode();
            jValue.put("value", this.mapper.valueToTree(value.value()));
        }
        jValue.put("class", valueType.getName());
        if (value.probability() != -1.0) {
            jValue.put("prob", value.probability());
        }
        return jValue;
    }

    protected void bindValueTypeSerializerRegistry(ValueTypeSerializerRegistry valueTypeSerializerRegistry) {
        this.valueTypeSerializerRegistry = valueTypeSerializerRegistry;
    }

    protected void unbindValueTypeSerializerRegistry(ValueTypeSerializerRegistry valueTypeSerializerRegistry) {
        if (this.valueTypeSerializerRegistry == valueTypeSerializerRegistry) {
            this.valueTypeSerializerRegistry = null;
        }
    }
}

