/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.nlp.json.JsonUtils;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeParser;
import org.apache.stanbol.enhancer.nlp.json.valuetype.ValueTypeParserRegistry;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.Sentence;
import org.apache.stanbol.enhancer.nlp.model.Span;
import org.apache.stanbol.enhancer.nlp.model.SpanTypeEnum;
import org.apache.stanbol.enhancer.nlp.model.annotation.Value;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.SerializableString;
import org.codehaus.jackson.io.SerializedString;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE)
@Service(value={AnalyzedTextParser.class})
public class AnalyzedTextParser {
    private final Logger log = LoggerFactory.getLogger(AnalyzedTextParser.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static AnalyzedTextParser defaultInstance;
    protected ObjectMapper mapper = new ObjectMapper();
    @Reference
    protected ValueTypeParserRegistry valueTypeParserRegistry;

    public static final AnalyzedTextParser getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new AnalyzedTextParser(ValueTypeParserRegistry.getInstance());
        }
        return defaultInstance;
    }

    public AnalyzedTextParser() {
    }

    public AnalyzedTextParser(ValueTypeParserRegistry vtpr) {
        if (vtpr == null) {
            throw new IllegalArgumentException("The parsed ValueTypeParserRegistry MUST NOT be NULL!");
        }
        this.valueTypeParserRegistry = vtpr;
    }

    public AnalysedText parse(InputStream in, Charset charset, AnalysedText at) throws IOException {
        JsonParser parser;
        if (in == null) {
            throw new IllegalArgumentException("The parsed InputStream MUST NOT be NULL!");
        }
        if (charset == null) {
            charset = UTF8;
        }
        if ((parser = this.mapper.getJsonFactory().createJsonParser((Reader)new InputStreamReader(in, charset))).nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("JSON serialized AnalyzedTexts MUST use a JSON Object as Root!");
        }
        if (!parser.nextFieldName((SerializableString)new SerializedString("spans"))) {
            throw new IOException("JSON serialized AnalyzedText MUST define the 'spans' field as first entry in the root JSON object!");
        }
        if (parser.nextValue() != JsonToken.START_ARRAY) {
            throw new IOException("The value of the 'span' field MUST BE an Json Array!");
        }
        boolean first = true;
        while (parser.nextValue() == JsonToken.START_OBJECT) {
            if (first) {
                this.parseAnalyzedTextSpan(parser.readValueAsTree(), at);
                first = false;
                continue;
            }
            this.parseSpan(at, parser.readValueAsTree());
        }
        return at;
    }

    private void parseAnalyzedTextSpan(JsonNode node, AnalysedText at) throws IOException {
        ArrayList<Map.Entry<String, JsonNode>> jAnnotations;
        if (node.isObject()) {
            ObjectNode jSpan = (ObjectNode)node;
            int[] spanPos = new int[]{-1, -1};
            jAnnotations = new ArrayList<Map.Entry<String, JsonNode>>(4);
            SpanTypeEnum spanType = this.parseSpanData(jSpan, spanPos, jAnnotations);
            if (spanType != SpanTypeEnum.Text || spanPos[0] != 0 || spanPos[1] < 0) {
                throw new IOException("The AnalyzedText span MUST have the SpanType 'text', a start position of '0' and an end position (ignored, json: " + jSpan);
            }
            if (at.getEnd() != spanPos[1]) {
                throw new IOException("The size of the local text '" + at.getEnd() + "' does not " + "match the span of the parsed AnalyzedText [" + spanPos[0] + "," + spanPos[1] + "]!");
            }
        } else {
            throw new IOException("Unable to parse AnalyzedText span form JsonNode " + node + " (expected JSON object)!");
        }
        this.parseAnnotations((Span)at, jAnnotations);
    }

    private void parseSpan(AnalysedText at, JsonNode node) throws IOException {
        if (node.isObject()) {
            Sentence span;
            ObjectNode jSpan = (ObjectNode)node;
            int[] spanPos = new int[]{-1, -1};
            ArrayList<Map.Entry<String, JsonNode>> jAnnotations = new ArrayList<Map.Entry<String, JsonNode>>(4);
            SpanTypeEnum spanType = this.parseSpanData(jSpan, spanPos, jAnnotations);
            if (spanType == null || spanPos[0] < 0 || spanPos[1] < 0) {
                this.log.warn("Illegal or missing span type, start and/or end position (ignored, json: " + jSpan);
                return;
            }
            switch (spanType) {
                case Text: {
                    this.log.warn("Encounterd 'Text' span that is not the first span in the 'spans' array (ignored, json: " + node + ")");
                    return;
                }
                case TextSection: {
                    this.log.warn("Encountered 'TextSection' span. This SpanTypeEnum entry is currently unused. If this is no longer the case please update this implementation (ignored, json: " + node + ")");
                    return;
                }
                case Sentence: {
                    span = at.addSentence(spanPos[0], spanPos[1]);
                    break;
                }
                case Chunk: {
                    span = at.addChunk(spanPos[0], spanPos[1]);
                    break;
                }
                case Token: {
                    span = at.addToken(spanPos[0], spanPos[1]);
                    break;
                }
                default: {
                    this.log.warn("Unsupported SpanTypeEnum  '" + spanType + "'!. Please " + "update this implementation (ignored, json: " + node + ")");
                    return;
                }
            }
            if (!jAnnotations.isEmpty()) {
                this.parseAnnotations((Span)span, jAnnotations);
            }
        } else {
            this.log.warn("Unable to parse Span form JsonNode " + node + " (expected JSON object)!");
        }
    }

    private SpanTypeEnum parseSpanData(ObjectNode jSpan, int[] spanPos, Collection<Map.Entry<String, JsonNode>> jAnnotations) {
        SpanTypeEnum spanType = null;
        Iterator fields = jSpan.getFields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if ("type".equals(field.getKey())) {
                if (((JsonNode)field.getValue()).isTextual()) {
                    spanType = SpanTypeEnum.valueOf((String)((JsonNode)field.getValue()).getTextValue());
                    continue;
                }
                if (((JsonNode)field.getValue()).isInt()) {
                    spanType = SpanTypeEnum.values()[((JsonNode)field.getValue()).getIntValue()];
                    continue;
                }
                this.log.warn("Unable to parse SpanType form JSON field " + field + " (ignored, json: " + jSpan + ")");
                return null;
            }
            if ("start".equals(field.getKey())) {
                if (((JsonNode)field.getValue()).isInt()) {
                    spanPos[0] = ((JsonNode)field.getValue()).getIntValue();
                    continue;
                }
                this.log.warn("Unable to parse span start position form JSON field " + field + " (ignored, json: " + jSpan + ")");
                return null;
            }
            if ("end".equals(field.getKey())) {
                if (((JsonNode)field.getValue()).isInt()) {
                    spanPos[1] = ((JsonNode)field.getValue()).getIntValue();
                    continue;
                }
                this.log.warn("Unable to parse span end position form JSON field " + field + " (ignored, json: " + jSpan + ")");
                return null;
            }
            jAnnotations.add(field);
        }
        if (spanType == null) {
            this.log.warn("Missing required field 'type' defining the type of the Span!");
        }
        return spanType;
    }

    private void parseAnnotations(Span span, Collection<Map.Entry<String, JsonNode>> jAnnotations) throws IOException {
        for (Map.Entry<String, JsonNode> jAnnotation : jAnnotations) {
            if (jAnnotation.getValue().isObject()) {
                this.parseAnnotation(span, jAnnotation.getKey(), (ObjectNode)jAnnotation.getValue());
                continue;
            }
            if (jAnnotation.getValue().isArray()) {
                ArrayNode jValues = (ArrayNode)jAnnotation.getValue();
                for (int i = 0; i < jValues.size(); ++i) {
                    JsonNode jValue = jValues.get(i);
                    if (jValue.isObject()) {
                        this.parseAnnotation(span, jAnnotation.getKey(), (ObjectNode)jValue);
                        continue;
                    }
                    this.log.warn("unable to parse the {} value of the annotation {} because value is no JSON object (ignored, json: {}", new Object[]{i, jAnnotation.getKey(), jAnnotation.getValue()});
                }
                continue;
            }
            this.log.warn("unable to parse Annotation {} because value is no JSON object (ignored, json: {}", (Object)jAnnotation.getKey(), (Object)jAnnotation.getValue());
        }
    }

    private void parseAnnotation(Span span, String key, ObjectNode jValue) throws IOException {
        Object value;
        Class<?> clazz;
        JsonNode jClass = jValue.path("class");
        if (!jClass.isTextual()) {
            this.log.warn("unable to parse Annotation {} because 'class' field is not set or not a stringis no JSON object (ignored, json: {}", (Object)key, (Object)jValue);
            return;
        }
        try {
            clazz = AnalyzedTextParser.class.getClassLoader().loadClass(jClass.getTextValue());
        }
        catch (ClassNotFoundException e) {
            this.log.warn("Unable to parse Annotation " + key + " because the 'class' " + jClass.getTextValue() + " of the " + "the value can not be resolved (ignored, json: " + jValue + ")", (Throwable)e);
            return;
        }
        ValueTypeParser<?> parser = this.valueTypeParserRegistry.getParser(clazz);
        if (parser != null) {
            value = parser.parse(jValue, span.getContext());
        } else {
            JsonNode valueNode = jValue.path("value");
            if (valueNode.isMissingNode()) {
                this.log.warn("unable to parse value for annotation {} because the field 'value' is not present (ignored, json: {}", (Object)key, (Object)jValue);
                return;
            }
            try {
                value = this.mapper.treeToValue(valueNode, clazz);
            }
            catch (JsonParseException e) {
                this.log.warn("unable to parse value for annotation " + key + "because the value can" + "not be converted to the class " + clazz.getName() + "(ignored, json: " + jValue + ")", (Throwable)e);
                return;
            }
            catch (JsonMappingException e) {
                this.log.warn("unable to parse value for annotation " + key + "because the value can" + "not be converted to the class " + clazz.getName() + "(ignored, json: " + jValue + ")", (Throwable)e);
                return;
            }
        }
        JsonNode jProb = jValue.path("prob");
        if (!jProb.isDouble()) {
            span.addValue(key, Value.value(value));
        } else {
            span.addValue(key, Value.value(value, (double)jProb.getDoubleValue()));
        }
    }

    private SpanTypeEnum parseSpanType(ObjectNode jSpan) {
        EnumSet<SpanTypeEnum> spanTypes = JsonUtils.parseEnum(jSpan, "type", SpanTypeEnum.class);
        if (spanTypes.isEmpty()) {
            this.log.warn("Unable to parse Span with missing 'type' (json: " + jSpan + ")!");
            return null;
        }
        if (spanTypes.size() > 1) {
            this.log.warn("Found Span with multiple 'types' (Json:" + jSpan + ")!");
        }
        return (SpanTypeEnum)spanTypes.iterator().next();
    }

    protected void bindValueTypeParserRegistry(ValueTypeParserRegistry valueTypeParserRegistry) {
        this.valueTypeParserRegistry = valueTypeParserRegistry;
    }

    protected void unbindValueTypeParserRegistry(ValueTypeParserRegistry valueTypeParserRegistry) {
        if (this.valueTypeParserRegistry == valueTypeParserRegistry) {
            this.valueTypeParserRegistry = null;
        }
    }
}

