/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.stanboltools.offline;

import org.apache.stanbol.commons.stanboltools.offline.OfflineMode;
import org.apache.stanbol.commons.stanboltools.offline.OnlineMode;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String OFFLINE_MODE_PROPERTY = "org.apache.stanbol.offline.mode";
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    private ServiceRegistration serviceReg;

    public void start(BundleContext context) throws Exception {
        String s = System.getProperty(OFFLINE_MODE_PROPERTY);
        Object svc = null;
        String svcName = null;
        if ("true".equals(s)) {
            svc = new OfflineMode(){};
            svcName = OfflineMode.class.getName();
            log.info("OfflineMode activated by {}={}", (Object)OFFLINE_MODE_PROPERTY, (Object)s);
        } else {
            svc = new OnlineMode(){};
            svcName = OnlineMode.class.getName();
            log.info("Offline mode is not set by {}, OnlineMode activated", (Object)OFFLINE_MODE_PROPERTY);
        }
        this.serviceReg = context.registerService(svcName, svc, null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
            this.serviceReg = null;
        }
    }
}

