/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.stanboltools.datafileprovider.impl.tracking;

import java.util.Collections;
import java.util.Map;

public final class DataFileReference {
    private final String name;
    private final String bundleSymbolicName;
    private final Map<String, String> properties;

    protected DataFileReference(String name) {
        this(null, name, null);
    }

    protected DataFileReference(String bundleSymbolicName, String name) {
        this(bundleSymbolicName, name, null);
    }

    protected DataFileReference(String name, Map<String, String> properties) {
        this(null, name, properties);
    }

    protected DataFileReference(String bundleSymbolicName, String name, Map<String, String> properties) {
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("The name of tracked Resources MUST NOT be NULL nor empty!");
        }
        this.name = name;
        this.bundleSymbolicName = bundleSymbolicName;
        this.properties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
    }

    public final String getName() {
        return this.name;
    }

    public final String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public int hashCode() {
        return this.name.hashCode() + (this.bundleSymbolicName != null ? this.bundleSymbolicName.hashCode() : 0);
    }

    public boolean equals(Object o) {
        return o instanceof DataFileReference && ((DataFileReference)o).name.equals(this.name) && (this.bundleSymbolicName == null ? ((DataFileReference)o).bundleSymbolicName == null : this.bundleSymbolicName.equals(((DataFileReference)o).bundleSymbolicName));
    }

    public String toString() {
        return '[' + this.name + (this.bundleSymbolicName != null ? '@' + this.bundleSymbolicName : "") + ']';
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

