/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.stanboltools.datafileprovider.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProvider;
import org.apache.stanbol.commons.stanboltools.datafileprovider.impl.MainDataFileProvider;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.REQUIRE, configurationFactory=true, metatype=true)
@Service
@Property(name="service.ranking", intValue={0})
public class DirectoryDataFileProvider
implements DataFileProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property
    public static final String DATA_FILES_FOLDER_PROP = "data.files.folder";
    private File dataFilesFolder;

    @Activate
    protected void activate(ComponentContext ctx) throws ConfigurationException {
        String folderName = MainDataFileProvider.requireProperty(ctx.getProperties(), DATA_FILES_FOLDER_PROP, String.class);
        this.dataFilesFolder = new File(folderName);
        if (!this.dataFilesFolder.exists()) {
            if (!this.dataFilesFolder.mkdirs()) {
                throw new ConfigurationException(DATA_FILES_FOLDER_PROP, "Unable to create the configured Directory " + this.dataFilesFolder);
            }
        } else if (!this.dataFilesFolder.isDirectory()) {
            throw new ConfigurationException(DATA_FILES_FOLDER_PROP, "The configured DataFile directory " + this.dataFilesFolder + " does already exists but is not a directory!");
        }
    }

    @Override
    public InputStream getInputStream(final String bundleSymbolicName, final String filename, Map<String, String> comments) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    File dataFile = DirectoryDataFileProvider.this.getDataFile(bundleSymbolicName, filename);
                    if (dataFile == null) {
                        throw new IOException("Datafile '" + filename + ("' not present in directory '" + DirectoryDataFileProvider.this.dataFilesFolder + "'"));
                    }
                    return new FileInputStream(dataFile);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)RuntimeException.class.cast(e);
        }
    }

    @Override
    public boolean isAvailable(final String bundleSymbolicName, final String filename, Map<String, String> comments) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    return DirectoryDataFileProvider.this.getDataFile(bundleSymbolicName, filename) != null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            throw (RuntimeException)RuntimeException.class.cast(e);
        }
    }

    private File getDataFile(String bundleSymbolicName, String filename) {
        String[] stringArray;
        if (bundleSymbolicName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = filename;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = bundleSymbolicName + "-" + filename;
            stringArray = stringArray3;
            stringArray3[1] = filename;
        }
        String[] candidateNames = stringArray;
        File dataFile = null;
        for (String name : candidateNames) {
            dataFile = new File(this.dataFilesFolder, name);
            this.log.debug("Looking for file {}", (Object)dataFile.getAbsolutePath());
            if (dataFile.exists() && dataFile.canRead()) {
                this.log.debug("File found in data files folder: {}", (Object)filename);
                break;
            }
            dataFile = null;
        }
        return dataFile;
    }
}

