/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.stanboltools.datafileprovider;

import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class DataFileProviderEvent {
    private static final Map<String, String> EMPTY_COMMENTS = Collections.emptyMap();
    private final Date timestamp = new Date();
    private final String bundleSymbolicName;
    private final String filename;
    private final Map<String, String> comments;
    private final String actualFileLocation;

    public DataFileProviderEvent(String bundleSymbolicName, String filename, Map<String, String> comments, String actualFileLocation) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.filename = filename;
        this.comments = comments == null ? EMPTY_COMMENTS : comments;
        this.actualFileLocation = actualFileLocation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        if (this.bundleSymbolicName != null) {
            sb.append(", bundleSymbolicName=");
            sb.append(this.bundleSymbolicName);
        }
        sb.append(", filename=");
        sb.append(this.filename);
        sb.append(", actualFileLocation=");
        sb.append(this.actualFileLocation);
        return sb.toString();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getFilename() {
        return this.filename;
    }

    public Map<String, String> getComments() {
        return this.comments;
    }

    public String getActualFileLocation() {
        return this.actualFileLocation;
    }
}

