/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.fs.SftpPathIterator;

public class SftpDirectoryStream
implements DirectoryStream<Path> {
    protected SftpPathIterator pathIterator;
    private final SftpPath path;
    private final DirectoryStream.Filter<? super Path> filter;
    private final SftpClient sftp;

    public SftpDirectoryStream(SftpPath path) throws IOException {
        this(path, null);
    }

    public SftpDirectoryStream(SftpPath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.path = Objects.requireNonNull(path, "No path specified");
        this.filter = filter;
        SftpFileSystem fs = (SftpFileSystem)path.getFileSystem();
        this.sftp = fs.getClient();
        Iterable<SftpClient.DirEntry> iter = this.sftp.readDir(path.toString());
        this.pathIterator = new SftpPathIterator(this.getRootPath(), iter, this.getFilter());
    }

    public final SftpClient getClient() {
        return this.sftp;
    }

    public final SftpPath getRootPath() {
        return this.path;
    }

    public final DirectoryStream.Filter<? super Path> getFilter() {
        return this.filter;
    }

    @Override
    public Iterator<Path> iterator() {
        if (!this.sftp.isOpen()) {
            throw new IllegalStateException("Stream has been closed");
        }
        if (this.pathIterator == null) {
            throw new IllegalStateException("Iterator has already been consumed");
        }
        SftpPathIterator iter = this.pathIterator;
        this.pathIterator = null;
        return iter;
    }

    @Override
    public void close() throws IOException {
        this.sftp.close();
    }
}

