/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.net;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.net.NetworkConnector;

public class LdapNetworkConnector<C>
extends NetworkConnector {
    public static final String DEFAULT_LDAP_PROTOCOL = "ldap";
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final String DEFAULT_LDAP_FACTORY_PROPNAME = "javax.naming.ldap.factory";
    public static final String DEFAULT_LDAP_FACTORY_PROPVAL = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final int DEFAULT_LDAP_SEARCH_SCOPE = 2;
    public static final long DEFAULT_LDAP_TIME_LIMIT = TimeUnit.SECONDS.toMillis(15L);
    public static final String DEFAULT_LDAP_REFERRAL_MODE = "ignore";
    public static final long DEFAULT_LDAP_COUNT_LIMIT = 1L;
    public static final boolean DEFAULT_LDAP_DEREF_ENABLED = false;
    public static final String ALL_LDAP_ATTRIBUTES = "*";
    public static final boolean DEFAULT_LDAP_RETURN_OBJVALUE = false;
    public static final boolean DEFAULT_LDAP_ACCUMULATE_MULTIVALUES = false;
    public static final String DEFAULT_LDAP_BIND_DN_PATTERN = "{0}";
    public static final String DEFAULT_LDAP_BIND_PASSWORD_PATTERN = "{1}";
    public static final String DEFAULT_BINARY_ATTRIBUTES = "photo,personalSignature,audio,jpegPhoto,javaSerializedData,thumbnailPhoto,thumbnailLogo,userPassword,userCertificate,cACertificate,authorityRevocationList,certificateRevocationList,crossCertificatePair,x500UniqueIdentifier";
    protected final SearchControls searchControls = new SearchControls();
    protected final Map<String, Object> ldapEnv = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    protected MessageFormat bindDNPattern = new MessageFormat("{0}");
    protected MessageFormat bindPasswordPattern = new MessageFormat("{1}");
    protected MessageFormat searchFilterPattern;
    protected MessageFormat baseDNPattern;
    private boolean accumulateMultiValues = false;

    public LdapNetworkConnector() {
        this.setProtocol(DEFAULT_LDAP_PROTOCOL);
        this.setPort(389);
        this.setSearchScope(2);
        this.setLdapFactory(DEFAULT_LDAP_FACTORY_PROPVAL);
        this.setTimeLimit(DEFAULT_LDAP_TIME_LIMIT);
        this.setCountLimit(1L);
        this.setDerefLink(false);
        this.setReturningObjFlag(false);
        this.setReferralMode(DEFAULT_LDAP_REFERRAL_MODE);
        this.setBinaryAttributes(DEFAULT_BINARY_ATTRIBUTES);
    }

    public void setConnectTimeout(long connectTimeout) {
        ValidateUtils.checkTrue((connectTimeout >= Integer.MIN_VALUE && connectTimeout <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid connect timeout: %d", (long)connectTimeout);
        this.ldapEnv.put("com.sun.jndi.ldap.connect.timeout", Long.toString(connectTimeout));
        super.setConnectTimeout(connectTimeout);
    }

    public void setReadTimeout(long readTimeout) {
        ValidateUtils.checkTrue((readTimeout >= Integer.MIN_VALUE && readTimeout <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid read timeout: %d", (long)readTimeout);
        super.setReadTimeout(readTimeout);
        this.ldapEnv.put("com.sun.jndi.ldap.read.timeout", Long.toString(readTimeout));
    }

    public String getLdapFactory() {
        return Objects.toString(this.ldapEnv.get("java.naming.factory.initial"), null);
    }

    public void setLdapFactory(String factory) {
        this.ldapEnv.put("java.naming.factory.initial", ValidateUtils.checkNotNullAndNotEmpty((String)factory, (String)"No LDAP factory"));
    }

    public String getBaseDN() {
        return this.baseDNPattern.toPattern();
    }

    public void setBaseDN(String p) {
        this.baseDNPattern = new MessageFormat(ValidateUtils.checkNotNullAndNotEmpty((String)p, (String)"No base DN pattern"));
    }

    public String getBindDNPattern() {
        return this.bindDNPattern.toPattern();
    }

    public void setBindDNPattern(String p) {
        this.bindDNPattern = new MessageFormat(ValidateUtils.checkNotNullAndNotEmpty((String)p, (String)"No bind DN pattern"));
    }

    public String getBindPasswordPattern() {
        return this.bindPasswordPattern.toPattern();
    }

    public void setBindPasswordPattern(String p) {
        this.bindPasswordPattern = new MessageFormat(ValidateUtils.checkNotNullAndNotEmpty((String)p, (String)"No bind password pattern"));
    }

    public String getSearchFilterPattern() {
        return this.searchFilterPattern.toPattern();
    }

    public void setSearchFilterPattern(String p) {
        this.searchFilterPattern = new MessageFormat(ValidateUtils.checkNotNullAndNotEmpty((String)p, (String)"No seatch filter pattern"));
    }

    public int getSearchScope() {
        return this.searchControls.getSearchScope();
    }

    public void setSearchScope(int scope) {
        this.searchControls.setSearchScope(scope);
    }

    public long getTimeLimit() {
        return this.searchControls.getTimeLimit();
    }

    public void setTimeLimit(long limit) {
        ValidateUtils.checkTrue((limit >= 0L ? 1 : 0) != 0, (String)"Negative time limit: %d", (long)limit);
        this.searchControls.setTimeLimit((int)limit);
    }

    public long getCountLimit() {
        return this.searchControls.getCountLimit();
    }

    public void setCountLimit(long count) {
        ValidateUtils.checkTrue((count >= 0L ? 1 : 0) != 0, (String)"Bad count limit: %d", (long)count);
        this.searchControls.setCountLimit(count);
    }

    public boolean isDerefLink() {
        return this.searchControls.getDerefLinkFlag();
    }

    public void setDerefLink(boolean enabled) {
        this.searchControls.setDerefLinkFlag(enabled);
    }

    public String getRetrievedAttributes() {
        Object[] attrs = this.searchControls.getReturningAttributes();
        if (attrs == null) {
            return ALL_LDAP_ATTRIBUTES;
        }
        if (attrs.length == 0) {
            return "";
        }
        if (attrs.length == 1) {
            return attrs[0];
        }
        return GenericUtils.join((Object[])attrs, (char)',');
    }

    public void setRetrievedAttributes(String attrs) {
        if (GenericUtils.isEmpty((CharSequence)attrs)) {
            this.searchControls.setReturningAttributes(GenericUtils.EMPTY_STRING_ARRAY);
        } else if (ALL_LDAP_ATTRIBUTES.equals(attrs)) {
            this.searchControls.setReturningAttributes(null);
        } else {
            this.searchControls.setReturningAttributes(GenericUtils.split((String)attrs, (char)','));
        }
    }

    public boolean isAccumulateMultiValues() {
        return this.accumulateMultiValues;
    }

    public void setAccumulateMultiValues(boolean enabled) {
        this.accumulateMultiValues = enabled;
    }

    public boolean isReturningObjFlag() {
        return this.searchControls.getReturningObjFlag();
    }

    public void setReturningObjFlag(boolean enabled) {
        this.searchControls.setReturningObjFlag(enabled);
    }

    public String getAuthenticationMode() {
        return Objects.toString(this.ldapEnv.get("java.naming.security.authentication"), null);
    }

    public void setAuthenticationMode(String mode) {
        this.ldapEnv.put("java.naming.security.authentication", Objects.requireNonNull(mode, "No authentication mode"));
    }

    public String getReferralMode() {
        return Objects.toString(this.ldapEnv.get("java.naming.referral"), null);
    }

    public void setReferralMode(String mode) {
        this.ldapEnv.put("java.naming.referral", ValidateUtils.checkNotNullAndNotEmpty((String)mode, (String)"No referral mode"));
    }

    public int getProtocolVersion() {
        Object value = this.ldapEnv.get("java.naming.ldap.version");
        return value != null ? ((Number)value).intValue() : -1;
    }

    public void setProtocolVersion(int value) {
        ValidateUtils.checkTrue((value > 0 ? 1 : 0) != 0, (String)"Non-positive protocol value: %d", (long)value);
        this.ldapEnv.put("java.naming.ldap.version", value);
    }

    public String getBinaryAttributes() {
        return Objects.toString(this.ldapEnv.get("java.naming.ldap.attributes.binary"), "").replace(' ', ',');
    }

    public void setBinaryAttributes(String value) {
        value = ValidateUtils.checkNotNullAndNotEmpty((String)value, (String)"No attributes").replace(',', ' ');
        this.ldapEnv.put("java.naming.ldap.attributes.binary", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> resolveAttributes(String username, String password, C queryContext) throws NamingException {
        try (DirContext context = this.initializeDirContext(queryContext, new HashMap<String, Object>(this.ldapEnv), username, password);){
            Map<String, Object> map = this.queryAttributes(queryContext, context, context.getEnvironment(), username, password);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> queryAttributes(C queryContext, DirContext context, Map<?, ?> ldapConfig, String username, String password) throws NamingException {
        String baseDN = this.resolveBaseDN(queryContext, ldapConfig, username, password);
        String filter = this.resolveSearchFilter(queryContext, ldapConfig, username, password);
        try (NamingEnumeration<SearchResult> result = context.search(ValidateUtils.checkNotNullAndNotEmpty((String)baseDN, (String)"No base DN"), ValidateUtils.checkNotNullAndNotEmpty((String)filter, (String)"No filter"), this.searchControls);){
            TreeMap<String, Object> attrsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            String referralMode = Objects.toString(ldapConfig.get("java.naming.referral"), null);
            int index = 0;
            while (result.hasMore()) {
                this.processSearchResult(queryContext, ldapConfig, attrsMap, index, result.next());
                if (DEFAULT_LDAP_REFERRAL_MODE.equals(referralMode)) break;
                ++index;
            }
            TreeMap<String, Object> treeMap = attrsMap;
            return treeMap;
        }
    }

    protected DirContext initializeDirContext(C queryContext, Map<String, Object> env, String username, String password) throws NamingException {
        Map<String, Object> ldapConfig = this.setupDirContextEnvironment(queryContext, env, username, password);
        return new InitialDirContext(new Hashtable<String, Object>(ldapConfig));
    }

    protected Map<String, Object> setupDirContextEnvironment(C queryContext, Map<String, Object> env, String username, String password) throws NamingException {
        String mode;
        boolean anonymous;
        if (!env.containsKey("java.naming.provider.url")) {
            int port = this.getPort();
            ValidateUtils.checkTrue((port > 0 ? 1 : 0) != 0, (String)"No port configured");
            String url = ValidateUtils.checkNotNullAndNotEmpty((String)this.getProtocol(), (String)"No protocol") + "://" + ValidateUtils.checkNotNullAndNotEmpty((String)this.getHost(), (String)"No host") + ":" + port;
            env.put("java.naming.provider.url", url);
        }
        boolean bl = anonymous = GenericUtils.isEmpty((CharSequence)(mode = Objects.toString(env.get("java.naming.security.authentication"), null))) || "none".equalsIgnoreCase(mode);
        if (!anonymous) {
            Object[] bindParams = new Object[]{username, password};
            if (!env.containsKey("java.naming.security.principal")) {
                String bindDN = Objects.requireNonNull(this.bindDNPattern, "No bind DN pattern").format(bindParams);
                env.put("java.naming.security.principal", ValidateUtils.checkNotNullAndNotEmpty((String)bindDN, (String)"No bind DN"));
            }
            if (!env.containsKey("java.naming.security.credentials")) {
                String bindPassword = Objects.requireNonNull(this.bindPasswordPattern, "No bind password pattern").format(bindParams);
                env.put("java.naming.security.credentials", ValidateUtils.checkNotNullAndNotEmpty((String)bindPassword, (String)"No bind password"));
            }
        }
        return env;
    }

    protected String resolveBaseDN(C queryContext, Map<?, ?> ldapConfig, String username, String password) throws NamingException {
        Object[] bindParams = new Object[]{username, password};
        return Objects.requireNonNull(this.baseDNPattern, "No base DN pattern").format(bindParams);
    }

    protected String resolveSearchFilter(C queryContext, Map<?, ?> ldapConfig, String username, String password) throws NamingException {
        Object[] bindParams = new Object[]{username, password};
        return Objects.requireNonNull(this.searchFilterPattern, "No search filter pattern").format(bindParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSearchResult(C queryContext, Map<?, ?> ldapConfig, Map<String, Object> attrsMap, int resultIndex, SearchResult result) throws NamingException {
        String dn = result.getName();
        this.accumulateAttributeValue(queryContext, attrsMap, "java.naming.authoritative", dn);
        Attributes attrs = result.getAttributes();
        try (NamingEnumeration<? extends Attribute> attrVals = attrs.getAll();){
            while (attrVals.hasMore()) {
                this.processResultAttributeValue(queryContext, ldapConfig, dn, resultIndex, attrsMap, attrVals.next());
            }
        }
    }

    protected Object processResultAttributeValue(C queryContext, Map<?, ?> ldapConfig, String dn, int resultIndex, Map<String, Object> attrsMap, Attribute a) throws NamingException {
        String attrID = a.getID();
        int numValues = a.size();
        for (int index = 0; index < numValues; ++index) {
            Object attrVal = a.get(index);
            if (attrVal != null) {
                Object prev = this.accumulateAttributeValue(queryContext, attrsMap, attrID, attrVal);
                if (this.log.isTraceEnabled()) {
                    if (prev != null) {
                        this.log.trace("processResultAttributeValue({})[{}] multiple values: {} / {}", new Object[]{dn, attrID, LdapNetworkConnector.toString(prev), LdapNetworkConnector.toString(attrVal)});
                    } else {
                        this.log.trace("processResultAttributeValue({}) {} = {}", new Object[]{dn, attrID, LdapNetworkConnector.toString(attrVal)});
                    }
                }
            } else if (this.log.isTraceEnabled()) {
                this.log.trace("processResultAttributeValue({}) skip null attribute: {}", (Object)dn, (Object)attrID);
            }
            if (numValues <= 1 || this.isAccumulateMultiValues()) continue;
            if (!this.log.isTraceEnabled()) break;
            this.log.trace("processResultAttributeValue({})[{}] skip remaining {} values", new Object[]{dn, attrID, numValues - 1});
            break;
        }
        return attrsMap.get(attrID);
    }

    protected Object accumulateAttributeValue(C queryContext, Map<String, Object> attrsMap, String attrID, Object attrVal) {
        Object prev = attrsMap.put(attrID, attrVal);
        if (prev == null) {
            return null;
        }
        ArrayList<Object> values = null;
        if (prev instanceof List) {
            values = (ArrayList<Object>)prev;
        } else {
            values = new ArrayList<Object>();
            values.add(prev);
            attrsMap.put(attrID, values);
        }
        values.add(attrVal);
        return values.get(values.size() - 2);
    }

    public static String toString(Object attrVal) {
        if (attrVal == null) {
            return null;
        }
        Class<?> attrType = attrVal.getClass();
        if (attrType.isArray()) {
            return attrVal instanceof byte[] ? BufferUtils.toHex((byte[])((byte[])attrVal)) : Arrays.toString((Object[])attrVal);
        }
        return attrVal.toString();
    }
}

