/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pgm;

import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.git.AbstractGitCommandFactory;
import org.apache.sshd.git.GitLocationResolver;
import org.apache.sshd.git.pgm.GitPgmCommand;
import org.apache.sshd.server.command.CommandFactory;

public class GitPgmCommandFactory
extends AbstractGitCommandFactory {
    public static final String GIT_FACTORY_NAME = "git-pgm";
    public static final String GIT_COMMAND_PREFIX = "git ";

    public GitPgmCommandFactory() {
        this(null);
    }

    public GitPgmCommandFactory(GitLocationResolver resolver) {
        super(GIT_FACTORY_NAME, GIT_COMMAND_PREFIX);
        this.withGitLocationResolver(resolver);
    }

    @Override
    public GitPgmCommandFactory withDelegate(CommandFactory delegate) {
        return (GitPgmCommandFactory)super.withDelegate(delegate);
    }

    @Override
    public GitPgmCommandFactory withGitLocationResolver(GitLocationResolver rootDirResolver) {
        return (GitPgmCommandFactory)super.withGitLocationResolver(rootDirResolver);
    }

    @Override
    public GitPgmCommandFactory withExecutorService(CloseableExecutorService executorService) {
        return (GitPgmCommandFactory)super.withExecutorService(executorService);
    }

    @Override
    public GitPgmCommand createGitCommand(String command) {
        return new GitPgmCommand(this.getGitLocationResolver(), command.substring(GIT_COMMAND_PREFIX.length()), this.getExecutorService());
    }
}

