/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pack;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPackCommand
implements Command,
Runnable {
    private String rootDir;
    private String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;

    public GitPackCommand(String rootDir, String command) {
        this.rootDir = rootDir;
        this.command = command;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
        if (out instanceof ChannelOutputStream) {
            ((ChannelOutputStream)out).setNoDelay(true);
        }
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
        if (err instanceof ChannelOutputStream) {
            ((ChannelOutputStream)err).setNoDelay(true);
        }
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        new Thread(this).start();
    }

    @Override
    public void run() {
        block8: {
            try {
                List<String> strs = GitPackCommand.parseDelimitedString(this.command, " ", true);
                String[] args = strs.toArray(new String[strs.size()]);
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("'") && args[i].endsWith("'")) {
                        args[i] = args[i].substring(1, args[i].length() - 1);
                    }
                    if (!args[i].startsWith("\"") || !args[i].endsWith("\"")) continue;
                    args[i] = args[i].substring(1, args[i].length() - 1);
                }
                if (args.length != 2) {
                    throw new IllegalArgumentException("Invalid git command line: " + this.command);
                }
                File srcGitdir = new File(this.rootDir, args[1]);
                RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient((File)srcGitdir, (FS)FS.DETECTED);
                Repository db = key.open(true);
                if ("git-upload-pack".equals(args[0])) {
                    new UploadPack(db).upload(this.in, this.out, this.err);
                    break block8;
                }
                if ("git-receive-pack".equals(args[0])) {
                    new ReceivePack(db).receive(this.in, this.out, this.err);
                    break block8;
                }
                throw new IllegalArgumentException("Unknown git command: " + this.command);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this.callback != null) {
            this.callback.onExit(0);
        }
    }

    public void destroy() {
    }

    private static List<String> parseDelimitedString(String value, String delim, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuilder sb = new StringBuilder();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        boolean isEscaped = false;
        for (int i = 0; i < value.length(); ++i) {
            boolean isDelimiter;
            char c = value.charAt(i);
            boolean bl = isDelimiter = delim.indexOf(c) >= 0;
            if (!isEscaped && c == '\\') {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                sb.append(c);
            } else if (isDelimiter && (expecting & DELIMITER) > 0) {
                if (trim) {
                    list.add(sb.toString().trim());
                } else {
                    list.add(sb.toString());
                }
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
            } else if (c == '\"' && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
            } else if (c == '\"' && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
            } else if ((expecting & CHAR) > 0) {
                sb.append(c);
            } else {
                throw new IllegalArgumentException("Invalid delimited string: " + value);
            }
            isEscaped = false;
        }
        if (sb.length() > 0) {
            if (trim) {
                list.add(sb.toString().trim());
            } else {
                list.add(sb.toString());
            }
        }
        return list;
    }
}

