/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.logging.Level;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.LogLevelValue;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.util.GenericUtils;

public abstract class CliSupport {
    public static final BuiltinIoServiceFactoryFactories DEFAULT_IO_SERVICE_FACTORY = BuiltinIoServiceFactoryFactories.NIO2;

    protected CliSupport() {
    }

    public static boolean showError(PrintStream stderr, String message) {
        stderr.append("ERROR: ").println(message);
        return true;
    }

    public static boolean isEnabledVerbosityLogging(Level level) {
        return level != null && !Level.OFF.equals(level) && !Level.CONFIG.equals(level) && !Level.SEVERE.equals(level) && !Level.WARNING.equals(level);
    }

    public static BuiltinIoServiceFactoryFactories resolveIoServiceFactory(PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length((Object[])args);
        BuiltinIoServiceFactoryFactories factory = null;
        for (int index = 0; index < numArgs; ++index) {
            String argName = args[index];
            if (!"-io".equals(argName)) continue;
            if (factory != null) {
                stderr.println("I/O factory re-specified - already set as " + factory);
                return null;
            }
            if (++index >= numArgs) {
                stderr.println("option requires an argument: " + argName);
                return null;
            }
            String provider = args[index];
            factory = CliSupport.resolveBuiltinIoServiceFactory(stderr, argName, provider);
            if (factory != null) continue;
            return null;
        }
        if (factory == null) {
            factory = DEFAULT_IO_SERVICE_FACTORY;
        }
        System.setProperty(IoServiceFactoryFactory.class.getName(), factory.getFactoryClassName());
        return factory;
    }

    public static BuiltinIoServiceFactoryFactories resolveBuiltinIoServiceFactory(PrintStream stderr, String argName, String provider) {
        BuiltinIoServiceFactoryFactories factory = BuiltinIoServiceFactoryFactories.fromFactoryName((String)provider);
        if (factory == null) {
            System.err.println(argName + " - unknown provider (" + provider + ") should be one of " + BuiltinIoServiceFactoryFactories.VALUES);
        }
        return factory;
    }

    public static <M extends AbstractFactoryManager> M setupIoServiceFactory(M manager, PropertyResolver resolver, final Level level, final PrintStream stdout, final PrintStream stderr, String ... args) {
        BuiltinIoServiceFactoryFactories factory = CliSupport.resolveIoServiceFactory(stderr, args);
        if (factory == null) {
            return null;
        }
        manager.setIoServiceFactoryFactory(factory.create());
        if (!CliSupport.isEnabledVerbosityLogging(level)) {
            return manager;
        }
        manager.setIoServiceEventListener(new IoServiceEventListener(){
            private final PrintStream out;
            {
                this.out = Level.INFO.equals(level) ? stderr : stdout;
            }

            public void connectionEstablished(IoConnector connector, SocketAddress local, AttributeRepository context, SocketAddress remote) throws IOException {
                this.out.append("Connection established via ").append(Objects.toString(connector)).append("- local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).println();
            }

            public void abortEstablishedConnection(IoConnector connector, SocketAddress local, AttributeRepository context, SocketAddress remote, Throwable reason) throws IOException {
                this.out.append("Abort established connection ").append(Objects.toString(connector)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(": (").append(reason.getClass().getSimpleName()).append(')').append(" ").println(reason.getMessage());
                reason.printStackTrace(this.out);
            }

            public void connectionAccepted(IoAcceptor acceptor, SocketAddress local, SocketAddress remote, SocketAddress service) throws IOException {
                this.out.append("Connection accepted via ").append(Objects.toString(acceptor)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(", service=").append(Objects.toString(service)).println();
            }

            public void abortAcceptedConnection(IoAcceptor acceptor, SocketAddress local, SocketAddress remote, SocketAddress service, Throwable reason) throws IOException {
                this.out.append("Abort accepted connection ").append(Objects.toString(acceptor)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(", service=").append(Objects.toString(service)).append(": (").append(reason.getClass().getSimpleName()).append(')').append(" ").println(reason.getMessage());
                reason.printStackTrace(this.out);
            }
        });
        return manager;
    }

    public static Level resolveLoggingVerbosity(String ... args) {
        return CliSupport.resolveLoggingVerbosity(args, GenericUtils.length((Object[])args));
    }

    public static Level resolveLoggingVerbosity(String[] args, int maxIndex) {
        for (int index = 0; index < maxIndex; ++index) {
            String argName = args[index];
            if ("-v".equals(argName)) {
                return Level.INFO;
            }
            if ("-vv".equals(argName)) {
                return Level.FINE;
            }
            if (!"-vvv".equals(argName)) continue;
            return Level.FINEST;
        }
        return Level.CONFIG;
    }

    public static Level resolveLoggingVerbosity(PropertyResolver resolver, String ... args) {
        String levelValue = PropertyResolverUtils.getString((PropertyResolver)resolver, (String)"LogLevel");
        if (GenericUtils.isEmpty((CharSequence)levelValue)) {
            return CliSupport.resolveLoggingVerbosity(args);
        }
        LogLevelValue level = LogLevelValue.fromName((String)levelValue);
        if (level == null) {
            throw new IllegalArgumentException("Unknown LogLevel option value: " + levelValue);
        }
        return level.getLoggingLevel();
    }
}

