/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.repl.ConstructorCleaner;
import org.apache.spark.util.ParentClassLoader;
import org.apache.xbean.asm6.ClassReader;
import org.apache.xbean.asm6.ClassVisitor;
import org.apache.xbean.asm6.ClassWriter;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001-\u00111#\u0012=fGV$xN]\"mCN\u001cHj\\1eKJT!a\u0001\u0003\u0002\tI,\u0007\u000f\u001c\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!aC\"mCN\u001cHj\\1eKJ\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oO\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0003d_:4\u0007CA\u000f\u001f\u001b\u0005!\u0011BA\u0010\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003\r)gN\u001e\t\u0003;\rJ!\u0001\n\u0003\u0003\u0011M\u0003\u0018M]6F]ZD\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\tG2\f7o]+sSB\u0011\u0001&\r\b\u0003S=\u0002\"AK\u0017\u000e\u0003-R!\u0001\f\u0006\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Aj\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0007\u0002\rA\f'/\u001a8u\u0011!9\u0004A!A!\u0002\u0013A\u0014AE;tKJ\u001cE.Y:t!\u0006$\bNR5sgR\u0004\"!\u000f\u001e\u000e\u00035J!aO\u0017\u0003\u000f\t{w\u000e\\3b]\")Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"baP!C\u0007\u0012+\u0005C\u0001!\u0001\u001b\u0005\u0011\u0001\"B\u000e=\u0001\u0004a\u0002\"B\u0011=\u0001\u0004\u0011\u0003\"\u0002\u0014=\u0001\u00049\u0003\"B\u001b=\u0001\u0004a\u0001\"B\u001c=\u0001\u0004A\u0004bB$\u0001\u0005\u0004%\t\u0001S\u0001\u0004kJLW#A%\u0011\u0005)kU\"A&\u000b\u00051\u0003\u0012a\u00018fi&\u0011aj\u0013\u0002\u0004+JK\u0005B\u0002)\u0001A\u0003%\u0011*\u0001\u0003ve&\u0004\u0003b\u0002*\u0001\u0005\u0004%\taU\u0001\nI&\u0014Xm\u0019;pef,\u0012\u0001\u0016\t\u0003\u001bUK!A\r\b\t\r]\u0003\u0001\u0015!\u0003U\u0003)!\u0017N]3di>\u0014\u0018\u0010\t\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u00031\u0001\u0018M]3oi2{\u0017\rZ3s+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0001l&!\u0005)be\u0016tGo\u00117bgNdu.\u00193fe\"1!\r\u0001Q\u0001\nm\u000bQ\u0002]1sK:$Hj\\1eKJ\u0004\u0003\u0002\u00033\u0001\u0001\u0004%\tAA3\u0002=!$H\u000f]+sY\u000e{gN\\3di&|g\u000eV5nK>,H/T5mY&\u001cX#\u00014\u0011\u0005e:\u0017B\u00015.\u0005\rIe\u000e\u001e\u0005\tU\u0002\u0001\r\u0011\"\u0001\u0003W\u0006\u0011\u0003\u000e\u001e;q+Jd7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;NS2d\u0017n]0%KF$\"\u0001\\8\u0011\u0005ej\u0017B\u00018.\u0005\u0011)f.\u001b;\t\u000fAL\u0017\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\t\rI\u0004\u0001\u0015)\u0003g\u0003}AG\u000f\u001e9Ve2\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^'jY2L7\u000f\t\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0003\u001d1W\r^2i\r:,\u0012A\u001e\t\u0005s]<\u00130\u0003\u0002y[\tIa)\u001e8di&|g.\r\t\u0003uvl\u0011a\u001f\u0006\u0003yB\t!![8\n\u0005y\\(aC%oaV$8\u000b\u001e:fC6Dq!!\u0001\u0001A\u0003%a/\u0001\u0005gKR\u001c\u0007N\u00128!\u0011\u001d\t)\u0001\u0001C!\u0003\u000f\t1bZ3u%\u0016\u001cx.\u001e:dKR!\u0011\u0011BA\b!\rQ\u00151B\u0005\u0004\u0003\u001bY%aA+S\u0019\"9\u0011\u0011CA\u0002\u0001\u00049\u0013\u0001\u00028b[\u0016Dq!!\u0006\u0001\t\u0003\n9\"\u0001\u0007hKR\u0014Vm]8ve\u000e,7\u000f\u0006\u0003\u0002\u001a\u0005\r\u0002CBA\u000e\u0003?\tI!\u0004\u0002\u0002\u001e)\u0011a\fE\u0005\u0005\u0003C\tiBA\u0006F]VlWM]1uS>t\u0007bBA\t\u0003'\u0001\ra\n\u0005\b\u0003O\u0001A\u0011IA\u0015\u0003%1\u0017N\u001c3DY\u0006\u001c8\u000f\u0006\u0003\u0002,\u0005%\u0003\u0007BA\u0017\u0003o\u0001R\u0001KA\u0018\u0003gI1!!\r4\u0005\u0015\u0019E.Y:t!\u0011\t)$a\u000e\r\u0001\u0011a\u0011\u0011HA\u0013\u0003\u0003\u0005\tQ!\u0001\u0002<\t\u0019q\fJ\u0019\u0012\t\u0005u\u00121\t\t\u0004s\u0005}\u0012bAA![\t9aj\u001c;iS:<\u0007cA\u001d\u0002F%\u0019\u0011qI\u0017\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0012\u0005\u0015\u0002\u0019A\u0014\t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u0005\u0019s-\u001a;DY\u0006\u001c8OR5mK&s\u0007/\u001e;TiJ,\u0017-\u001c$s_6\u001c\u0006/\u0019:l%B\u001bEcA=\u0002R!9\u00111KA&\u0001\u00049\u0013\u0001\u00029bi\"Dq!a\u0016\u0001\t\u0013\tI&A\u0013hKR\u001cE.Y:t\r&dW-\u00138qkR\u001cFO]3b[\u001a\u0013x.\u001c$jY\u0016\u001c\u0016p\u001d;f[R!\u00111LA1)\rI\u0018Q\f\u0005\b\u0003?\n)\u00061\u0001(\u0003=\u0001\u0018\r\u001e5J]\u0012K'/Z2u_JL\b\u0002CA2\u0003+\u0002\r!!\u001a\u0002\u0015\u0019LG.Z*zgR,W\u000e\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u0005\u0019\u001c(bAA8\r\u00051\u0001.\u00193p_BLA!a\u001d\u0002j\tQa)\u001b7f'f\u001cH/Z7\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005\u0001b-\u001b8e\u00072\f7o\u001d'pG\u0006dG.\u001f\u000b\u0005\u0003w\nY\tE\u0003:\u0003{\n\t)C\u0002\u0002\u00005\u0012aa\u00149uS>t\u0007\u0007BAB\u0003\u000f\u0003R\u0001KA\u0018\u0003\u000b\u0003B!!\u000e\u0002\b\u0012a\u0011\u0011RA;\u0003\u0003\u0005\tQ!\u0001\u0002<\t\u0019q\f\n\u001a\t\u000f\u0005E\u0011Q\u000fa\u0001O!9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0015!\u0006:fC\u0012\fe\u000e\u001a+sC:\u001chm\u001c:n\u00072\f7o\u001d\u000b\u0007\u0003'\u000by*!)\u0011\u000be\n)*!'\n\u0007\u0005]UFA\u0003BeJ\f\u0017\u0010E\u0002:\u00037K1!!(.\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005E\u0011Q\u0012a\u0001O!9\u00111UAG\u0001\u0004I\u0018AA5o\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u000b\u0011\"\u001e:m\u000b:\u001cw\u000eZ3\u0015\u0007\u001d\nY\u000bC\u0004\u0002.\u0006\u0015\u0006\u0019A\u0014\u0002\u0007M$(\u000f")
public class ExecutorClassLoader
extends ClassLoader
implements Logging {
    private final SparkEnv env;
    private final String classUri;
    private final boolean userClassPathFirst;
    private final URI uri;
    private final String directory;
    private final ParentClassLoader parentLoader;
    private int httpUrlConnectionTimeoutMillis;
    private final Function1<String, InputStream> fetchFn;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public URI uri() {
        return this.uri;
    }

    public String directory() {
        return this.directory;
    }

    public ParentClassLoader parentLoader() {
        return this.parentLoader;
    }

    public int httpUrlConnectionTimeoutMillis() {
        return this.httpUrlConnectionTimeoutMillis;
    }

    public void httpUrlConnectionTimeoutMillis_$eq(int x$1) {
        this.httpUrlConnectionTimeoutMillis = x$1;
    }

    private Function1<String, InputStream> fetchFn() {
        return this.fetchFn;
    }

    @Override
    public URL getResource(String name) {
        return this.parentLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.parentLoader().getResources(name);
    }

    @Override
    public Class<?> findClass(String name) {
        Class clazz;
        if (this.userClassPathFirst) {
            clazz = (Class)this.findClassLocally(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.parentLoader().loadClass(name));
        } else {
            try {
                clazz = this.parentLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                Class a;
                Option<Class<?>> classOption;
                Option<Class<?>> option = classOption = this.findClassLocally(name);
                if (None$.MODULE$.equals(option)) {
                    throw new ClassNotFoundException(name, e);
                }
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                Class clazz2 = a = (Class)some.value();
                clazz = clazz2;
            }
        }
        return clazz;
    }

    private InputStream getClassFileInputStreamFromSparkRPC(String path) {
        ReadableByteChannel channel = this.env.rpcEnv().openChannel(new StringBuilder(1).append(this.classUri).append("/").append(path).toString());
        return new FilterInputStream(null, path, channel){
            private final String path$1;

            private /* synthetic */ int super$read() {
                return super.read();
            }

            private /* synthetic */ int super$read(byte[] x$1) {
                return super.read(x$1);
            }

            private /* synthetic */ int super$read(byte[] x$1, int x$2, int x$3) {
                return super.read(x$1, x$2, x$3);
            }

            public int read() {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read());
            }

            public int read(byte[] b) {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read(b));
            }

            public int read(byte[] b, int offset, int len) {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read(b, offset, len));
            }

            private int toClassNotFound(Function0<Object> fn) {
                int n;
                try {
                    n = fn.apply$mcI$sp();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(this.path$1, e);
                }
                return n;
            }
            {
                this.path$1 = path$1;
                super(Channels.newInputStream(channel$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(org.apache.spark.repl.ExecutorClassLoader$$anon$1 ), $anonfun$read$2(org.apache.spark.repl.ExecutorClassLoader$$anon$1 byte[] ), $anonfun$read$3(org.apache.spark.repl.ExecutorClassLoader$$anon$1 byte[] int int )}, serializedLambda);
            }
        };
    }

    private InputStream getClassFileInputStreamFromFileSystem(FileSystem fileSystem, String pathInDirectory) {
        FSDataInputStream fSDataInputStream;
        Path path = new Path(this.directory(), pathInDirectory);
        try {
            fSDataInputStream = fileSystem.open(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassNotFoundException(new StringBuilder(29).append("Class file not found at path ").append(path).toString());
        }
        return fSDataInputStream;
    }

    public Option<Class<?>> findClassLocally(String name) {
        None$ none$;
        block10: {
            None$ none$2;
            String pathInDirectory = new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = (InputStream)this.fetchFn().apply((Object)pathInDirectory);
                    byte[] bytes = this.readAndTransformClass(name, inputStream);
                    none$2 = new Some(this.defineClass(name, bytes, 0, bytes.length));
                }
                catch (ClassNotFoundException e) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Did not load class ").append(name).append(" from REPL class server at ").append(this.uri()).toString(), e);
                    none$2 = None$.MODULE$;
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Failed to check existence of class ").append(name).append(" on REPL class server at ").append(this.uri()).toString(), e);
                    none$2 = None$.MODULE$;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while closing inputStream", e);
                    }
                }
                throw throwable;
            }
            none$ = none$2;
            if (inputStream == null) break block10;
            try {
                inputStream.close();
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while closing inputStream", e);
            }
        }
        return none$;
    }

    public byte[] readAndTransformClass(String name, InputStream in) {
        if (name.startsWith("line") && name.endsWith("$iw$")) {
            ClassReader cr = new ClassReader(in);
            ClassWriter cw = new ClassWriter(3);
            ConstructorCleaner cleaner = new ConstructorCleaner(name, (ClassVisitor)cw);
            cr.accept((ClassVisitor)cleaner, 0);
            return cw.toByteArray();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        boolean done = false;
        while (!done) {
            int num = in.read(bytes);
            if (num >= 0) {
                bos.write(bytes, 0, num);
                continue;
            }
            done = true;
        }
        return bos.toByteArray();
    }

    public String urlEncode(String str) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split('/'))).map((Function1 & Serializable & scala.Serializable)part -> URLEncoder.encode(part, "UTF-8"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/");
    }

    public ExecutorClassLoader(SparkConf conf, SparkEnv env, String classUri, ClassLoader parent, boolean userClassPathFirst) {
        Function1 & Serializable & scala.Serializable intersect;
        this.env = env;
        this.classUri = classUri;
        this.userClassPathFirst = userClassPathFirst;
        super(null);
        Logging.$init$((Logging)this);
        this.uri = new URI(classUri);
        this.directory = this.uri().getPath();
        this.parentLoader = new ParentClassLoader(parent);
        this.httpUrlConnectionTimeoutMillis = -1;
        String string = this.uri().getScheme();
        if ("spark".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)path -> this.getClassFileInputStreamFromSparkRPC((String)path);
        } else {
            FileSystem fileSystem = FileSystem.get((URI)this.uri(), (Configuration)SparkHadoopUtil$.MODULE$.get().newConfiguration(conf));
            intersect = (Function1 & Serializable & scala.Serializable)pathInDirectory -> this.getClassFileInputStreamFromFileSystem(fileSystem, (String)pathInDirectory);
        }
        this.fetchFn = intersect;
    }
}

