/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowResolver;
import org.apache.spark.sql.pipelines.graph.GraphElement;
import org.apache.spark.sql.pipelines.graph.Input;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.UnresolvedFlow;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.sql.pipelines.graph.VirtualTableInput;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A4A!\u0004\b\u00017!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\rA\u0002\u0001\u0015!\u0003.\u0011\u001d\t\u0004A1A\u0005\nIBaA\u0012\u0001!\u0002\u0013\u0019\u0004bB$\u0001\u0005\u0004%I\u0001\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\t\u000f9\u0003!\u0019!C\u0005\u001f\"11\u000b\u0001Q\u0001\nACQ\u0001\u0016\u0001\u0005\nUCQa\u0017\u0001\u0005\u0002q\u0013\u0011dQ8sK\u0012\u000bG/\u00194m_^tu\u000eZ3Qe>\u001cWm]:pe*\u0011q\u0002E\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003#I\t\u0011\u0002]5qK2Lg.Z:\u000b\u0005M!\u0012aA:rY*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0005sC^<%/\u00199i!\t!S%D\u0001\u000f\u0013\t1cBA\u0007ECR\fg\r\\8x\u000fJ\f\u0007\u000f[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%R\u0003C\u0001\u0013\u0001\u0011\u0015\u0011#\u00011\u0001$\u000311Gn\\<SKN|GN^3s+\u0005i\u0003C\u0001\u0013/\u0013\tycB\u0001\u0007GY><(+Z:pYZ,'/A\u0007gY><(+Z:pYZ,'\u000fI\u0001\u000fe\u0016\u001cx\u000e\u001c<fI&s\u0007/\u001e;t+\u0005\u0019\u0004\u0003\u0002\u001b<{\rk\u0011!\u000e\u0006\u0003m]\n!bY8oGV\u0014(/\u001a8u\u0015\tA\u0014(\u0001\u0003vi&d'\"\u0001\u001e\u0002\t)\fg/Y\u0005\u0003yU\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tq\u0014)D\u0001@\u0015\t\u0001%#\u0001\u0005dCR\fG._:u\u0013\t\u0011uHA\bUC\ndW-\u00133f]RLg-[3s!\t!C)\u0003\u0002F\u001d\t)\u0011J\u001c9vi\u0006y!/Z:pYZ,G-\u00138qkR\u001c\b%\u0001\u000bsKN|GN^3e\r2|wOT8eKNl\u0015\r]\u000b\u0002\u0013B!AgO\u001fK!\t!3*\u0003\u0002M\u001d\ta!+Z:pYZ,GM\u00127po\u0006)\"/Z:pYZ,GM\u00127po:{G-Z:NCB\u0004\u0013A\u0006:fg>dg/\u001a3GY><hj\u001c3fgF+X-^3\u0016\u0003A\u00032\u0001N)K\u0013\t\u0011VGA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0002/I,7o\u001c7wK\u00124En\\<O_\u0012,7/U;fk\u0016\u0004\u0013!\u00069s_\u000e,7o]+oe\u0016\u001cx\u000e\u001c<fI\u001acwn\u001e\u000b\u0003\u0015ZCQaV\u0006A\u0002a\u000bAA\u001a7poB\u0011A%W\u0005\u00035:\u0011a\"\u00168sKN|GN^3e\r2|w/A\u0006qe>\u001cWm]:O_\u0012,GcA/m]B\u0019aLZ5\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012\u001b\u0003\u0019a$o\\8u}%\tq$\u0003\u0002f=\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\r\u0019V-\u001d\u0006\u0003Kz\u0001\"\u0001\n6\n\u0005-t!\u0001D$sCBDW\t\\3nK:$\b\"B7\r\u0001\u0004I\u0017\u0001\u00028pI\u0016DQa\u001c\u0007A\u0002u\u000bQ\"\u001e9tiJ,\u0017-\u001c(pI\u0016\u001c\b")
public class CoreDataflowNodeProcessor {
    private final DataflowGraph rawGraph;
    private final FlowResolver flowResolver;
    private final ConcurrentHashMap<TableIdentifier, Input> resolvedInputs;
    private final ConcurrentHashMap<TableIdentifier, ResolvedFlow> resolvedFlowNodesMap;
    private final ConcurrentLinkedQueue<ResolvedFlow> resolvedFlowNodesQueue;

    private FlowResolver flowResolver() {
        return this.flowResolver;
    }

    private ConcurrentHashMap<TableIdentifier, Input> resolvedInputs() {
        return this.resolvedInputs;
    }

    private ConcurrentHashMap<TableIdentifier, ResolvedFlow> resolvedFlowNodesMap() {
        return this.resolvedFlowNodesMap;
    }

    private ConcurrentLinkedQueue<ResolvedFlow> resolvedFlowNodesQueue() {
        return this.resolvedFlowNodesQueue;
    }

    private ResolvedFlow processUnresolvedFlow(UnresolvedFlow flow) {
        ResolvedFlow resolvedFlow = this.flowResolver().attemptResolveFlow(flow, this.rawGraph.inputIdentifiers(), (Map<TableIdentifier, Input>)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.resolvedInputs()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.resolvedFlowNodesQueue().add(resolvedFlow);
        this.resolvedFlowNodesMap().put(flow.identifier(), resolvedFlow);
        return resolvedFlow;
    }

    public Seq<GraphElement> processNode(GraphElement node, Seq<GraphElement> upstreamNodes) {
        GraphElement graphElement = node;
        if (graphElement instanceof UnresolvedFlow) {
            UnresolvedFlow unresolvedFlow = (UnresolvedFlow)graphElement;
            return new .colon.colon((Object)this.processUnresolvedFlow(unresolvedFlow), (List)Nil$.MODULE$);
        }
        if (graphElement instanceof ResolutionFailedFlow) {
            ResolutionFailedFlow resolutionFailedFlow = (ResolutionFailedFlow)graphElement;
            return new .colon.colon((Object)this.processUnresolvedFlow(resolutionFailedFlow.flow()), (List)Nil$.MODULE$);
        }
        if (graphElement instanceof Table) {
            Table table = (Table)graphElement;
            Seq flowsToTable = (Seq)upstreamNodes.map((Function1 & Serializable)x0$1 -> {
                GraphElement graphElement = x0$1;
                if (graphElement instanceof Flow) {
                    Flow flow = (Flow)graphElement;
                    return flow;
                }
                throw new IllegalArgumentException("Unsupported upstream node type for table " + table.displayName() + ": " + upstreamNodes.getClass());
            });
            Seq resolvedFlowsToTable = (Seq)flowsToTable.map((Function1 & Serializable)flow -> this.resolvedFlowNodesMap().get(flow.identifier()));
            VirtualTableInput virtualTableInput = new VirtualTableInput(table.identifier(), table.specifiedSchema(), (Set<TableIdentifier>)((IterableOnceOps)flowsToTable.map((Function1 & Serializable)x$1 -> x$1.identifier())).toSet(), (Seq<ResolvedFlow>)resolvedFlowsToTable);
            this.resolvedInputs().put(table.identifier(), virtualTableInput);
            return new .colon.colon((Object)table, (List)Nil$.MODULE$);
        }
        if (graphElement instanceof View) {
            View view = (View)graphElement;
            Predef$.MODULE$.require(upstreamNodes.size() == 1, (Function0 & Serializable)() -> "Found multiple flows to view");
            GraphElement graphElement2 = (GraphElement)upstreamNodes.head();
            if (graphElement2 instanceof Flow) {
                Flow flow2 = (Flow)graphElement2;
                this.resolvedInputs().put(view.identifier(), this.resolvedFlowNodesMap().get(flow2.destinationIdentifier()));
                return new .colon.colon((Object)view, (List)Nil$.MODULE$);
            }
            throw new IllegalArgumentException("Unsupported upstream node type for view " + view.displayName() + ": " + upstreamNodes.getClass());
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass());
    }

    public CoreDataflowNodeProcessor(DataflowGraph rawGraph) {
        this.rawGraph = rawGraph;
        this.flowResolver = new FlowResolver(rawGraph);
        this.resolvedInputs = new ConcurrentHashMap();
        this.resolvedFlowNodesMap = new ConcurrentHashMap();
        this.resolvedFlowNodesQueue = new ConcurrentLinkedQueue();
    }
}

