/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest.mesos;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.mesos.MesosDriverDescription;
import org.apache.spark.deploy.mesos.MesosDriverDescription$;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.ErrorResponse;
import org.apache.spark.deploy.rest.SubmitRequestServlet;
import org.apache.spark.deploy.rest.SubmitRestMissingFieldException;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.package$;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterScheduler;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c!\u0002\u000b\u0016\u0001U\t\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011A\u0002!\u0011!Q\u0001\nEBQ!\u000e\u0001\u0005\u0002YBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004D\u0001\u0001\u0006I!\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019I\u0005\u0001)A\u0005\r\"9!\n\u0001b\u0001\n\u0013Y\u0005BB(\u0001A\u0003%A\nC\u0004Q\u0001\t\u0007I\u0011B)\t\ry\u0003\u0001\u0015!\u0003S\u0011\u0015y\u0006\u0001\"\u0003a\u0011\u00159\u0007\u0001\"\u0003i\u0011\u001dQ\bA1A\u0005\n-Caa\u001f\u0001!\u0002\u0013a\u0005b\u0002?\u0001\u0005\u0004%I!\u0012\u0005\u0007{\u0002\u0001\u000b\u0011\u0002$\t\u000by\u0004A\u0011B@\t\u000f\u0005U\u0001\u0001\"\u0015\u0002\u0018\tIR*Z:pgN+(-\\5u%\u0016\fX/Z:u'\u0016\u0014h\u000f\\3u\u0015\t1r#A\u0003nKN|7O\u0003\u0002\u00193\u0005!!/Z:u\u0015\tQ2$\u0001\u0004eKBdw.\u001f\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sON\u0011\u0001A\t\t\u0003G\u0011j\u0011aF\u0005\u0003K]\u0011AcU;c[&$(+Z9vKN$8+\u001a:wY\u0016$\u0018!C:dQ\u0016$W\u000f\\3s\u0007\u0001\u0001\"!\u000b\u0018\u000e\u0003)R!AF\u0016\u000b\u00051j\u0013aB2mkN$XM\u001d\u0006\u0003MmI!a\f\u0016\u0003+5+7o\\:DYV\u001cH/\u001a:TG\",G-\u001e7fe\u0006!1m\u001c8g!\t\u00114'D\u0001\u001c\u0013\t!4DA\u0005Ta\u0006\u00148nQ8oM\u00061A(\u001b8jiz\"2aN\u001d;!\tA\u0004!D\u0001\u0016\u0011\u001513\u00011\u0001)\u0011\u0015\u00014\u00011\u00012\u0003E!UIR!V\u0019R{6+\u0016)F%ZK5+R\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9!i\\8mK\u0006t\u0017A\u0005#F\r\u0006+F\nV0T+B+%KV%T\u000b\u0002\na\u0002R#G\u0003VcEkX'F\u001b>\u0013\u0016,F\u0001G!\tqt)\u0003\u0002I\u007f\t\u0019\u0011J\u001c;\u0002\u001f\u0011+e)Q+M)~kU)T(S3\u0002\nQ\u0002R#G\u0003VcEkX\"P%\u0016\u001bV#\u0001'\u0011\u0005yj\u0015B\u0001(@\u0005\u0019!u.\u001e2mK\u0006qA)\u0012$B+2#vlQ(S\u000bN\u0003\u0013\u0001\u00058fqR$%/\u001b<fe:+XNY3s+\u0005\u0011\u0006CA*]\u001b\u0005!&BA+W\u0003\u0019\tGo\\7jG*\u0011q\u000bW\u0001\u000bG>t7-\u001e:sK:$(BA-[\u0003\u0011)H/\u001b7\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0016\u0002\u000b\u0003R|W.[2M_:<\u0017!\u00058fqR$%/\u001b<fe:+XNY3sA\u0005\u00012M]3bi\u0016$\u0015\r^3G_Jl\u0017\r^\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AMW\u0001\u0005i\u0016DH/\u0003\u0002gG\n\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r^\u0001\f]\u0016<HI]5wKJLE\r\u0006\u0002jiB\u0011!.\u001d\b\u0003W>\u0004\"\u0001\\ \u000e\u00035T!A\\\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\u0001x(\u0001\u0004Qe\u0016$WMZ\u0005\u0003eN\u0014aa\u0015;sS:<'B\u00019@\u0011\u0015)X\u00021\u0001w\u0003)\u0019XOY7ji\u0012\u000bG/\u001a\t\u0003obl\u0011\u0001W\u0005\u0003sb\u0013A\u0001R1uK\u00061R*R'P%f{vJV#S\u0011\u0016\u000bEi\u0018$B\u0007R{%+A\fN\u000b6{%+W0P-\u0016\u0013\u0006*R!E?\u001a\u000b5\tV(SA\u0005\u0019R*R'P%f{vJV#S\u0011\u0016\u000bEiX'J\u001d\u0006!R*R'P%f{vJV#S\u0011\u0016\u000bEiX'J\u001d\u0002\naCY;jY\u0012$%/\u001b<fe\u0012+7o\u0019:jaRLwN\u001c\u000b\u0005\u0003\u0003\tY\u0001\u0005\u0003\u0002\u0004\u0005\u001dQBAA\u0003\u0015\t1\u0012$\u0003\u0003\u0002\n\u0005\u0015!AF'fg>\u001cHI]5wKJ$Um]2sSB$\u0018n\u001c8\t\u000f\u00055!\u00031\u0001\u0002\u0010\u00059!/Z9vKN$\bcA\u0012\u0002\u0012%\u0019\u00111C\f\u0003/\r\u0013X-\u0019;f'V\u0014W.[:tS>t'+Z9vKN$\u0018\u0001\u00045b]\u0012dWmU;c[&$H\u0003CA\r\u0003?\t\u0019#!\f\u0011\u0007\r\nY\"C\u0002\u0002\u001e]\u0011!dU;c[&$(+Z:u!J|Go\\2pYJ+7\u000f]8og\u0016Da!!\t\u0014\u0001\u0004I\u0017A\u0005:fcV,7\u000f^'fgN\fw-\u001a&t_:Dq!!\n\u0014\u0001\u0004\t9#\u0001\bsKF,Xm\u001d;NKN\u001c\u0018mZ3\u0011\u0007\r\nI#C\u0002\u0002,]\u0011\u0011dU;c[&$(+Z:u!J|Go\\2pY6+7o]1hK\"9\u0011qF\nA\u0002\u0005E\u0012a\u0004:fgB|gn]3TKJ4H.\u001a;\u0011\t\u0005M\u0012\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005!\u0001\u000e\u001e;q\u0015\u0011\tY$!\u0010\u0002\u000fM,'O\u001e7fi*\u0011\u0011qH\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003\u0007\n)DA\nIiR\u00048+\u001a:wY\u0016$(+Z:q_:\u001cX\r")
public class MesosSubmitRequestServlet
extends SubmitRequestServlet {
    private final MesosClusterScheduler scheduler;
    private final boolean DEFAULT_SUPERVISE;
    private final int DEFAULT_MEMORY;
    private final double DEFAULT_CORES;
    private final AtomicLong nextDriverNumber;
    private final double MEMORY_OVERHEAD_FACTOR;
    private final int MEMORY_OVERHEAD_MIN;

    private boolean DEFAULT_SUPERVISE() {
        return this.DEFAULT_SUPERVISE;
    }

    private int DEFAULT_MEMORY() {
        return this.DEFAULT_MEMORY;
    }

    private double DEFAULT_CORES() {
        return this.DEFAULT_CORES;
    }

    private AtomicLong nextDriverNumber() {
        return this.nextDriverNumber;
    }

    private SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    }

    private String newDriverId(Date submitDate) {
        String arg$macro$1 = this.createDateFormat().format(submitDate);
        long arg$macro$2 = this.nextDriverNumber().incrementAndGet();
        return new StringOps("driver-%s-%04d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToLong((long)arg$macro$2)}));
    }

    private double MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    private int MEMORY_OVERHEAD_MIN() {
        return this.MEMORY_OVERHEAD_MIN;
    }

    private MesosDriverDescription buildDriverDescription(CreateSubmissionRequest request) {
        String appResource = (String)Option$.MODULE$.apply((Object)request.appResource()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Application jar 'appResource' is missing.");
        });
        String mainClass = (String)Option$.MODULE$.apply((Object)request.mainClass()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Main class 'mainClass' is missing.");
        });
        String[] appArgs = (String[])Option$.MODULE$.apply((Object)request.appArgs()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Application arguments 'appArgs' are missing.");
        });
        scala.collection.immutable.Map environmentVariables = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)request.environmentVariables()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Environment variables 'environmentVariables' are missing.");
        });
        scala.collection.immutable.Map sparkProperties = request.sparkProperties();
        Option driverDefaultJavaOptions = sparkProperties.get((Object)"spark.driver.defaultJavaOptions");
        Option driverExtraJavaOptions = sparkProperties.get((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_JAVA_OPTIONS().key());
        Option driverExtraClassPath = sparkProperties.get((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CLASS_PATH().key());
        Option driverExtraLibraryPath = sparkProperties.get((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_LIBRARY_PATH().key());
        Option superviseDriver = sparkProperties.get((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_SUPERVISE().key());
        Option driverMemory = sparkProperties.get((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key());
        Option driverMemoryOverhead = sparkProperties.get((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD().key());
        Option driverCores = sparkProperties.get((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key());
        String name = (String)request.sparkProperties().getOrElse((Object)"spark.app.name", (Function0 & Serializable & scala.Serializable)() -> mainClass);
        SparkConf conf = new SparkConf(false).setAll((Iterable)sparkProperties);
        Seq extraClassPath = (Seq)Option$.MODULE$.option2Iterable(driverExtraClassPath).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(File.pathSeparator))), Seq$.MODULE$.canBuildFrom());
        Seq extraLibraryPath = (Seq)Option$.MODULE$.option2Iterable(driverExtraLibraryPath).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator))), Seq$.MODULE$.canBuildFrom());
        Seq defaultJavaOpts = (Seq)driverDefaultJavaOptions.map((Function1 & Serializable & scala.Serializable)s -> Utils$.MODULE$.splitCommandString(s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq extraJavaOpts = (Seq)driverExtraJavaOptions.map((Function1 & Serializable & scala.Serializable)s -> Utils$.MODULE$.splitCommandString(s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq sparkJavaOpts = Utils$.MODULE$.sparkJavaOpts(conf, Utils$.MODULE$.sparkJavaOpts$default$2());
        Seq javaOpts = (Seq)((TraversableLike)sparkJavaOpts.$plus$plus((GenTraversableOnce)defaultJavaOpts, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command(mainClass, (Seq)Predef$.MODULE$.wrapRefArray((Object[])appArgs), (Map)environmentVariables, extraClassPath, extraLibraryPath, javaOpts);
        boolean actualSuperviseDriver = BoxesRunTime.unboxToBoolean((Object)superviseDriver.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MesosSubmitRequestServlet.$anonfun$buildDriverDescription$12(x$3))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.DEFAULT_SUPERVISE()));
        int actualDriverMemory = BoxesRunTime.unboxToInt((Object)driverMemory.map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToInteger((int)Utils$.MODULE$.memoryStringToMb(str))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.DEFAULT_MEMORY()));
        int actualDriverMemoryOverhead = BoxesRunTime.unboxToInt((Object)driverMemoryOverhead.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)MesosSubmitRequestServlet.$anonfun$buildDriverDescription$16(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> scala.math.package$.MODULE$.max((int)(this.MEMORY_OVERHEAD_FACTOR() * (double)actualDriverMemory), this.MEMORY_OVERHEAD_MIN())));
        double actualDriverCores = BoxesRunTime.unboxToDouble((Object)driverCores.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)MesosSubmitRequestServlet.$anonfun$buildDriverDescription$18(x$5))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.DEFAULT_CORES()));
        Date submitDate = new Date();
        String submissionId = this.newDriverId(submitDate);
        return new MesosDriverDescription(name, appResource, actualDriverMemory + actualDriverMemoryOverhead, actualDriverCores, actualSuperviseDriver, command, (scala.collection.immutable.Map<String, String>)request.sparkProperties(), submissionId, submitDate, MesosDriverDescription$.MODULE$.$lessinit$greater$default$10());
    }

    public SubmitRestProtocolResponse handleSubmit(String requestMessageJson, SubmitRestProtocolMessage requestMessage, HttpServletResponse responseServlet) {
        ErrorResponse errorResponse;
        SubmitRestProtocolMessage submitRestProtocolMessage = requestMessage;
        if (submitRestProtocolMessage instanceof CreateSubmissionRequest) {
            CreateSubmissionRequest createSubmissionRequest = (CreateSubmissionRequest)submitRestProtocolMessage;
            MesosDriverDescription driverDescription = this.buildDriverDescription(createSubmissionRequest);
            CreateSubmissionResponse s = this.scheduler.submitDriver(driverDescription);
            s.serverSparkVersion_$eq(package$.MODULE$.SPARK_VERSION());
            String[] unknownFields = this.findUnknownFields(requestMessageJson, requestMessage);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unknownFields)).nonEmpty()) {
                s.unknownFields_$eq(unknownFields);
            }
            errorResponse = s;
        } else {
            responseServlet.setStatus(400);
            errorResponse = this.handleError(new StringBuilder(37).append("Received message of unexpected type ").append(submitRestProtocolMessage.messageType()).append(".").toString());
        }
        return errorResponse;
    }

    public static final /* synthetic */ boolean $anonfun$buildDriverDescription$12(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$buildDriverDescription$16(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ double $anonfun$buildDriverDescription$18(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toDouble();
    }

    public MesosSubmitRequestServlet(MesosClusterScheduler scheduler, SparkConf conf) {
        this.scheduler = scheduler;
        this.DEFAULT_SUPERVISE = false;
        this.DEFAULT_MEMORY = Utils$.MODULE$.DEFAULT_DRIVER_MEM_MB();
        this.DEFAULT_CORES = 1.0;
        this.nextDriverNumber = new AtomicLong(0L);
        this.MEMORY_OVERHEAD_FACTOR = 0.1;
        this.MEMORY_OVERHEAD_MIN = 384;
    }
}

