/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterPersistenceEngine;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!\u0002\u0007\u000e\u0001MI\u0002\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011]\u0002!\u0011!Q\u0001\naB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019!\u0006\u0001)A\u0005\u001b\")Q\u000b\u0001C\u0001-\")\u0011\f\u0001C!5\")q\f\u0001C!A\")q\r\u0001C!Q\")\u0011\u0010\u0001C!u\n1#l\\8lK\u0016\u0004XM]'fg>\u001c8\t\\;ti\u0016\u0014\b+\u001a:tSN$XM\\2f\u000b:<\u0017N\\3\u000b\u00059y\u0011!B7fg>\u001c(B\u0001\t\u0012\u0003\u001d\u0019G.^:uKJT!AE\n\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0014\t\u0001Q\u0002\u0005\n\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"A\u0007\n\u0005\rj!!H'fg>\u001c8\t\\;ti\u0016\u0014\b+\u001a:tSN$XM\\2f\u000b:<\u0017N\\3\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\u001a\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgnZ\u0001\bE\u0006\u001cX\rR5s\u0007\u0001\u0001\"!\f\u001b\u000f\u00059\u0012\u0004CA\u0018\u001d\u001b\u0005\u0001$BA\u0019,\u0003\u0019a$o\\8u}%\u00111\u0007H\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u000249\u0005\u0011!p\u001b\t\u0003syj\u0011A\u000f\u0006\u0003wq\n\u0011B\u001a:b[\u0016<xN]6\u000b\u0005u*\u0012aB2ve\u0006$xN]\u0005\u0003\u007fi\u0012\u0001cQ;sCR|'O\u0012:b[\u0016<xN]6\u0002\t\r|gN\u001a\t\u0003\u0005\u000ek\u0011aE\u0005\u0003\tN\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\u00119\u0005*\u0013&\u0011\u0005\u0005\u0002\u0001\"\u0002\u0016\u0005\u0001\u0004a\u0003\"B\u001c\u0005\u0001\u0004A\u0004\"\u0002!\u0005\u0001\u0004\t\u0015aC,P%.KejR0E\u0013J+\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017BA\u001bP\u000319vJU&J\u001d\u001e{F)\u0013*!\u0003\u0011\u0001\u0018\r\u001e5\u0015\u00051:\u0006\"\u0002-\b\u0001\u0004a\u0013\u0001\u00028b[\u0016\fq!\u001a=qk:<W\r\u0006\u0002\\=B\u00111\u0004X\u0005\u0003;r\u0011A!\u00168ji\")\u0001\f\u0003a\u0001Y\u00059\u0001/\u001a:tSN$HcA.bE\")\u0001,\u0003a\u0001Y!)1-\u0003a\u0001I\u0006\u0019qN\u00196\u0011\u00059+\u0017B\u00014P\u0005\u0019y%M[3di\u0006)a-\u001a;dQV\u0011\u0011n\u001c\u000b\u0003Ub\u00042aG6n\u0013\taGD\u0001\u0004PaRLwN\u001c\t\u0003]>d\u0001\u0001B\u0003q\u0015\t\u0007\u0011OA\u0001U#\t\u0011X\u000f\u0005\u0002\u001cg&\u0011A\u000f\b\u0002\b\u001d>$\b.\u001b8h!\tYb/\u0003\u0002x9\t\u0019\u0011I\\=\t\u000baS\u0001\u0019\u0001\u0017\u0002\u0011\u0019,Go\u00195BY2,2a_A\u0007)\u0005a\b#B?\u0002\u0006\u0005-ab\u0001@\u0002\u00029\u0011qf`\u0005\u0002;%\u0019\u00111\u0001\u000f\u0002\u000fA\f7m[1hK&!\u0011qAA\u0005\u0005!IE/\u001a:bE2,'bAA\u00029A\u0019a.!\u0004\u0005\u000bA\\!\u0019A9")
public class ZookeeperMesosClusterPersistenceEngine
implements MesosClusterPersistenceEngine,
Logging {
    private final CuratorFramework zk;
    private final String WORKING_DIR;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String WORKING_DIR() {
        return this.WORKING_DIR;
    }

    public String path(String name) {
        return new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(name).toString();
    }

    @Override
    public void expunge(String name) {
        this.zk.delete().forPath(this.path(name));
    }

    @Override
    public void persist(String name, Object obj) {
        byte[] serialized = Utils$.MODULE$.serialize(obj);
        String zkPath = this.path(name);
        ((PathAndBytesable)this.zk.create().withMode(CreateMode.PERSISTENT)).forPath(zkPath, serialized);
    }

    @Override
    public <T> Option<T> fetch(String name) {
        None$ none$;
        String zkPath = this.path(name);
        try {
            byte[] fileData = (byte[])this.zk.getData().forPath(zkPath);
            none$ = new Some(Utils$.MODULE$.deserialize(fileData));
        }
        catch (KeeperException.NoNodeException e) {
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while reading persisted file, deleting", e);
            this.zk.delete().forPath(zkPath);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public <T> Iterable<T> fetchAll() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk.getChildren().forPath(this.WORKING_DIR())).asScala()).flatMap((Function1 & Serializable & scala.Serializable)name -> Option$.MODULE$.option2Iterable(this.fetch((String)name)), Buffer$.MODULE$.canBuildFrom());
    }

    public ZookeeperMesosClusterPersistenceEngine(String baseDir, CuratorFramework zk, SparkConf conf) {
        this.zk = zk;
        Logging.$init$((Logging)this);
        this.WORKING_DIR = new StringBuilder(1).append(conf.get("spark.deploy.zookeeper.dir", "/spark_mesos_dispatcher")).append("/").append(baseDir).toString();
        SparkCuratorUtil$.MODULE$.mkdir(zk, this.WORKING_DIR());
    }
}

