/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.mesos.ui;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.mesos.Protos;
import org.apache.spark.deploy.mesos.MesosDriverDescription;
import org.apache.spark.deploy.mesos.config.package$;
import org.apache.spark.deploy.mesos.ui.MesosClusterUI;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterRetryState;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterSchedulerState;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterSubmissionState;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!\u0002\u0006\f\u000159\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000f\u001d\u0002!\u0019!C\u0005Q!1!\b\u0001Q\u0001\n%BQa\u000f\u0001\u0005\u0002qBQ\u0001\u0017\u0001\u0005\neCQ\u0001\u0019\u0001\u0005\n\u0005DQ!\u001c\u0001\u0005\n9DQ\u0001\u001d\u0001\u0005\nE\u0014\u0001#T3t_N\u001cE.^:uKJ\u0004\u0016mZ3\u000b\u00051i\u0011AA;j\u0015\tqq\"A\u0003nKN|7O\u0003\u0002\u0011#\u00051A-\u001a9m_fT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\n\u0003\u0001a\u0001\"!G\u000e\u000e\u0003iQ!\u0001D\t\n\u0005qQ\"!C,fEVK\u0005+Y4f\u0003\u0019\u0001\u0018M]3oi\u000e\u0001\u0001C\u0001\u0011\"\u001b\u0005Y\u0011B\u0001\u0012\f\u00059iUm]8t\u00072,8\u000f^3s+&\u000ba\u0001P5oSRtDCA\u0013'!\t\u0001\u0003\u0001C\u0003\u001e\u0005\u0001\u0007q$\u0001\tiSN$xN]=TKJ4XM]+S\u0019V\t\u0011\u0006E\u0002+[=j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005A:dBA\u00196!\t\u00114&D\u00014\u0015\t!d$\u0001\u0004=e>|GOP\u0005\u0003m-\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011agK\u0001\u0012Q&\u001cHo\u001c:z'\u0016\u0014h/\u001a:V%2\u0003\u0013A\u0002:f]\u0012,'\u000f\u0006\u0002>\u0019B\u0019ah\u0011$\u000f\u0005}\neB\u0001\u001aA\u0013\u0005a\u0013B\u0001\",\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u0007M+\u0017O\u0003\u0002CWA\u0011qIS\u0007\u0002\u0011*\u0011\u0011jK\u0001\u0004q6d\u0017BA&I\u0005\u0011qu\u000eZ3\t\u000b5+\u0001\u0019\u0001(\u0002\u000fI,\u0017/^3tiB\u0011qJV\u0007\u0002!*\u0011\u0011KU\u0001\u0005QR$\bO\u0003\u0002T)\u000691/\u001a:wY\u0016$(\"A+\u0002\u000b)\fg/\u0019=\n\u0005]\u0003&A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\f\u0011\"];fk\u0016$'k\\<\u0015\u0005uR\u0006\"B.\u0007\u0001\u0004a\u0016AC:vE6L7o]5p]B\u0011QLX\u0007\u0002\u001b%\u0011q,\u0004\u0002\u0017\u001b\u0016\u001cxn\u001d#sSZ,'\u000fR3tGJL\u0007\u000f^5p]\u0006IAM]5wKJ\u0014vn\u001e\u000b\u0003{\tDQaY\u0004A\u0002\u0011\fQa\u001d;bi\u0016\u0004\"!Z6\u000e\u0003\u0019T!AD4\u000b\u0005!L\u0017aB2mkN$XM\u001d\u0006\u0003UF\t\u0011b]2iK\u0012,H.\u001a:\n\u000514'aG'fg>\u001c8\t\\;ti\u0016\u00148+\u001e2nSN\u001c\u0018n\u001c8Ti\u0006$X-\u0001\u0005sKR\u0014\u0018PU8x)\tit\u000eC\u0003\\\u0011\u0001\u0007A,A\u0006ti\u0006$Xm\u0015;sS:<GCA\u0018s\u0011\u0015\u0019\u0018\u00021\u0001u\u0003\u0019\u0019H/\u0019;vgB\u0019!&L;\u0011\u0007Y\f\tA\u0004\u0002x{:\u0011\u0001\u0010 \b\u0003snt!A\r>\n\u0003YI!\u0001F\u000b\n\u00059\u0019\u0012B\u0001@\u0000\u0003\u0019\u0001&o\u001c;pg*\u0011abE\u0005\u0005\u0003\u0007\t)A\u0001\u0006UCN\\7\u000b^1ukNT!A`@")
public class MesosClusterPage
extends WebUIPage {
    private final MesosClusterUI parent;
    private final Option<String> historyServerURL;

    private Option<String> historyServerURL() {
        return this.historyServerURL;
    }

    public Seq<Node> render(HttpServletRequest request) {
        MesosClusterSchedulerState state2 = this.parent.scheduler().getSchedulerState();
        Seq driverHeader = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver ID"}));
        Seq historyHeader = (Seq)this.historyServerURL().map((Function1 & Serializable & scala.Serializable)url -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"History"}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq submissionHeader = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Submit Date", "Main Class", "Driver Resources"}));
        Seq sandboxHeader = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sandbox"}));
        Seq queuedHeaders = (Seq)driverHeader.$plus$plus((GenTraversableOnce)submissionHeader, Seq$.MODULE$.canBuildFrom());
        Seq driverHeaders = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)driverHeader.$plus$plus((GenTraversableOnce)historyHeader, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)submissionHeader, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start Date", "Mesos Slave ID", "State"})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)sandboxHeader, Seq$.MODULE$.canBuildFrom());
        Seq retryHeaders = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver ID", "Submit Date", "Description"}))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Last Failed Status", "Next Retry Time", "Attempt Count"})), Seq$.MODULE$.canBuildFrom());
        Seq queuedTable = UIUtils$.MODULE$.listingTable(queuedHeaders, (Function1 & Serializable & scala.Serializable)submission -> this.queuedRow((MesosDriverDescription)submission), state2.queuedDrivers(), UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8());
        Seq launchedTable = UIUtils$.MODULE$.listingTable(driverHeaders, (Function1 & Serializable & scala.Serializable)state -> this.driverRow((MesosClusterSubmissionState)state), state2.launchedDrivers(), UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8());
        Seq finishedTable = UIUtils$.MODULE$.listingTable(driverHeaders, (Function1 & Serializable & scala.Serializable)state -> this.driverRow((MesosClusterSubmissionState)state), state2.finishedDrivers(), UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8());
        Seq retryTable = UIUtils$.MODULE$.listingTable(retryHeaders, (Function1 & Serializable & scala.Serializable)submission -> this.retryRow((MesosDriverDescription)submission), state2.pendingRetryDrivers(), UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8());
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Mesos Framework ID: "));
        $buf2.$amp$plus((Object)state2.frameworkId());
        $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md2);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Queued Drivers:"));
        $buf4.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)queuedTable);
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Launched Drivers:"));
        $buf4.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)launchedTable);
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Finished Drivers:"));
        $buf4.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)finishedTable);
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Supervise drivers waiting for retry:"));
        $buf4.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)retryTable);
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        NodeBuffer content = $buf;
        return UIUtils$.MODULE$.basicSparkPage(request, (Function0 & Serializable & scala.Serializable)() -> content, "Spark Drivers for Mesos cluster", UIUtils$.MODULE$.basicSparkPage$default$4());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> queuedRow(MesosDriverDescription submission) {
        void var3_3;
        String id = submission.submissionId();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", new StringBuilder(10).append("driver?id=").append(id).toString(), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)id);
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDate(submission.submissionDate()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)submission.command().mainClass());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("cpus: "));
        $buf6.$amp$plus((Object)BoxesRunTime.boxToDouble((double)submission.cores()));
        $buf6.$amp$plus((Object)new Text(", mem: "));
        $buf6.$amp$plus((Object)BoxesRunTime.boxToInteger((int)submission.mem()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    private Seq<Node> driverRow(MesosClusterSubmissionState state) {
        Nil$ nil$;
        String sandboxCol;
        String string;
        String id = state.driverDescription().submissionId();
        Option proxy = this.parent.conf().getOption("spark.mesos.proxy.baseURL");
        if (proxy.isDefined()) {
            String clusterSchedulerId = this.parent.scheduler().getSchedulerState().frameworkId();
            String sandBoxUri = new StringBuilder(22).append(proxy.get()).append("/#/agents/").append(state.slaveId().getValue()).append("/frameworks/").append(new StringBuilder(18).append(clusterSchedulerId).append("/executors/").append(id).append("/browse").toString()).toString();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("href", sandBoxUri, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("Sandbox"));
            Elem elem = new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            string = elem;
        } else {
            string = sandboxCol = " ";
        }
        if (this.historyServerURL().isDefined()) {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("href", new StringBuilder(9).append(this.historyServerURL().get()).append("/history/").append(state.frameworkId()).toString(), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)state.frameworkId());
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            nil$ = elem;
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ historyCol = nil$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", new StringBuilder(10).append("driver?id=").append(id).toString(), (MetaData)$md);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)id);
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)historyCol);
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDate(state.driverDescription().submissionDate()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)state.driverDescription().command().mainClass());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("cpus: "));
        $buf7.$amp$plus((Object)BoxesRunTime.boxToDouble((double)state.driverDescription().cores()));
        $buf7.$amp$plus((Object)new Text(", mem: "));
        $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)state.driverDescription().mem()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)UIUtils$.MODULE$.formatDate(state.startDate()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)state.slaveId().getValue());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)this.stateString(state.mesosTaskStatus()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)sandboxCol);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> retryRow(MesosDriverDescription submission) {
        void var3_3;
        String id = submission.submissionId();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", new StringBuilder(10).append("driver?id=").append(id).toString(), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)id);
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDate(submission.submissionDate()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)submission.command().mainClass());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)((MesosClusterRetryState)submission.retryState().get()).lastFailureStatus());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)((MesosClusterRetryState)submission.retryState().get()).nextRetry());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)((MesosClusterRetryState)submission.retryState().get()).retries()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    private String stateString(Option<Protos.TaskStatus> status) {
        if (status.isEmpty()) {
            return "";
        }
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        Protos.TaskStatus s = (Protos.TaskStatus)status.get();
        sb.append(new StringBuilder(7).append("State: ").append(s.getState()).toString());
        Object object = ((Protos.TaskStatus)status.get()).hasMessage() ? sb.append(new StringBuilder(11).append(", Message: ").append(s.getMessage()).toString()) : BoxedUnit.UNIT;
        Object object2 = ((Protos.TaskStatus)status.get()).hasHealthy() ? sb.append(new StringBuilder(11).append(", Healthy: ").append(s.getHealthy()).toString()) : BoxedUnit.UNIT;
        Object object3 = ((Protos.TaskStatus)status.get()).hasSource() ? sb.append(new StringBuilder(10).append(", Source: ").append(s.getSource()).toString()) : BoxedUnit.UNIT;
        Object object4 = ((Protos.TaskStatus)status.get()).hasReason() ? sb.append(new StringBuilder(10).append(", Reason: ").append(s.getReason()).toString()) : BoxedUnit.UNIT;
        Object object5 = ((Protos.TaskStatus)status.get()).hasTimestamp() ? sb.append(new StringBuilder(8).append(", Time: ").append(s.getTimestamp()).toString()) : BoxedUnit.UNIT;
        return sb.toString();
    }

    public MesosClusterPage(MesosClusterUI parent) {
        this.parent = parent;
        super("");
        this.historyServerURL = (Option)parent.conf().get(package$.MODULE$.HISTORY_SERVER_URL());
    }
}

