/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001%3Qa\u0002\u0005\u0001\u001dQA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015!\u0005\u0001\"\u0001F\u0005\u0019\u0019E.[3oi*\u0011\u0011BC\u0001\u0007gV\u0014W.\u001b;\u000b\u0005-a\u0011aA69g*\u0011QBD\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c2\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011AdH\u0007\u0002;)\u0011aDD\u0001\tS:$XM\u001d8bY&\u0011\u0001%\b\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011A%J\u0007\u0002\u0015%\u0011aE\u0003\u0002\u0015\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001cuN\u001c4\u0002\u000f\t,\u0018\u000e\u001c3feB\u0011\u0011FK\u0007\u0002\u0011%\u00111\u0006\u0003\u0002\u0018\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0014U/\u001b7eKJ\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u00059:T\"A\u0018\u000b\u0005A\n\u0014AB2mS\u0016tGO\u0003\u00023g\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005Q*\u0014a\u00024bEJL7\r\u000f\u0006\u0002m\u0005\u0011\u0011n\\\u0005\u0003q=\u0012\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u000f]\fGo\u00195feB\u0011\u0011fO\u0005\u0003y!\u0011q\u0003T8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:\u0002\rqJg.\u001b;?)\u0015y\u0004)\u0011\"D!\tI\u0003\u0001C\u0003\"\u000b\u0001\u00071\u0005C\u0003(\u000b\u0001\u0007\u0001\u0006C\u0003-\u000b\u0001\u0007Q\u0006C\u0003:\u000b\u0001\u0007!(A\u0002sk:$\u0012A\u0012\t\u0003-\u001dK!\u0001S\f\u0003\tUs\u0017\u000e\u001e")
public class Client
implements Logging {
    private final KubernetesDriverConf conf;
    private final KubernetesDriverBuilder builder;
    private final KubernetesClient kubernetesClient;
    private final LoggingPodStatusWatcher watcher;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void run() {
        KubernetesDriverSpec resolvedDriverSpec = this.builder.buildFromFeatures(this.conf, this.kubernetesClient);
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameDriver();
        Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf.sparkConf(), resolvedDriverSpec.systemProperties());
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, (Map<String, String>)confFilesMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key()), (Object)this.conf.namespace())), KubernetesClientUtils$.MODULE$.buildConfigMap$default$3());
        Container resolvedDriverContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(resolvedDriverSpec.pod().container()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Pod resolvedDriverPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(resolvedDriverSpec.pod().pod()).editSpec().addToContainers(new Container[]{resolvedDriverContainer}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withNewConfigMap().withItems((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(KubernetesClientUtils$.MODULE$.buildKeyToPathObjects(confFilesMap)).asJava()).withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        String driverPodName = resolvedDriverPod.getMetadata().getName();
        Seq<HasMetadata> preKubernetesResources = resolvedDriverSpec.driverPreKubernetesResources();
        try {
            this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Please check \"kubectl auth can-i create [resource]\" first. It should be yes. And please also check your feature step implementation.");
                this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).delete();
                throw e;
            }
            throw throwable;
        }
        ObjectRef watch = ObjectRef.create(null);
        Pod createdDriverPod = null;
        try {
            createdDriverPod = (Pod)((CreateOrReplaceable)((AnyNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.conf.namespace())).resource((Object)resolvedDriverPod)).create();
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).delete();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Please check \"kubectl auth can-i create pod\" first. It should be yes.");
                throw e;
            }
            throw throwable;
        }
        try {
            KubernetesUtils$.MODULE$.addOwnerReference(createdDriverPod, preKubernetesResources);
            this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable4);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                ((Deletable)this.kubernetesClient.pods().resource((Object)createdDriverPod)).delete();
                this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).delete();
                throw e;
            }
            throw throwable;
        }
        try {
            Seq otherKubernetesResources = (Seq)resolvedDriverSpec.driverKubernetesResources().$plus$plus((GenTraversableOnce)new .colon.colon((Object)configMap, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
            KubernetesUtils$.MODULE$.addOwnerReference(createdDriverPod, (Seq<HasMetadata>)otherKubernetesResources);
            this.kubernetesClient.resourceList((HasMetadata[])otherKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
        }
        catch (Throwable throwable) {
            Throwable throwable5 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable5);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                ((Deletable)this.kubernetesClient.pods().resource((Object)createdDriverPod)).delete();
                throw e;
            }
            throw throwable;
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()))) {
            String sId = ((TraversableOnce)new .colon.colon((Object)this.conf.namespace(), (List)new .colon.colon((Object)driverPodName, (List)Nil$.MODULE$))).mkString(":");
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                do {
                    PodResource podWithName = (PodResource)((Nameable)$this.kubernetesClient.pods().inNamespace($this.conf.namespace())).withName(driverPodName);
                    $this.watcher.reset();
                    watch$1.elem = podWithName.watch((Watcher)$this.watcher);
                    $this.watcher.eventReceived(Watcher.Action.MODIFIED, podWithName.get());
                } while (!$this.watcher.watchOrStop(sId));
                ((Watch)watch$1.elem).close();
                throw Breaks$.MODULE$.break();
            });
            return;
        }
    }

    public Client(KubernetesDriverConf conf, KubernetesDriverBuilder builder, KubernetesClient kubernetesClient, LoggingPodStatusWatcher watcher) {
        this.conf = conf;
        this.builder = builder;
        this.kubernetesClient = kubernetesClient;
        this.watcher = watcher;
        Logging.$init$((Logging)this);
    }
}

