/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$ClientType$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStoreImpl;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStoreImpl$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.StatefulSetPodsAllocator;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Qa\u0002\u0005\u0001\u001dQAQ!\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005B-BQ\u0001\u0010\u0001\u0005BuBQ\u0001\u0013\u0001\u0005B%Ca\u0001\u0015\u0001\u0005\u0002!\t\u0006\"B5\u0001\t\u0003R'\u0001G&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;fe6\u000bg.Y4fe*\u0011\u0011BC\u0001\u0004Wb\u001a(BA\u0006\r\u0003\u001d\u0019G.^:uKJT!!\u0004\b\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0014\t\u0001)2d\b\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"\u0001\u0007\n\u0005ya!AF#yi\u0016\u0014h.\u00197DYV\u001cH/\u001a:NC:\fw-\u001a:\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tr\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0011\n#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0006\u0005\u0002*\u00015\t\u0001\"A\u0005dC:\u001c%/Z1uKR\u0011Af\f\t\u0003-5J!AL\f\u0003\u000f\t{w\u000e\\3b]\")\u0001G\u0001a\u0001c\u0005IQ.Y:uKJ,&\u000b\u0014\t\u0003eer!aM\u001c\u0011\u0005Q:R\"A\u001b\u000b\u0005Y2\u0013A\u0002\u001fs_>$h(\u0003\u00029/\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tAt#A\nde\u0016\fG/\u001a+bg.\u001c6\r[3ek2,'\u000fF\u0002?\u0003\u001e\u0003\"\u0001H \n\u0005\u0001c!!\u0004+bg.\u001c6\r[3ek2,'\u000fC\u0003C\u0007\u0001\u00071)\u0001\u0002tGB\u0011A)R\u0007\u0002\u001d%\u0011aI\u0004\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006a\r\u0001\r!M\u0001\u0017GJ,\u0017\r^3TG\",G-\u001e7fe\n\u000b7m[3oIR!!*\u0014(P!\ta2*\u0003\u0002M\u0019\t\u00012k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\u0005\u0006\u0005\u0012\u0001\ra\u0011\u0005\u0006a\u0011\u0001\r!\r\u0005\u0006\u001b\u0011\u0001\rAP\u0001\u001a[\u0006\\W-\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'\u000f\u0006\u0003S+Z#\u0007CA\u0015T\u0013\t!\u0006BA\u000bBEN$(/Y2u!>$7/\u00117m_\u000e\fGo\u001c:\t\u000b\t+\u0001\u0019A\"\t\u000b]+\u0001\u0019\u0001-\u0002!-,(-\u001a:oKR,7o\u00117jK:$\bCA-c\u001b\u0005Q&BA.]\u0003\u0019\u0019G.[3oi*\u0011QLX\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA0a\u0003\u001d1\u0017M\u0019:jGbR\u0011!Y\u0001\u0003S>L!a\u0019.\u0003!-+(-\u001a:oKR,7o\u00117jK:$\b\"B3\u0006\u0001\u00041\u0017AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003S\u001dL!\u0001\u001b\u0005\u00035\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002l]>\u0004\"A\u00067\n\u00055<\"\u0001B+oSRDQ!\u0004\u0004A\u0002yBQ\u0001\u001d\u0004A\u0002)\u000bqAY1dW\u0016tG\r")
public class KubernetesClusterManager
implements ExternalClusterManager,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("k8s");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        return new TaskSchedulerImpl(sc);
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        boolean wasSparkSubmittedInClusterMode = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK()));
        if (wasSparkSubmittedInClusterMode) {
            Predef$.MODULE$.require(((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "If the application is deployed using spark-submit in cluster mode, the driver pod name must be provided.");
            Option serviceAccountCaCrt = new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt")).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.exists()));
            tuple32 = new Tuple3((Object)Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_MASTER_URL()), (Object)serviceAccountCaCrt);
        } else {
            tuple32 = tuple3 = new Tuple3((Object)Config$.MODULE$.KUBERNETES_AUTH_CLIENT_MODE_PREFIX(), (Object)KubernetesUtils$.MODULE$.parseMasterUrl(masterURL), (Object)None$.MODULE$);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String authConfPrefix = (String)tuple3._1();
        String apiServerUri = (String)tuple3._2();
        Option defaultServiceAccountCaCrt = (Option)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)authConfPrefix, (Object)apiServerUri, (Object)defaultServiceAccountCaCrt);
        Tuple3 tuple34 = tuple33;
        String authConfPrefix2 = (String)tuple34._1();
        String apiServerUri2 = (String)tuple34._2();
        Option defaultServiceAccountCaCrt2 = (Option)tuple34._3();
        Object object = !sc.conf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX()) ? sc.conf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)KubernetesConf$.MODULE$.getResourceNamePrefix(sc.conf().get("spark.app.name"))) : BoxedUnit.UNIT;
        KubernetesClient kubernetesClient = SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(apiServerUri2, (Option<String>)new Some(sc.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE())), authConfPrefix2, (Enumeration.Value)SparkKubernetesClientFactory$ClientType$.MODULE$.Driver(), sc.conf(), (Option<File>)defaultServiceAccountCaCrt2);
        Object object2 = ((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).isDefined() ? KubernetesUtils$.MODULE$.loadPodFromTemplate(kubernetesClient, (String)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).get(), (Option<String>)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())), sc.conf()) : BoxedUnit.UNIT;
        ScheduledExecutorService schedulerExecutorService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-executor-maintenance");
        ExecutorPodsSnapshot$.MODULE$.setShouldCheckAllContainers(BoxesRunTime.unboxToBoolean((Object)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_CHECK_ALL_CONTAINERS())));
        String sparkContainerName = (String)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME());
        ExecutorPodsSnapshot$.MODULE$.setSparkContainerName(sparkContainerName);
        ScheduledExecutorService subscribersExecutor = ThreadUtils$.MODULE$.newDaemonThreadPoolScheduledExecutor("kubernetes-executor-snapshots-subscribers", 2);
        ExecutorPodsSnapshotsStoreImpl snapshotsStore = new ExecutorPodsSnapshotsStoreImpl(subscribersExecutor, ExecutorPodsSnapshotsStoreImpl$.MODULE$.$lessinit$greater$default$2());
        ExecutorPodsLifecycleManager executorPodsLifecycleEventHandler = new ExecutorPodsLifecycleManager(sc.conf(), kubernetesClient, snapshotsStore);
        AbstractPodsAllocator executorPodsAllocator = this.makeExecutorPodsAllocator(sc, kubernetesClient, snapshotsStore);
        ExecutorPodsWatchSnapshotSource podsWatchEventSource = new ExecutorPodsWatchSnapshotSource(snapshotsStore, kubernetesClient);
        ScheduledExecutorService eventsPollingExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-executor-pod-polling-sync");
        ExecutorPodsPollingSnapshotSource podsPollingEventSource = new ExecutorPodsPollingSnapshotSource(sc.conf(), kubernetesClient, snapshotsStore, eventsPollingExecutor);
        return new KubernetesClusterSchedulerBackend((TaskSchedulerImpl)scheduler, sc, kubernetesClient, schedulerExecutorService, snapshotsStore, executorPodsAllocator, executorPodsLifecycleEventHandler, podsWatchEventSource, podsPollingEventSource);
    }

    public AbstractPodsAllocator makeExecutorPodsAllocator(SparkContext sc, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore) {
        String string = (String)sc.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR());
        String string2 = "statefulset".equals(string) ? StatefulSetPodsAllocator.class.getName() : ("direct".equals(string) ? ExecutorPodsAllocator.class.getName() : string);
        String executorPodsAllocatorName = string2;
        Class cls = Utils$.MODULE$.classForName(executorPodsAllocatorName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Constructor cstr = cls.getConstructor(SparkConf.class, SecurityManager.class, KubernetesExecutorBuilder.class, KubernetesClient.class, ExecutorPodsSnapshotsStore.class, Clock.class);
        return (AbstractPodsAllocator)cstr.newInstance(sc.conf(), sc.env().securityManager(), new KubernetesExecutorBuilder(), kubernetesClient, snapshotsStore, new SystemClock());
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }

    public KubernetesClusterManager() {
        Logging.$init$((Logging)this);
    }
}

