/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.resource.ResourceProfile$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class KubernetesConf$ {
    public static KubernetesConf$ MODULE$;

    static {
        new KubernetesConf$();
    }

    public KubernetesDriverConf createDriverConf(SparkConf sparkConf, String appId, MainAppResource mainAppResource, String mainClass, String[] appArgs, Option<String> proxyUser) {
        KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
        return new KubernetesDriverConf(sparkConf.clone(), appId, mainAppResource, mainClass, appArgs, proxyUser);
    }

    public KubernetesExecutorConf createExecutorConf(SparkConf sparkConf, String executorId, String appId, Option<Pod> driverPod, int resourceProfileId) {
        return new KubernetesExecutorConf(sparkConf.clone(), appId, executorId, driverPod, resourceProfileId);
    }

    public int createExecutorConf$default$5() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public String getKubernetesAppId() {
        return new StringBuilder(6).append("spark-").append(UUID.randomUUID().toString().replaceAll("-", "")).toString();
    }

    public String getResourceNamePrefix(String appName) {
        String id = KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1());
        return new StringBuilder(1).append(appName).append("-").append(id).toString().trim().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\-]", "-").replaceAll("-+", "-");
    }

    public String getAppNameLabel(String appName) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(StringUtils.abbreviate((String)String.valueOf(appName).trim().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\-]", "-").replaceAll("-+", "-"), (String)"", (int)Config$.MODULE$.KUBERNETES_DNSNAME_MAX_LENGTH()))).stripPrefix("-"))).stripSuffix("-");
    }

    public String buildKubernetesResourceName(String vendorDomain, String resourceName) {
        return new StringBuilder(1).append(vendorDomain).append("/").append(resourceName).toString();
    }

    private KubernetesConf$() {
        MODULE$ = this;
    }
}

