/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUb!\u0002\u0014(\u00015\u001a\u0004\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-\u0004!\u0011!Q\u0001\n1DQa\u001c\u0001\u0005\u0002ADqa\u001f\u0001C\u0002\u0013EC\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B?\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\n\u0001\u0001\u0006I!!\u0004\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u0019\u0001\u0001\u0006I!!\n\t\u0011\u0005M\u0002\u0001\"\u0001(\u0003kAq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011q\u0011\u0001\u0005B\u0005\u0015\u0005bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\t)\u000b\u0001C!\u0003OCq!a/\u0001\t\u0003\ni\fC\u0004\u0002D\u0002!\t%!2\t\u000f\u0005=\u0007\u0001\"\u0015\u0002R\"9\u0011Q\u001d\u0001\u0005R\u0005\u001dhABAx\u0001\u0011\t\t\u0010\u0003\u0004p?\u0011\u0005\u00111\u001f\u0005\b\u0003o|B\u0011BA}\u0011\u001d\u00119a\bC!\u0005\u0013AqAa\u0007 \t\u0003\u0012i\u0002\u0003\b\u0003*\u0001\u0001\n1!A\u0001\n\u0013\t\tIa\u000b\t\u001d\tE\u0002\u0001%A\u0002\u0002\u0003%I!!\"\u00034\t\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI*\u0011\u0001&K\u0001\u0004Wb\u001a(B\u0001\u0016,\u0003\u001d\u0019G.^:uKJT!\u0001L\u0017\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0014\u0005\u0001!\u0004CA\u001b7\u001b\u0005I\u0013BA\u001c*\u0005u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$7\u0001\u0001\t\u0003umj\u0011aK\u0005\u0003y-\u0012\u0011\u0003V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018*\u001c9m\u0003\t\u00198\r\u0005\u0002@\u00016\tQ&\u0003\u0002B[\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003\t6k\u0011!\u0012\u0006\u0003\r\u001e\u000baa\u00197jK:$(B\u0001%J\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003\u0015.\u000bqAZ1ce&\u001c\u0007HC\u0001M\u0003\tIw.\u0003\u0002O\u000b\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u0010Kb,7-\u001e;peN+'O^5dKB\u0011\u0011\u000bW\u0007\u0002%*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011L\u0015\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u00039vk\u0011aJ\u0005\u0003=\u001e\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fA\u0002]8e\u00032dwnY1u_J\u0004\"\u0001X1\n\u0005\t<#!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u0016Y&4WmY=dY\u0016,e/\u001a8u\u0011\u0006tG\r\\3s!\taV-\u0003\u0002gO\taR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018aC<bi\u000eDWI^3oiN\u0004\"\u0001X5\n\u0005)<#aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK\u0006Q\u0001o\u001c7m\u000bZ,g\u000e^:\u0011\u0005qk\u0017B\u00018(\u0005\u0005*\u00050Z2vi>\u0014\bk\u001c3t!>dG.\u001b8h':\f\u0007o\u001d5piN{WO]2f\u0003\u0019a\u0014N\\5u}QQ\u0011O]:ukZ<\b0\u001f>\u0011\u0005q\u0003\u0001\"\u0002\u0017\u000b\u0001\u0004I\u0004\"B\u001f\u000b\u0001\u0004q\u0004\"\u0002\"\u000b\u0001\u0004\u0019\u0005\"B(\u000b\u0001\u0004\u0001\u0006\"\u0002.\u000b\u0001\u0004Y\u0006\"B0\u000b\u0001\u0004\u0001\u0007\"B2\u000b\u0001\u0004!\u0007\"B4\u000b\u0001\u0004A\u0007\"B6\u000b\u0001\u0004a\u0017AE7j]J+w-[:uKJ,GMU1uS>,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0005\u0005\u0005\u0011!B:dC2\f\u0017bAA\u0003\u007f\n1Ai\\;cY\u0016\f1#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_\u0002\n\u0001#\u001b8ji&\fG.\u0012=fGV$xN]:\u0016\u0005\u00055\u0001c\u0001@\u0002\u0010%\u0019\u0011\u0011C@\u0003\u0007%sG/A\tj]&$\u0018.\u00197Fq\u0016\u001cW\u000f^8sg\u0002\nQc\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148/\u0006\u0002\u0002\u001aA\u0019a0a\u0007\n\u0007\u0005uqPA\u0004C_>dW-\u00198\u0002-MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u0002\na\u0002Z3gCVdG\u000f\u0015:pM&dW-\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,5\n\u0001B]3t_V\u00148-Z\u0005\u0005\u0003_\tICA\bSKN|WO]2f!J|g-\u001b7f\u0003=!WMZ1vYR\u0004&o\u001c4jY\u0016\u0004\u0013\u0001\u00053p%\u0016lwN^3Fq\u0016\u001cW\u000f^8s)\u0019\t9$!\u0010\u0002XA\u0019a0!\u000f\n\u0007\u0005mrP\u0001\u0003V]&$\bbBA '\u0001\u0007\u0011\u0011I\u0001\u000bKb,7-\u001e;pe&#\u0007\u0003BA\"\u0003#rA!!\u0012\u0002NA\u0019\u0011qI@\u000e\u0005\u0005%#bAA&q\u00051AH]8pizJ1!a\u0014\u0000\u0003\u0019\u0001&/\u001a3fM&!\u00111KA+\u0005\u0019\u0019FO]5oO*\u0019\u0011qJ@\t\u000f\u0005e3\u00031\u0001\u0002\\\u00051!/Z1t_:\u00042AOA/\u0013\r\tyf\u000b\u0002\u0013\u000bb,7-\u001e;pe2{7o\u001d*fCN|g.\u0001\ftKR,\u0006/\u0012=fGV$xN]\"p]\u001aLw-T1q)\u0011\t9$!\u001a\t\u000f\u0005\u001dD\u00031\u0001\u0002j\u0005IAM]5wKJ\u0004v\u000e\u001a\t\u0006}\u0006-\u0014qN\u0005\u0004\u0003[z(AB(qi&|g\u000e\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u000b5|G-\u001a7\u000b\u0007\u0005et)A\u0002ba&LA!! \u0002t\t\u0019\u0001k\u001c3\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e)\t\t\t%A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u00028\u0005!1\u000f^8q\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0002\u000e\u0006]\u0005CBAH\u0003'\u000bI\"\u0004\u0002\u0002\u0012*\u00111k`\u0005\u0005\u0003+\u000b\tJ\u0001\u0004GkR,(/\u001a\u0005\b\u00033C\u0002\u0019AAN\u0003m\u0011Xm]8ve\u000e,\u0007K]8gS2,Gk\u001c+pi\u0006dW\t_3dgBA\u00111IAO\u0003K\ti!\u0003\u0003\u0002 \u0006U#aA'ba\u0006i2/\u001e4gS\u000eLWM\u001c;SKN|WO]2fgJ+w-[:uKJ,G\r\u0006\u0002\u0002\u001a\u0005qq-\u001a;Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cHCAAU!\u0019\tY+!.\u0002B9!\u0011QVAY\u001d\u0011\t9%a,\n\u0005\u0005\u0005\u0011bAAZ\u007f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\\\u0003s\u00131aU3r\u0015\r\t\u0019l`\u0001\u0010I>\\\u0015\u000e\u001c7Fq\u0016\u001cW\u000f^8sgR!\u0011QRA`\u0011\u001d\t\tm\u0007a\u0001\u0003S\u000b1\"\u001a=fGV$xN]%eg\u0006!2M]3bi\u0016$%/\u001b<fe\u0016sG\r]8j]R$\"!a2\u0011\t\u0005%\u00171Z\u0007\u0002\u0001%\u0019\u0011Q\u001a\u001c\u0003\u001d\u0011\u0013\u0018N^3s\u000b:$\u0007o\\5oi\u0006\u00112M]3bi\u0016$vn[3o\u001b\u0006t\u0017mZ3s)\t\t\u0019\u000eE\u0003\u007f\u0003W\n)\u000e\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\u0011M,7-\u001e:jifT1!a8.\u0003\u0019!W\r\u001d7ps&!\u00111]Am\u0005qA\u0015\rZ8pa\u0012+G.Z4bi&|g\u000eV8lK:l\u0015M\\1hKJ\f!#[:Fq\u0016\u001cW\u000f^8s\u000bb\u001cG.\u001e3fIR1\u0011\u0011DAu\u0003WDq!a\u0010\u001f\u0001\u0004\t\t\u0005C\u0004\u0002nz\u0001\r!!\u0011\u0002\u0011!|7\u000f\u001e8b[\u0016\u0014\u0001dS;cKJtW\r^3t\tJLg/\u001a:F]\u0012\u0004x.\u001b8u'\ry\u0012q\u0019\u000b\u0003\u0003k\u00042!!3 \u0003\u0019JwM\\8sKJ+w-[:uKJ,\u00050Z2vi>\u0014\u0018\t^*u_B\u0004X\rZ\"p]R,\u0007\u0010^\u000b\u0003\u0003w\u0004rA`A\u007f\u0005\u0003\t9$C\u0002\u0002\u0000~\u0014q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0004}\n\r\u0011b\u0001B\u0003\u007f\n\u0019\u0011I\\=\u0002\u001fI,7-Z5wK\u0006sGMU3qYf$B!a?\u0003\f!9!Q\u0002\u0012A\u0002\t=\u0011aB2p]R,\u0007\u0010\u001e\t\u0005\u0005#\u00119\"\u0004\u0002\u0003\u0014)\u0019!QC\u0017\u0002\u0007I\u00048-\u0003\u0003\u0003\u001a\tM!A\u0004*qG\u000e\u000bG\u000e\\\"p]R,\u0007\u0010^\u0001\u000f_:$\u0015n]2p]:,7\r^3e)\u0011\t9Da\b\t\u000f\t\u00052\u00051\u0001\u0003$\u0005Q!\u000f]2BI\u0012\u0014Xm]:\u0011\t\tE!QE\u0005\u0005\u0005O\u0011\u0019B\u0001\u0006Sa\u000e\fE\r\u001a:fgN\f1c];qKJ$\u0013\r\u001d9mS\u000e\fG/[8o\u0013\u0012LA!a \u0003.%\u0019!qF\u0016\u0003!M\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017AC:va\u0016\u0014He\u001d;pa&\u0019\u0011q\u0011\u001c")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    private final ScheduledExecutorService executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteExecutors;
    private final ResourceProfile defaultProfile;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        block0: {
            if (!this.isExecutorActive(executorId)) break block0;
            this.removeExecutor(executorId, reason);
        }
    }

    private void setUpExecutorConfigMap(Option<Pod> driverPod) {
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf(), (Map<String, String>)Predef$.MODULE$.Map().empty());
        Map labels = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.applicationId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, confFilesMap, (Map<String, String>)labels);
        KubernetesUtils$.MODULE$.addOwnerReference((Pod)driverPod.orNull(Predef$.MODULE$.$conforms()), (Seq<HasMetadata>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigMap[]{configMap}))));
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().create((Object)configMap);
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        super.start();
        Map initExecs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()))}));
        this.podAllocator.setTotalExpectedExecutors((Map<ResourceProfile, Object>)initExecs);
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId(), this);
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
        this.setUpExecutorConfigMap(this.podAllocator.driverPod());
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteExecutors()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        this.podAllocator.setTotalExpectedExecutors(resourceProfileToTotalExecs);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (((PodList)running.list()).getItems().isEmpty()) break block0;
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$2(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isExecutorExcluded(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.defaultProfile = scheduler.sc().resourceProfileManager().defaultResourceProfile();
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        private PartialFunction<Object, BoxedUnit> ignoreRegisterExecutorAtStoppedContext() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped() ? BoxedUnit.UNIT : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped();
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return this.ignoreRegisterExecutorAtStoppedContext().orElse(super.receiveAndReply(context));
        }

        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

