/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh!B\u0012%\u0001)\u0002\u0004\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011i\u0002!\u0011!Q\u0001\nmB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011!\u0004!\u0011!Q\u0001\n%DQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001f\u0001C\u0002\u0013E\u0013\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002>\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001\u0002CA\u0007\u0001\u0001\u0006I!a\u0002\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA\u0016\u0001\u0001\u0006I!a\b\t\u0011\u00055\u0002\u0001\"\u0001%\u0003_Aq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002^!9\u0011Q\r\u0001\u0005B\u0005u\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!!'\u0001\t\u0003\nY\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u00055\u0006\u0001\"\u0015\u00020\"9\u0011q\u0019\u0001\u0005R\u0005%gABAi\u0001\u0011\t\u0019\u000e\u0003\u0004m?\u0011\u0005\u0011Q\u001b\u0005\b\u00033|B\u0011IAn\u00119\ti\u000f\u0001I\u0001\u0004\u0003\u0005I\u0011BA1\u0003_\u0014\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!!\n\u0014\u0002\u0007-D4O\u0003\u0002(Q\u000591\r\\;ti\u0016\u0014(BA\u0015+\u0003%\u00198\r[3ek2,'O\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h'\t\u0001\u0011\u0007\u0005\u00023g5\ta%\u0003\u00025M\ti2i\\1sg\u0016<%/Y5oK\u0012\u001c6\r[3ek2,'OQ1dW\u0016tGm\u0001\u0001\u0011\u0005]BT\"\u0001\u0015\n\u0005eB#!\u0005+bg.\u001c6\r[3ek2,'/S7qY\u0006\u00111o\u0019\t\u0003yuj\u0011AK\u0005\u0003})\u0012Ab\u00159be.\u001cuN\u001c;fqR\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005\u0005SU\"\u0001\"\u000b\u0005\r#\u0015AB2mS\u0016tGO\u0003\u0002F\r\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005\u001dC\u0015a\u00024bEJL7\r\u000f\u0006\u0002\u0013\u0006\u0011\u0011n\\\u0005\u0003\u0017\n\u0013\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u001f\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\"AT+\u000e\u0003=S!\u0001U)\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002S'\u0006!Q\u000f^5m\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV(\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0001\bt]\u0006\u00048\u000f[8ugN#xN]3\u0011\u0005eSV\"\u0001\u0013\n\u0005m##AG#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|Go]*u_J,\u0017\u0001\u00049pI\u0006cGn\\2bi>\u0014\bCA-_\u0013\tyFEA\u000bFq\u0016\u001cW\u000f^8s!>$7/\u00117m_\u000e\fGo\u001c:\u0002+1Lg-Z2zG2,WI^3oi\"\u000bg\u000e\u001a7feB\u0011\u0011LY\u0005\u0003G\u0012\u0012A$\u0012=fGV$xN\u001d)pINd\u0015NZ3ds\u000edW-T1oC\u001e,'/A\u0006xCR\u001c\u0007.\u0012<f]R\u001c\bCA-g\u0013\t9GEA\u0010Fq\u0016\u001cW\u000f^8s!>$7oV1uG\"\u001cf.\u00199tQ>$8k\\;sG\u0016\f!\u0002]8mY\u00163XM\u001c;t!\tI&.\u0003\u0002lI\t\tS\t_3dkR|'\u000fU8egB{G\u000e\\5oONs\u0017\r]:i_R\u001cv.\u001e:dK\u00061A(\u001b8jiz\"\"B\\8qcJ\u001cH/\u001e<x!\tI\u0006\u0001C\u0003*\u0015\u0001\u0007a\u0007C\u0003;\u0015\u0001\u00071\bC\u0003@\u0015\u0001\u0007\u0001\tC\u0003M\u0015\u0001\u0007Q\nC\u0003X\u0015\u0001\u0007\u0001\fC\u0003]\u0015\u0001\u0007Q\fC\u0003a\u0015\u0001\u0007\u0011\rC\u0003e\u0015\u0001\u0007Q\rC\u0003i\u0015\u0001\u0007\u0011.\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|W#\u0001>\u0011\u0005mtX\"\u0001?\u000b\u0003u\fQa]2bY\u0006L!a ?\u0003\r\u0011{WO\u00197f\u0003Mi\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8!\u0003AIg.\u001b;jC2,\u00050Z2vi>\u00148/\u0006\u0002\u0002\bA\u001910!\u0003\n\u0007\u0005-APA\u0002J]R\f\u0011#\u001b8ji&\fG.\u0012=fGV$xN]:!\u0003U\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN,\"!a\u0005\u0011\u0007m\f)\"C\u0002\u0002\u0018q\u0014qAQ8pY\u0016\fg.\u0001\ftQ>,H\u000e\u001a#fY\u0016$X-\u0012=fGV$xN]:!\u00039!WMZ1vYR\u0004&o\u001c4jY\u0016,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n+\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA\u0015\u0003G\u0011qBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u0010I\u00164\u0017-\u001e7u!J|g-\u001b7fA\u0005\u0001Bm\u001c*f[>4X-\u0012=fGV$xN\u001d\u000b\u0007\u0003c\t9$!\u0015\u0011\u0007m\f\u0019$C\u0002\u00026q\u0014A!\u00168ji\"9\u0011\u0011H\nA\u0002\u0005m\u0012AC3yK\u000e,Ho\u001c:JIB!\u0011QHA&\u001d\u0011\ty$a\u0012\u0011\u0007\u0005\u0005C0\u0004\u0002\u0002D)\u0019\u0011QI\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\tI\u0005`\u0001\u0007!J,G-\u001a4\n\t\u00055\u0013q\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%C\u0010C\u0004\u0002TM\u0001\r!!\u0016\u0002\rI,\u0017m]8o!\r9\u0014qK\u0005\u0004\u00033B#AE#yK\u000e,Ho\u001c:M_N\u001c(+Z1t_:\fac]3u+B,\u00050Z2vi>\u00148i\u001c8gS\u001el\u0015\r\u001d\u000b\u0003\u0003c\tQ\"\u00199qY&\u001c\u0017\r^5p]&#GCAA\u001e\u0003\u0015\u0019H/\u0019:u\u0003\u0011\u0019Ho\u001c9\u0002/\u0011|'+Z9vKN$Hk\u001c;bY\u0016CXmY;u_J\u001cH\u0003BA6\u0003k\u0002b!!\u001c\u0002r\u0005MQBAA8\u0015\t\u0001F0\u0003\u0003\u0002t\u0005=$A\u0002$viV\u0014X\rC\u0004\u0002xa\u0001\r!!\u001f\u00027I,7o\\;sG\u0016\u0004&o\u001c4jY\u0016$v\u000eV8uC2,\u00050Z2t!!\ti$a\u001f\u0002 \u0005\u001d\u0011\u0002BA?\u0003\u001f\u00121!T1q\u0003u\u0019XO\u001a4jG&,g\u000e\u001e*fg>,(oY3t%\u0016<\u0017n\u001d;fe\u0016$GCAA\n\u000399W\r^#yK\u000e,Ho\u001c:JIN$\"!a\"\u0011\r\u0005%\u00151SA\u001e\u001d\u0011\tY)a$\u000f\t\u0005\u0005\u0013QR\u0005\u0002{&\u0019\u0011\u0011\u0013?\u0002\u000fA\f7m[1hK&!\u0011QSAL\u0005\r\u0019V-\u001d\u0006\u0004\u0003#c\u0018a\u00043p\u0017&dG.\u0012=fGV$xN]:\u0015\t\u0005-\u0014Q\u0014\u0005\b\u0003?[\u0002\u0019AAD\u0003-)\u00070Z2vi>\u0014\u0018\nZ:\u0002)\r\u0014X-\u0019;f\tJLg/\u001a:F]\u0012\u0004x.\u001b8u)\t\t)\u000b\u0005\u0003\u0002(\u0006%V\"\u0001\u0001\n\u0007\u0005-6G\u0001\bEe&4XM]#oIB|\u0017N\u001c;\u0002%\r\u0014X-\u0019;f)>\\WM\\'b]\u0006<WM\u001d\u000b\u0003\u0003c\u0003Ra_AZ\u0003oK1!!.}\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0007\u0005\u0005'&\u0001\u0004eKBdw._\u0005\u0005\u0003\u000b\fYL\u0001\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u0002%%\u001cX\t_3dkR|'/\u0012=dYV$W\r\u001a\u000b\u0007\u0003'\tY-!4\t\u000f\u0005eb\u00041\u0001\u0002<!9\u0011q\u001a\u0010A\u0002\u0005m\u0012\u0001\u00035pgRt\u0017-\\3\u00031-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u0014XI\u001c3q_&tGoE\u0002 \u0003K#\"!a6\u0011\u0007\u0005\u001dv$\u0001\bp]\u0012K7oY8o]\u0016\u001cG/\u001a3\u0015\t\u0005E\u0012Q\u001c\u0005\b\u0003?\f\u0003\u0019AAq\u0003)\u0011\boY!eIJ,7o\u001d\t\u0005\u0003G\fI/\u0004\u0002\u0002f*\u0019\u0011q\u001d\u0016\u0002\u0007I\u00048-\u0003\u0003\u0002l\u0006\u0015(A\u0003*qG\u0006#GM]3tg\u0006\u00192/\u001e9fe\u0012\n\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI&!\u0011qLAy\u0013\r\t\u0019\u0010\u000b\u0002\u0011'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u0004")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final SparkContext sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    private final ScheduledExecutorService executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteExecutors;
    private final ResourceProfile defaultProfile;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        block0: {
            if (!this.isExecutorActive(executorId)) break block0;
            this.removeExecutor(executorId, reason);
        }
    }

    private void setUpExecutorConfigMap() {
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf(), (Map<String, String>)Predef$.MODULE$.Map().empty());
        Map labels = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.applicationId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, confFilesMap, (Map<String, String>)labels);
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().create((Object)configMap);
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        super.start();
        Map initExecs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()))}));
        this.podAllocator.setTotalExpectedExecutors((Map<ResourceProfile, Object>)initExecs);
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId());
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
        this.setUpExecutorConfigMap();
    }

    public void stop() {
        super.stop();
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteExecutors()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        this.podAllocator.setTotalExpectedExecutors(resourceProfileToTotalExecs);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (((PodList)running.list()).getItems().isEmpty()) break block0;
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$2(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isExecutorExcluded(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.defaultProfile = scheduler.sc().resourceProfileManager().defaultResourceProfile();
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

