/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Patchable;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!\u0002\r\u001a\u0001})\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\t\u0011e\u0002!\u0011!Q\u0001\nUB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"AA\n\u0001B\u0001B\u0003%Q\nC\u0003b\u0001\u0011\u0005!\r\u0003\u0005i\u0001!\u0015\r\u0011\"\u0003j\u0011\u001di\u0007A1A\u0005\n9Da!\u001f\u0001!\u0002\u0013y\u0007\"\u0002>\u0001\t\u0003Y\bbBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAS\u0001\u0011%\u0011qU\u0004\b\u0003[K\u0002\u0012BAX\r\u0019A\u0012\u0004#\u0003\u00022\"1\u0011\r\u0006C\u0001\u0003gC\u0011\"!.\u0015\u0005\u0004%\t!a.\t\u0011\u0005eF\u0003)A\u0005\u00033\u0013A$\u0012=fGV$xN\u001d)pINd\u0015NZ3ds\u000edW-T1oC\u001e,'O\u0003\u0002\u001b7\u0005\u00191\u000eO:\u000b\u0005qi\u0012aB2mkN$XM\u001d\u0006\u0003=}\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c2\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011Q\u0006M\u0007\u0002])\u0011qfH\u0001\tS:$XM\u001d8bY&\u0011\u0011G\f\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001U\tQ\u0007\u0005\u00027o5\tq$\u0003\u00029?\tI1\u000b]1sW\u000e{gNZ\u0001\u0006G>tg\rI\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\"\u0001P#\u000e\u0003uR!AP \u0002\r\rd\u0017.\u001a8u\u0015\t\u0001\u0015)\u0001\u0006lk\n,'O\\3uKNT!AQ\"\u0002\u000f\u0019\f'M]5dq)\tA)\u0001\u0002j_&\u0011a)\u0010\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\fab\u001d8baNDw\u000e^:Ti>\u0014X\r\u0005\u0002J\u00156\t\u0011$\u0003\u0002L3\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006)\"/Z7pm\u0016$W\t_3dkR|'o]\"bG\",\u0007\u0003\u0002(X3fk\u0011a\u0014\u0006\u0003!F\u000bQaY1dQ\u0016T!AU*\u0002\r\r|W.\\8o\u0015\t!V+\u0001\u0004h_><G.\u001a\u0006\u0002-\u0006\u00191m\\7\n\u0005a{%!B\"bG\",\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0006G\u0012,gm\u001a\t\u0003\u0013\u0002AQA\r\u0004A\u0002UBQA\u000f\u0004A\u0002mBQa\u0012\u0004A\u0002!CQ\u0001\u0014\u0004A\u00025\u000bQc\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148/F\u0001k!\t93.\u0003\u0002mQ\t9!i\\8mK\u0006t\u0017aD5oC\u000e$\u0018N^1uK\u0012\u0004v\u000eZ:\u0016\u0003=\u00042\u0001];x\u001b\u0005\t(B\u0001:t\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001e\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002wc\n9\u0001*Y:i'\u0016$\bCA\u0014y\u0013\t\u0001\u0007&\u0001\tj]\u0006\u001cG/\u001b<bi\u0016$\u0007k\u001c3tA\u0005)1\u000f^1siR\u0011Ap \t\u0003OuL!A \u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0003Q\u0001\u0019AA\u0002\u0003A\u00198\r[3ek2,'OQ1dW\u0016tG\rE\u0002J\u0003\u000bI1!a\u0002\u001a\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u00039ygNT3x':\f\u0007o\u001d5piN$R\u0001`A\u0007\u0003\u001fAq!!\u0001\f\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0012-\u0001\r!a\u0005\u0002\u0013Mt\u0017\r]:i_R\u001c\bCBA\u000b\u0003K\tYC\u0004\u0003\u0002\u0018\u0005\u0005b\u0002BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u1'\u0001\u0004=e>|GOP\u0005\u0002S%\u0019\u00111\u0005\u0015\u0002\u000fA\f7m[1hK&!\u0011qEA\u0015\u0005\r\u0019V-\u001d\u0006\u0004\u0003GA\u0003cA%\u0002.%\u0019\u0011qF\r\u0003)\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8u\u0003YygNR5oC2tuN\u001c#fY\u0016$X\rZ*uCR,G#\u00036\u00026\u0005}\u00121IA#\u0011\u001d\t9\u0004\u0004a\u0001\u0003s\t\u0001\u0002]8e'R\fG/\u001a\t\u0004\u0013\u0006m\u0012bAA\u001f3\tia)\u001b8bYB{Gm\u0015;bi\u0016Da!!\u0011\r\u0001\u00049\u0018AB3yK\u000eLE\rC\u0004\u0002\u00021\u0001\r!a\u0001\t\r\u0005\u001dC\u00021\u0001k\u00035!W\r\\3uK\u001a\u0013x.\\&9g\u0006)\"/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n\u0017b\u001aH#\u0002?\u0002N\u0005=\u0003BBA!\u001b\u0001\u0007q\u000fC\u0004\u0002R5\u0001\r!a\u0015\u0002\u0015U\u0004H-\u0019;fIB{G\r\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u000b5|G-\u001a7\u000b\u0007\u0005us(A\u0002ba&LA!!\u0019\u0002X\t\u0019\u0001k\u001c3\u0002/I,Wn\u001c<f\u000bb,7-\u001e;pe\u001a\u0013x.\\*qCJ\\Gc\u00026\u0002h\u0005%\u00141\u000e\u0005\b\u0003\u0003q\u0001\u0019AA\u0002\u0011\u001d\t9D\u0004a\u0001\u0003sAa!!\u0011\u000f\u0001\u00049\u0018A\u00044j]\u0012,\u00050\u001b;SK\u0006\u001cxN\u001c\u000b\u0007\u0003c\nI(a\u001f\u0011\t\u0005M\u0014QO\u0007\u0002;%\u0019\u0011qO\u000f\u0003\u001d\u0015CXmY;u_J,\u00050\u001b;fI\"9\u0011qG\bA\u0002\u0005e\u0002BBA!\u001f\u0001\u0007q/A\tfq&$(+Z1t_:lUm]:bO\u0016$\u0002\"!!\u0002\u0012\u0006M\u0015Q\u0013\t\u0005\u0003\u0007\u000bYI\u0004\u0003\u0002\u0006\u0006\u001d\u0005cAA\rQ%\u0019\u0011\u0011\u0012\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\ti)a$\u0003\rM#(/\u001b8h\u0015\r\tI\t\u000b\u0005\b\u0003o\u0001\u0002\u0019AA\u001d\u0011\u0019\t\t\u0005\u0005a\u0001o\"9\u0011q\u0013\tA\u0002\u0005e\u0015\u0001C3ySR\u001cu\u000eZ3\u0011\u0007\u001d\nY*C\u0002\u0002\u001e\"\u00121!\u00138u\u000311\u0017N\u001c3Fq&$8i\u001c3f)\u0011\tI*a)\t\u000f\u0005]\u0012\u00031\u0001\u0002:\u0005i\u0011n\u001d)pI&s\u0017m\u0019;jm\u0016$2A[AU\u0011\u001d\tYK\u0005a\u0001\u0003'\n1\u0001]8e\u0003q)\u00050Z2vi>\u0014\bk\u001c3t\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u0004\"!\u0013\u000b\u0014\u0005Q1CCAAX\u0003E)fj\u0013(P/:{V\tW%U?\u000e{E)R\u000b\u0003\u00033\u000b!#\u0016(L\u001d>;fjX#Y\u0013R{6i\u0014#FA\u0001")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Cache<Long, Long> removedExecutorsCache;
    private final HashSet<Object> inactivatedPods;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if (!this.bitmap$0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = true;
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return !this.bitmap$0 ? this.shouldDeleteExecutors$lzycompute() : this.shouldDeleteExecutors;
    }

    private HashSet<Object> inactivatedPods() {
        return this.inactivatedPods;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        long eventProcessingInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
        this.snapshotsStore.addSubscriber(eventProcessingInterval, (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        block1: {
            HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
            snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
                return BoxedUnit.UNIT;
            });
            if (this.inactivatedPods().nonEmpty() && snapshots.nonEmpty()) {
                this.inactivatedPods().retain((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> ((ExecutorPodsSnapshot)snapshots.last()).executorPods().contains((Object)BoxesRunTime.boxToLong((long)x$2)));
            }
            Nil$ lostExecutors = snapshots.nonEmpty() ? (Iterable)((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$8(x$3)), Seq$.MODULE$.canBuildFrom())).toSet().$minus$minus((GenTraversableOnce)((ExecutorPodsSnapshot)snapshots.last()).executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound) : Nil$.MODULE$;
            lostExecutors.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)lostId -> {
                block0: {
                    if ($this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)lostId)) != null) break block0;
                    String exitReasonMessage = new StringBuilder(191).append("The executor with ID ").append(lostId).append(" was not found in the").append(" cluster but we didn't get a reason why. Marking the executor as failed. The").append(" executor may have been deleted but the driver missed the deletion event.").toString();
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
                    ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
                    schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)lostId)).toString(), (ExecutorLossReason)exitReason);
                }
            });
            if (!lostExecutors.nonEmpty()) break block1;
            this.logDebug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$11((Iterable)lostExecutors)));
        }
    }

    private boolean onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, boolean deleteFromK8s) {
        boolean deleted;
        block0: {
            deleted = this.removeExecutorFromSpark(schedulerBackend, podState, execId);
            if (!deleteFromK8s) break block0;
            this.removeExecutorFromK8s(execId, podState.pod());
        }
        return deleted;
    }

    private void removeExecutorFromK8s(long execId, Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                block0: {
                    if (!this.shouldDeleteExecutors()) break block0;
                    ((Deletable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).delete();
                    break block1;
                }
                if (this.inactivatedPods().contains((Object)BoxesRunTime.boxToLong((long)execId)) || this.isPodInactive(updatedPod)) break block1;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Marking executor ").append(updatedPod.getMetadata().getName()).append(" as inactive since ").append("deletion is disabled.").toString());
                Pod inactivatedPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(updatedPod).editMetadata().addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL()), (Object)"true")}))).asJava())).endMetadata()).build();
                ((Patchable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).patch((Object)inactivatedPod);
                this.inactivatedPods().$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
            }
        });
    }

    private boolean removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        boolean bl;
        if (this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) == null) {
            this.removedExecutorsCache.put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)execId)).toString(), (ExecutorLossReason)exitReason);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean exitCausedByApp = tuple22._1$mcZ$sp();
        String exitMessage = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        Tuple2 tuple24 = tuple23;
        boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
        String exitMessage2 = (String)tuple24._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n       |The executor with id ").append(execId).append(" exited with exit code ").append(exitCode).append(".\n       |The API gave the following brief reason: ").append(reason.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following message: ").append(message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    private boolean isPodInactive(Pod pod) {
        Object v = pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL());
        String string = "true";
        return !(v != null ? !v.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HashSet hashSet;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if ($this.isPodInactive(executorPodState.pod())) {
                    hashSet = $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    if ($this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    }
                    hashSet = $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodFailed) {
                    BoxedUnit boxedUnit;
                    boolean deleteFromK8s;
                    PodFailed podFailed = (PodFailed)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Snapshot reported failed executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    hashSet = boxedUnit;
                } else if (executorPodState instanceof PodSucceeded) {
                    BoxedUnit boxedUnit;
                    boolean deleteFromK8s;
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        if (schedulerBackend$2.isExecutorActive(((Object)BoxesRunTime.boxToLong((long)execId)).toString())) {
                            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Snapshot reported succeeded executor with id ").append(execId).append(", ").append("even though the application has not requested for it to be removed.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).append(".").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    hashSet = boxedUnit;
                } else {
                    hashSet = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        });
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$8(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$11(Iterable lostExecutors$1) {
        return new StringBuilder(107).append("Removed executors with ids ").append(lostExecutors$1.mkString(",")).append(" from Spark that were either found to be deleted or non-existent in the cluster.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Cache<Long, Long> removedExecutorsCache) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.removedExecutorsCache = removedExecutorsCache;
        Logging.$init$((Logging)this);
        this.inactivatedPods = HashSet$.MODULE$.empty();
    }
}

