/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd!\u0002\u00192\u0001]j\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t3\u0002\u0011\t\u0011)A\u00055\"Aa\r\u0001B\u0001B\u0003%q\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001dQ\bA1A\u0005\nmDq!a\u0004\u0001A\u0003%A\u0010C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111\u0005\u0001!\u0002\u0013\t)\u0002C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011Q\t\u0001!\u0002\u0013\tI\u0003C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J!A\u00111\n\u0001!\u0002\u0013\ti\u0002C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002P!A\u0011q\u000b\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002P!A\u00111\f\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002P!A\u0011q\f\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d!A\u00111\u0010\u0001!\u0002\u0013\t)\u0007C\u0005\u0002~\u0001\u0011\r\u0011\"\u0003\u0002\u0000!A\u0011q\u0011\u0001!\u0002\u0013\t\t\tC\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u00111\u0013\u0001!\u0002\u0013\ti\tC\u0005\u0002\u0016\u0002\u0011\r\u0011\"\u0003\u0002\u0018\"A\u00111\u0016\u0001!\u0002\u0013\tI\nC\u0005\u0002.\u0002\u0011\r\u0011\"\u0003\u00020\"A\u0011Q\u0018\u0001!\u0002\u0013\t\t\fC\u0005\u0002@\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u0011\u0011\u0019\u0001!\u0002\u0013\ti\tC\u0005\u0002D\u0002\u0011\r\u0011\"\u0003\u0002F\"A\u0011Q\u001a\u0001!\u0002\u0013\t9\rC\u0005\u0002P\u0002\u0001\r\u0011\"\u0003\u0002R\"I\u0011\u0011\u001c\u0001A\u0002\u0013%\u00111\u001c\u0005\t\u0003O\u0004\u0001\u0015)\u0003\u0002T\"I\u0011\u0011\u001e\u0001A\u0002\u0013%\u00111\u001e\u0005\n\u0003s\u0004\u0001\u0019!C\u0005\u0003wD\u0001\"a@\u0001A\u0003&\u0011Q\u001e\u0005\b\u0005\u0013\u0001A\u0011\u0001B\u0006\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'AqAa\b\u0001\t\u0003\u0011\t\u0003C\u0004\u0003(\u0001!IA!\u000b\t\u000f\t\r\u0003\u0001\"\u0003\u0003F!9!Q\u000b\u0001\u0005\n\t]#!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN\u001d\u0006\u0003eM\n1a\u001b\u001dt\u0015\t!T'A\u0004dYV\u001cH/\u001a:\u000b\u0005Y:\u0014!C:dQ\u0016$W\u000f\\3s\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7c\u0001\u0001?\tB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u001c\u0002\u0011%tG/\u001a:oC2L!!\u0013$\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"!\u0014(\u000e\u0003]J!aT\u001c\u0003\u0013M\u0003\u0018M]6D_:4\u0017AB:fG6;'\u000f\u0005\u0002N%&\u00111k\u000e\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u0006yQ\r_3dkR|'OQ;jY\u0012,'\u000f\u0005\u0002W/6\t\u0011'\u0003\u0002Yc\tI2*\u001e2fe:,G/Z:Fq\u0016\u001cW\u000f^8s\u0005VLG\u000eZ3s\u0003AYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\u0005\u0002\\I6\tAL\u0003\u0002^=\u000611\r\\5f]RT!a\u00181\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002bE\u00069a-\u00192sS\u000eD$\"A2\u0002\u0005%|\u0017BA3]\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0001\bt]\u0006\u00048\u000f[8ugN#xN]3\u0011\u0005YC\u0017BA52\u0005i)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u0003\u0015\u0019Gn\\2l!\taw.D\u0001n\u0015\tqw'\u0001\u0003vi&d\u0017B\u00019n\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Q91\u000f^;wobL\bC\u0001,\u0001\u0011\u0015Qu\u00011\u0001M\u0011\u0015\u0001v\u00011\u0001R\u0011\u0015!v\u00011\u0001V\u0011\u0015Iv\u00011\u0001[\u0011\u00151w\u00011\u0001h\u0011\u0015Qw\u00011\u0001l\u0003M)\u0005,R\"V)>\u0013v,\u0013#`\u0007>+f\nV#S+\u0005a\bcA?\u0002\f5\taPC\u0002\u0000\u0003\u0003\ta!\u0019;p[&\u001c'\u0002BA\u0002\u0003\u000b\t!bY8oGV\u0014(/\u001a8u\u0015\rq\u0017q\u0001\u0006\u0003\u0003\u0013\tAA[1wC&\u0019\u0011Q\u0002@\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u000bF1\u0016\u001bU\u000bV(S?&#ulQ(V\u001dR+%\u000bI\u0001+i>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sgB+'OU3t_V\u00148-\u001a)s_\u001aLG.Z%e+\t\t)\u0002\u0005\u0005\u0002\u0018\u0005e\u0011QDA\u000f\u001b\t\t\t!\u0003\u0003\u0002\u001c\u0005\u0005!!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019q(a\b\n\u0007\u0005\u0005\u0002IA\u0002J]R\f1\u0006^8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o\u001d)feJ+7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE\rI\u0001\u0016eBLE\rV8SKN|WO]2f!J|g-\u001b7f+\t\tI\u0003\u0005\u0005\u0002,\u0005U\u0012QDA\u001d\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003g\u0001\u0015AC2pY2,7\r^5p]&!\u0011qGA\u0017\u0005\u001dA\u0015m\u001d5NCB\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007f9\u0014\u0001\u0003:fg>,(oY3\n\t\u0005\r\u0013Q\b\u0002\u0010%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK\u00061\"\u000f]%e)>\u0014Vm]8ve\u000e,\u0007K]8gS2,\u0007%A\tq_\u0012\fE\u000e\\8dCRLwN\\*ju\u0016,\"!!\b\u0002%A|G-\u00117m_\u000e\fG/[8o'&TX\rI\u0001\u0013a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u00170\u0006\u0002\u0002RA\u0019q(a\u0015\n\u0007\u0005U\u0003I\u0001\u0003M_:<\u0017a\u00059pI\u0006cGn\\2bi&|g\u000eR3mCf\u0004\u0013A\u00059pI\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\f1\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0002\n1#\u001a=fGV$xN]%eY\u0016$\u0016.\\3pkR\fA#\u001a=fGV$xN]%eY\u0016$\u0016.\\3pkR\u0004\u0013!\u00038b[\u0016\u001c\b/Y2f+\t\t)\u0007\u0005\u0003\u0002h\u0005Ud\u0002BA5\u0003c\u00022!a\u001bA\u001b\t\tiGC\u0002\u0002p-\u000ba\u0001\u0010:p_Rt\u0014bAA:\u0001\u00061\u0001K]3eK\u001aLA!a\u001e\u0002z\t11\u000b\u001e:j]\u001eT1!a\u001dA\u0003)q\u0017-\\3ta\u0006\u001cW\rI\u0001\u0018WV\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0004v\u000e\u001a(b[\u0016,\"!!!\u0011\u000b}\n\u0019)!\u001a\n\u0007\u0005\u0015\u0005I\u0001\u0004PaRLwN\\\u0001\u0019WV\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0004v\u000e\u001a(b[\u0016\u0004\u0013!F:i_VdG\rR3mKR,W\t_3dkR|'o]\u000b\u0003\u0003\u001b\u00032aPAH\u0013\r\t\t\n\u0011\u0002\b\u0005>|G.Z1o\u0003Y\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN\u0004\u0013!\u00033sSZ,'\u000fU8e+\t\tI\nE\u0003@\u0003\u0007\u000bY\n\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\u000b5|G-\u001a7\u000b\u0007\u0005\u0015f,A\u0002ba&LA!!+\u0002 \n\u0019\u0001k\u001c3\u0002\u0015\u0011\u0014\u0018N^3s!>$\u0007%A\u000boK^d\u0017p\u0011:fCR,G-\u0012=fGV$xN]:\u0016\u0005\u0005E\u0006\u0003CA\u0016\u0003g\u000b\t&a.\n\t\u0005U\u0016Q\u0006\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u000f}\nI,!\b\u0002R%\u0019\u00111\u0018!\u0003\rQ+\b\u000f\\33\u0003YqWm\u001e7z\u0007J,\u0017\r^3e\u000bb,7-\u001e;peN\u0004\u0013\u0001\u00073z]\u0006l\u0017nY!mY>\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0006IB-\u001f8b[&\u001c\u0017\t\u001c7pG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3!\u00039A\u0017m\u001d)f]\u0012Lgn\u001a)pIN,\"!a2\u0011\u0007u\fI-C\u0002\u0002Lz\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017a\u00045bgB+g\u000eZ5oOB{Gm\u001d\u0011\u0002\u00191\f7\u000f^*oCB\u001c\bn\u001c;\u0016\u0005\u0005M\u0007c\u0001,\u0002V&\u0019\u0011q[\u0019\u0003)\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8u\u0003Aa\u0017m\u001d;T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000f\u0006\u0003\u0002^\u0006\r\bcA \u0002`&\u0019\u0011\u0011\u001d!\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003K,\u0013\u0011!a\u0001\u0003'\f1\u0001\u001f\u00132\u00035a\u0017m\u001d;T]\u0006\u00048\u000f[8uA\u0005\u0011B-\u001a7fi\u0016$W\t_3dkR|'/\u00133t+\t\ti\u000f\u0005\u0004\u0002p\u0006U\u0018\u0011K\u0007\u0003\u0003cTA!a=\u00022\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003o\f\tPA\u0002TKR\fa\u0003Z3mKR,G-\u0012=fGV$xN]%eg~#S-\u001d\u000b\u0005\u0003;\fi\u0010C\u0005\u0002f\"\n\t\u00111\u0001\u0002n\u0006\u0019B-\u001a7fi\u0016$W\t_3dkR|'/\u00133tA!\u001a\u0011Fa\u0001\u0011\u0007}\u0012)!C\u0002\u0003\b\u0001\u0013\u0001B^8mCRLG.Z\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003;\u0014i\u0001C\u0004\u0003\u0010)\u0002\r!!\u001a\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0003e\u0019X\r\u001e+pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0015\t\u0005u'Q\u0003\u0005\b\u0005/Y\u0003\u0019\u0001B\r\u0003m\u0011Xm]8ve\u000e,\u0007K]8gS2,Gk\u001c+pi\u0006dW\t_3dgBA\u0011q\rB\u000e\u0003s\ti\"\u0003\u0003\u0003\u001e\u0005e$aA'ba\u0006I\u0011n\u001d#fY\u0016$X\r\u001a\u000b\u0005\u0003\u001b\u0013\u0019\u0003C\u0004\u0003&1\u0002\r!!\u001a\u0002\u0015\u0015DXmY;u_JLE-\u0001\bp]:+wo\u00158baNDw\u000e^:\u0015\r\u0005u'1\u0006B\u0017\u0011\u001d\u0011y!\fa\u0001\u0003KBqAa\f.\u0001\u0004\u0011\t$A\u0005t]\u0006\u00048\u000f[8ugB1!1\u0007B\u001f\u0003'tAA!\u000e\u0003:9!\u00111\u000eB\u001c\u0013\u0005\t\u0015b\u0001B\u001e\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B \u0005\u0003\u00121aU3r\u0015\r\u0011Y\u0004Q\u0001\u0014e\u0016\fX/Z:u\u001d\u0016<X\t_3dkR|'o\u001d\u000b\u000b\u0003;\u00149Ea\u0013\u0003P\tE\u0003b\u0002B%]\u0001\u0007\u0011QD\u0001\tKb\u0004Xm\u0019;fI\"9!Q\n\u0018A\u0002\u0005u\u0011a\u0002:v]:Lgn\u001a\u0005\b\u0005\u001fq\u0003\u0019AA3\u0011\u001d\u0011\u0019F\fa\u0001\u0003;\t\u0011C]3t_V\u00148-\u001a)s_\u001aLG.Z%e\u0003YI7/\u0012=fGV$xN]%eY\u0016$\u0016.\\3e\u001fV$HCBAG\u00053\u0012\u0019\u0007C\u0004\u0003\\=\u0002\rA!\u0018\u0002\u000bM$\u0018\r^3\u0011\u0007Y\u0013y&C\u0002\u0003bE\u0012\u0001#\u0012=fGV$xN\u001d)pIN#\u0018\r^3\t\u000f\t\u0015t\u00061\u0001\u0002R\u0005Y1-\u001e:sK:$H+[7f\u0001")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicLong EXECUTOR_ID_COUNTER;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final boolean dynamicAllocationEnabled;
    private final AtomicBoolean hasPendingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private volatile Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicLong EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    private HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private Option<Pod> driverPod() {
        return this.driverPod;
    }

    private LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    private boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    private AtomicBoolean hasPendingPods() {
        return this.hasPendingPods;
    }

    private ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    private void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    private Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    private void deletedExecutorIds_$eq(Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    public void start(String applicationId) {
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        block0: {
            resourceProfileToTotalExecs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Set total expected execs to ").append(this.totalExpectedExecutorsPerResourceProfileId()).toString());
            if (this.hasPendingPods().get()) break block0;
            this.snapshotsStore.notifySubscribers();
        }
    }

    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(executorId)).toLong()));
    }

    private void onNewSnapshots(String applicationId, Seq<ExecutorPodsSnapshot> snapshots) {
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom()));
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long execId = tuple2._1$mcJ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            long timeCreated = tuple22._2$mcJ$sp();
            if (currentTime - timeCreated > this.podCreationTimeout()) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                return iterable;
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timedOut.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$6(BoxesRunTime.unboxToLong((Object)x$3)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (Set)((Set)_deletedExecutorIds.elem).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> existingExecs.contains((Object)BoxesRunTime.boxToLong((long)elem)));
        }
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq(this.lastSnapshot().executorPods()));
        } else {
            this.lastSnapshot().executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$8(rpIdToExecsAndPodState, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.totalExpectedExecutorsPerResourceProfileId()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ExecutorPodsAllocator.$anonfun$onNewSnapshots$10(this, rpIdToExecsAndPodState, currentTime, _deletedExecutorIds, applicationId, totalPendingCount, snapshots, x0$3);
            return BoxedUnit.UNIT;
        });
        this.deletedExecutorIds_$eq((Set<Object>)((Set)_deletedExecutorIds.elem));
        this.hasPendingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size() > 0);
    }

    private void requestNewExecutors(int expected, int running, String applicationId, int resourceProfileId) {
        int numExecutorsToAllocate = package$.MODULE$.min(expected - running, this.podAllocationSize());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes for ").append("ResourceProfile Id: ").append(resourceProfileId).append(", target: ").append(expected).append(" running: ").append(running).append(".").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            long newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
            KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, ((Object)BoxesRunTime.boxToLong((long)newExecutorId)).toString(), applicationId, this.driverPod(), resourceProfileId);
            KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
            SparkPod executorPod = resolvedExecutorSpec.pod();
            Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
            Pod createdExecutorPod = (Pod)$this.kubernetesClient.pods().create((Object)podWithAttachedContainer);
            try {
                Seq<HasMetadata> resources = resolvedExecutorSpec.executorKubernetesResources();
                KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                ((IterableLike)resources.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$3(x$5)))).foreach((Function1 & Serializable & scala.Serializable)resource -> {
                    PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Trying to create PersistentVolumeClaim ").append(pvc.getMetadata().getName()).append(" with ").append("StorageClass ").append(pvc.getSpec().getStorageClassName()).toString());
                    return (PersistentVolumeClaim)$this.kubernetesClient.persistentVolumeClaims().create((Object)pvc);
                });
                this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdExecutorPod});
                    throw e;
                }
                throw throwable;
            }
        });
    }

    private boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long startTime = Instant.parse(state.pod().getStatus().getStartTime()).toEpochMilli();
                if (currentTime - startTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception exception) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Cannot get startTime of pod ").append(state.pod()).toString());
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ResourceProfile rp = (ResourceProfile)tuple2._1();
        int numExecs = tuple2._2$mcI$sp();
        $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable & scala.Serializable)() -> rp);
        int n = BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        return n;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$6(long x$3) {
        return ((Object)BoxesRunTime.boxToLong((long)x$3)).toString();
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$8(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long execId = tuple2._1$mcJ$sp();
        ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
        int rpId = new StringOps(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()))).toInt();
        HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$12(ExecutorPodState x0$4) {
        ExecutorPodState executorPodState = x0$4;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$13(Tuple2 x0$5) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$5;
        boolean bl = tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$14(int rpId$1, Tuple2 x0$6) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$6;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        int waitingRpId = tuple2._1$mcI$sp();
        boolean bl = rpId$1 == waitingRpId;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$17(Tuple2 x0$7) {
        long id;
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = id = tuple2._1$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$18(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$8) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$8;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        long createTime = tuple2._2$mcJ$sp();
        boolean bl = currentTime$1 - createTime > $this.executorIdleTimeout();
        return bl;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$21(long x$4) {
        return ((Object)BoxesRunTime.boxToLong((long)x$4)).toString();
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$10(ExecutorPodsAllocator $this, HashMap rpIdToExecsAndPodState$1, long currentTime$1, ObjectRef _deletedExecutorIds$1, String applicationId$2, IntRef totalPendingCount$1, Seq snapshots$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int knownPodCount;
            int rpId = tuple2._1$mcI$sp();
            int targetNum = tuple2._2$mcI$sp();
            HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> HashMap$.MODULE$.empty());
            int currentRunningCount = podsForRpId.values().count((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$12(x0$4)));
            HashMap currentPendingExecutors = (HashMap)podsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$13(x0$5)));
            IntRef knownPendingCount = IntRef.create((int)currentPendingExecutors.size());
            LinkedHashMap newlyCreatedExecutorsForRpId = (LinkedHashMap)$this.newlyCreatedExecutors().filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$14(rpId, x0$6)));
            if (podsForRpId.nonEmpty()) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("ResourceProfile Id: ").append(rpId).append(" ").append("pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutors.size()).append(" pending. ").append(newlyCreatedExecutorsForRpId.size()).append(" unacknowledged.").toString());
            }
            if ((knownPodCount = currentRunningCount + currentPendingExecutors.size() + newlyCreatedExecutorsForRpId.size()) > targetNum) {
                int excess = knownPodCount - targetNum;
                scala.collection.mutable.Iterable knownPendingToDelete = (scala.collection.mutable.Iterable)((IterableLike)((TraversableLike)currentPendingExecutors.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)$this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime$1)))).map((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$17(x0$7)), Iterable$.MODULE$.canBuildFrom())).take(excess - newlyCreatedExecutorsForRpId.size());
                List toDelete = (List)((TraversableOnce)((MapLike)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$18($this, currentTime$1, x0$8)))).keys().take(excess)).toList().$plus$plus((GenTraversableOnce)knownPendingToDelete, List$.MODULE$.canBuildFrom());
                if (toDelete.nonEmpty()) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                    _deletedExecutorIds$1.elem = (Set)((Set)_deletedExecutorIds$1.elem).$plus$plus((GenTraversableOnce)toDelete);
                    Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId$2)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$21(BoxesRunTime.unboxToLong((Object)x$4)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                        $this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)toDelete);
                        knownPendingCount$1.elem -= knownPendingToDelete.size();
                    });
                }
            }
            if (newlyCreatedExecutorsForRpId.isEmpty() && knownPodCount < targetNum) {
                $this.requestNewExecutors(targetNum, knownPodCount, applicationId$2, rpId);
            }
            totalPendingCount$1.elem += knownPendingCount.elem;
            if ($this.log().isDebugEnabled() && snapshots$1.nonEmpty()) {
                int outstanding = knownPendingCount.elem + newlyCreatedExecutorsForRpId.size();
                if (currentRunningCount >= targetNum && !$this.dynamicAllocationEnabled()) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Current number of running executors for ResourceProfile Id ").append(rpId).append(" is ").append("equal to the number of requested executors. Not scaling up further.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (outstanding > 0) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Still waiting for ").append(outstanding).append(" executors for ResourceProfile ").append("Id ").append(rpId).append(" before requesting more.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$3(HasMetadata x$5) {
        String string = x$5.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append(this.kubernetesDriverPodName()).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.hasPendingPods = new AtomicBoolean();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply((Seq<Pod>)Nil$.MODULE$);
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

