/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\u000f\u001f\u0001\u0011R\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tCQ\u0001\u0013\u0001\u0005\u0002%Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004[\u0001\u0001\u0006Ia\u0014\u0005\b7\u0002\u0011\r\u0011\"\u0003O\u0011\u0019a\u0006\u0001)A\u0005\u001f\"9Q\f\u0001b\u0001\n\u0013q\u0006B\u00022\u0001A\u0003%q\fC\u0004d\u0001\t\u0007I\u0011\u00020\t\r\u0011\u0004\u0001\u0015!\u0003`\u0011\u001d)\u0007A1A\u0005\nyCaA\u001a\u0001!\u0002\u0013y\u0006\"B4\u0001\t\u0003B\u0007\"\u00028\u0001\t\u0003z\u0007\"B:\u0001\t\u0003\"x\u0001CA\r=!\u0005A%a\u0007\u0007\u000fuq\u0002\u0012\u0001\u0013\u0002\u001e!1\u0001J\u0005C\u0001\u0003?A\u0001\"!\t\u0013\u0005\u0004%\tA\u0014\u0005\b\u0003G\u0011\u0002\u0015!\u0003P\u0011!\t)C\u0005b\u0001\n\u0003q\u0005bBA\u0014%\u0001\u0006Ia\u0014\u0005\n\u0003S\u0011\"\u0019!C\u0001\u0003WA\u0001\"a\u000f\u0013A\u0003%\u0011Q\u0006\u0005\t\u0003{\u0011\"\u0019!C\u0001=\"9\u0011q\b\n!\u0002\u0013y\u0006\"CA!%E\u0005I\u0011AA\"\u0005a!%/\u001b<feN+'O^5dK\u001a+\u0017\r^;sKN#X\r\u001d\u0006\u0003?\u0001\n\u0001BZ3biV\u0014Xm\u001d\u0006\u0003C\t\n1a\u001b\u001dt\u0015\t\u0019C%\u0001\u0004eKBdw.\u001f\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sON!\u0001aK\u00196!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!gM\u0007\u0002=%\u0011AG\b\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0011\u0005YJT\"A\u001c\u000b\u0005a\"\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005i:$a\u0002'pO\u001eLgnZ\u0001\u000fWV\u0014WM\u001d8fi\u0016\u001c8i\u001c8g\u0007\u0001\u0001\"AP \u000e\u0003\u0001J!\u0001\u0011\u0011\u0003)-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u00148i\u001c8g\u0003\u0015\u0019Gn\\2l!\t\u0019e)D\u0001E\u0015\t)E%\u0001\u0003vi&d\u0017BA$E\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Q\u0019!j\u0013'\u0011\u0005I\u0002\u0001\"B\u001e\u0004\u0001\u0004i\u0004bB!\u0004!\u0003\u0005\rAQ\u0001\u0015aJ,g-\u001a:sK\u0012\u001cVM\u001d<jG\u0016t\u0015-\\3\u0016\u0003=\u0003\"\u0001U,\u000f\u0005E+\u0006C\u0001*.\u001b\u0005\u0019&B\u0001+=\u0003\u0019a$o\\8u}%\u0011a+L\u0001\u0007!J,G-\u001a4\n\u0005aK&AB*ue&twM\u0003\u0002W[\u0005)\u0002O]3gKJ\u0014X\rZ*feZL7-\u001a(b[\u0016\u0004\u0013a\u0005:fg>dg/\u001a3TKJ4\u0018nY3OC6,\u0017\u0001\u0006:fg>dg/\u001a3TKJ4\u0018nY3OC6,\u0007%\u0001\u0006ee&4XM\u001d)peR,\u0012a\u0018\t\u0003Y\u0001L!!Y\u0017\u0003\u0007%sG/A\u0006ee&4XM\u001d)peR\u0004\u0013A\u00063sSZ,'O\u00117pG.l\u0015M\\1hKJ\u0004vN\u001d;\u0002/\u0011\u0014\u0018N^3s\u00052|7m['b]\u0006<WM\u001d)peR\u0004\u0013\u0001\u00043sSZ,'/V%Q_J$\u0018!\u00043sSZ,'/V%Q_J$\b%\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0002jYB\u0011aH[\u0005\u0003W\u0002\u0012\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006[:\u0001\r![\u0001\u0004a>$\u0017\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\u0012\u0001\u001d\t\u0005!F|u*\u0003\u0002s3\n\u0019Q*\u00199\u0002A\u001d,G/\u00113eSRLwN\\1m\u0017V\u0014WM\u001d8fi\u0016\u001c(+Z:pkJ\u001cWm\u001d\u000b\u0002kB\u0019ao\u001f@\u000f\u0005]LhB\u0001*y\u0013\u0005q\u0013B\u0001>.\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001`?\u0003\u0007M+\u0017O\u0003\u0002{[A\u0019q0!\u0006\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tQ!\\8eK2TA!a\u0002\u0002\n\u0005\u0019\u0011\r]5\u000b\t\u0005-\u0011QB\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(\u0002BA\b\u0003#\tqAZ1ce&\u001c\u0007H\u0003\u0002\u0002\u0014\u0005\u0011\u0011n\\\u0005\u0005\u0003/\t\tAA\u0006ICNlU\r^1eCR\f\u0017\u0001\u0007#sSZ,'oU3sm&\u001cWMR3biV\u0014Xm\u0015;faB\u0011!GE\n\u0003%-\"\"!a\u0007\u0002/\u0011\u0013\u0016JV#S?\nKe\nR0B\t\u0012\u0013ViU*`\u0017\u0016K\u0016\u0001\u0007#S\u0013Z+%k\u0018\"J\u001d\u0012{\u0016\t\u0012#S\u000bN\u001bvlS#ZA\u0005yAIU%W\u000bJ{\u0006jT*U?.+\u0015,\u0001\tE%&3VIU0I\u001fN#vlS#ZA\u0005\u0011BIU%W\u000bJ{6KV\"`!>\u001bFKR%Y+\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0003o\tAA[1wC&\u0019\u0001,!\r\u0002'\u0011\u0013\u0016JV#S?N36i\u0018)P'R3\u0015\n\u0017\u0011\u0002/5\u000b\u0005lX*F%ZK5)R0O\u00036+u\fT#O\u000fRC\u0015\u0001G'B1~\u001bVI\u0015,J\u0007\u0016{f*Q'F?2+ej\u0012+IA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u0012+\u0007\t\u000b9e\u000b\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!C;oG\",7m[3e\u0015\r\t\u0019&L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DriverServiceFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesDriverConf kubernetesConf;
    private final String preferredServiceName;
    private final String resolvedServiceName;
    private final int driverPort;
    private final int driverBlockManagerPort;
    private final int driverUIPort;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$2() {
        return DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2();
    }

    public static int MAX_SERVICE_NAME_LENGTH() {
        return DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH();
    }

    public static String DRIVER_SVC_POSTFIX() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
    }

    public static String DRIVER_HOST_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY();
    }

    public static String DRIVER_BIND_ADDRESS_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String preferredServiceName() {
        return this.preferredServiceName;
    }

    private String resolvedServiceName() {
        return this.resolvedServiceName;
    }

    private int driverPort() {
        return this.driverPort;
    }

    private int driverBlockManagerPort() {
        return this.driverBlockManagerPort;
    }

    private int driverUIPort() {
        return this.driverUIPort;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        return pod;
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        String driverHostname = new StringBuilder(5).append(this.resolvedServiceName()).append(".").append(this.kubernetesConf.namespace()).append(".svc").toString();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()), (Object)driverHostname), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.DRIVER_PORT().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.driverPort())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.driverBlockManagerPort())).toString())}));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        Service driverService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent)((ServiceSpecFluent.PortsNested)((ServiceFluentImpl)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.resolvedServiceName()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.serviceAnnotations()).asJava())).endMetadata()).withNewSpec().withClusterIP("None").withSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.labels()).asJava()).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverPort())).withNewTargetPort(Predef$.MODULE$.int2Integer(this.driverPort()))).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverBlockManagerPort())).withNewTargetPort(Predef$.MODULE$.int2Integer(this.driverBlockManagerPort()))).endPort()).addNewPort().withName(Constants$.MODULE$.UI_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverUIPort())).withNewTargetPort(Predef$.MODULE$.int2Integer(this.driverUIPort()))).endPort()).endSpec()).build();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Service[]{driverService}));
    }

    public DriverServiceFeatureStep(KubernetesDriverConf kubernetesConf, Clock clock) {
        String string;
        this.kubernetesConf = kubernetesConf;
        KubernetesFeatureConfigStep.$init$(this);
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).append(" is not supported in Kubernetes mode, as the driver's bind ").append("address is managed and set to the driver pod's IP address.").toString());
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).append(" is not supported in Kubernetes mode, as the driver's hostname will be ").append("managed via a Kubernetes service.").toString());
        this.preferredServiceName = new StringBuilder(0).append(kubernetesConf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
        if (this.preferredServiceName().length() <= DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()) {
            string = this.preferredServiceName();
        } else {
            String randomServiceId = KubernetesUtils$.MODULE$.uniqueID(clock);
            String shorterServiceName = new StringBuilder(6).append("spark-").append(randomServiceId).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(137).append("Driver's hostname would preferably be ").append(this.preferredServiceName()).append(", but this is ").append("too long (must be <= ").append(DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()).append(" characters). Falling back to use ").append(shorterServiceName).append(" as the driver service's name.").toString());
            string = shorterServiceName;
        }
        this.resolvedServiceName = string;
        this.driverPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        this.driverBlockManagerPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        this.driverUIPort = BoxesRunTime.unboxToInt(kubernetesConf.get(UI$.MODULE$.UI_PORT()));
    }
}

