/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q4Q!\b\u0010\u0001I)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)\u0001\t\u0001C\u0001\u0003\"9Q\t\u0001b\u0001\n\u00131\u0005B\u0002*\u0001A\u0003%q\tC\u0004T\u0001\t\u0007I\u0011\u0002+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u001dI\u0006A1A\u0005\n\u0019CaA\u0017\u0001!\u0002\u00139\u0005bB.\u0001\u0005\u0004%IA\u0012\u0005\u00079\u0002\u0001\u000b\u0011B$\t\u000fu\u0003!\u0019!C\u0005=\"1!\r\u0001Q\u0001\n}Cqa\u0019\u0001C\u0002\u0013%a\t\u0003\u0004e\u0001\u0001\u0006Ia\u0012\u0005\bK\u0002\u0011\r\u0011\"\u0003_\u0011\u00191\u0007\u0001)A\u0005?\"9q\r\u0001b\u0001\n\u0013q\u0006B\u00025\u0001A\u0003%q\fC\u0004j\u0001\t\u0007I\u0011\u00020\t\r)\u0004\u0001\u0015!\u0003`\u0011\u001dY\u0007A1A\u0005\nQCa\u0001\u001c\u0001!\u0002\u0013)\u0006bB7\u0001\u0005\u0004%IA\u0012\u0005\u0007]\u0002\u0001\u000b\u0011B$\t\u000f=\u0004!\u0019!C\u0005a\"1A\u000f\u0001Q\u0001\nEDQ!\u001e\u0001\u0005BY\u0014\u0001DQ1tS\u000e,\u00050Z2vi>\u0014h)Z1ukJ,7\u000b^3q\u0015\ty\u0002%\u0001\u0005gK\u0006$XO]3t\u0015\t\t#%A\u0002lqMT!a\t\u0013\u0002\r\u0011,\u0007\u000f\\8z\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001a\u000e\u0003yI!\u0001\u000e\u0010\u00037-+(-\u001a:oKR,7OR3biV\u0014XmQ8oM&<7\u000b^3q\u00039YWOY3s]\u0016$Xm]\"p]\u001a\u001c\u0001\u0001\u0005\u00029s5\t\u0001%\u0003\u0002;A\t12*\u001e2fe:,G/Z:Fq\u0016\u001cW\u000f^8s\u0007>tg-\u0001\u0004tK\u000eluM\u001d\t\u0003{yj\u0011\u0001J\u0005\u0003\u007f\u0011\u0012qbU3dkJLG/_'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\u001bE\t\u0005\u00023\u0001!)Qg\u0001a\u0001o!)1h\u0001a\u0001y\u00051R\r_3dkR|'oQ8oi\u0006Lg.\u001a:J[\u0006<W-F\u0001H!\tAuJ\u0004\u0002J\u001bB\u0011!*L\u0007\u0002\u0017*\u0011AJN\u0001\u0007yI|w\u000e\u001e \n\u00059k\u0013A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT\u0017\u0002/\u0015DXmY;u_J\u001cuN\u001c;bS:,'/S7bO\u0016\u0004\u0013\u0001\u00052m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:u+\u0005)\u0006C\u0001\u0017W\u0013\t9VFA\u0002J]R\f\u0011C\u00197pG.l\u0015M\\1hKJ\u0004vN\u001d;!\u0003U)\u00070Z2vi>\u0014\bk\u001c3OC6,\u0007K]3gSb\fa#\u001a=fGV$xN\u001d)pI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\nIJLg/\u001a:Ve2\f!\u0002\u001a:jm\u0016\u0014XK\u001d7!\u0003E)\u00070Z2vi>\u0014X*Z7pefl\u0015NQ\u000b\u0002?B\u0011A\u0006Y\u0005\u0003C6\u0012A\u0001T8oO\u0006\u0011R\r_3dkR|'/T3n_JLX*\u001b\"!\u0003Q)\u00070Z2vi>\u0014X*Z7pef\u001cFO]5oO\u0006)R\r_3dkR|'/T3n_JL8\u000b\u001e:j]\u001e\u0004\u0013!E7f[>\u0014\u0018p\u0014<fe\",\u0017\rZ'j\u0005\u0006\u0011R.Z7pef|e/\u001a:iK\u0006$W*\u001b\"!\u0003i)\u00070Z2vi>\u0014X*Z7pef<\u0016\u000e\u001e5Pm\u0016\u0014\b.Z1e\u0003m)\u00070Z2vi>\u0014X*Z7pef<\u0016\u000e\u001e5Pm\u0016\u0014\b.Z1eA\u0005\u0019R\r_3dkR|'/T3n_JLHk\u001c;bY\u0006!R\r_3dkR|'/T3n_JLHk\u001c;bY\u0002\nQ\"\u001a=fGV$xN]\"pe\u0016\u001c\u0018AD3yK\u000e,Ho\u001c:D_J,7\u000fI\u0001\u0015Kb,7-\u001e;pe\u000e{'/Z:SKF,Xm\u001d;\u0002+\u0015DXmY;u_J\u001cuN]3t%\u0016\fX/Z:uA\u0005\u0011R\r_3dkR|'\u000fT5nSR\u001cuN]3t+\u0005\t\bc\u0001\u0017s\u000f&\u00111/\f\u0002\u0007\u001fB$\u0018n\u001c8\u0002'\u0015DXmY;u_Jd\u0015.\\5u\u0007>\u0014Xm\u001d\u0011\u0002\u0019\r|gNZ5hkJ,\u0007k\u001c3\u0015\u0005]T\bC\u0001\u001dy\u0013\tI\bE\u0001\u0005Ta\u0006\u00148\u000eU8e\u0011\u0015YH\u00041\u0001x\u0003\r\u0001x\u000e\u001a")
public class BasicExecutorFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesExecutorConf kubernetesConf;
    private final SecurityManager secMgr;
    private final String executorContainerImage;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final String driverUrl;
    private final long executorMemoryMiB;
    private final String executorMemoryString;
    private final long memoryOverheadMiB;
    private final long executorMemoryWithOverhead;
    private final long executorMemoryTotal;
    private final int executorCores;
    private final String executorCoresRequest;
    private final Option<String> executorLimitCores;

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    private String driverUrl() {
        return this.driverUrl;
    }

    private long executorMemoryMiB() {
        return this.executorMemoryMiB;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long executorMemoryWithOverhead() {
        return this.executorMemoryWithOverhead;
    }

    private long executorMemoryTotal() {
        return this.executorMemoryTotal;
    }

    private int executorCores() {
        return this.executorCores;
    }

    private String executorCoresRequest() {
        return this.executorCoresRequest;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    @Override
    public SparkPod configurePod(SparkPod pod2) {
        String name2 = new StringBuilder(6).append(this.executorPodNamePrefix()).append("-exec-").append(this.kubernetesConf.executorId()).toString();
        String hostname = name2.substring(Math.max(0, name2.length() - 63)).replaceAll("^[^\\w]+", "").replaceAll("[^\\w-]+", "_");
        Quantity executorMemoryQuantity = new Quantity(new StringBuilder(2).append(this.executorMemoryTotal()).append("Mi").toString());
        Quantity executorCpuQuantity = new Quantity(this.executorCoresRequest());
        scala.collection.immutable.Map<String, Quantity> executorResourceQuantities = KubernetesUtils$.MODULE$.buildResourcesQuantities(org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX(), this.kubernetesConf.sparkConf());
        Seq userOpts = (Seq)Option$.MODULE$.option2Iterable((Option)this.kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).toSeq().flatMap((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpts = Utils$.MODULE$.substituteAppNExecIds(opts, $this.kubernetesConf.appId(), $this.kubernetesConf.executorId());
            return Utils$.MODULE$.splitCommandString(subsOpts);
        }, Seq$.MODULE$.canBuildFrom());
        Seq sparkOpts = Utils$.MODULE$.sparkJavaOpts(this.kubernetesConf.sparkConf(), (Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        Seq executorEnv = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.ENV_DRIVER_URL(), (Object)this.driverUrl()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES(), (Object)((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY(), (Object)this.executorMemoryString()), new Tuple2((Object)Constants$.MODULE$.ENV_APPLICATION_ID(), (Object)this.kubernetesConf.appId()), new Tuple2((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR(), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_ID(), (Object)this.kubernetesConf.executorId())}))).$plus$plus(this.kubernetesConf.environment(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(k)).withValue(v)).build();
            return envVar;
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_EXECUTOR_POD_IP())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).build()})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)(((Option)this.kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.AUTH_SECRET_FILE_EXECUTOR())).isEmpty() ? Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.secMgr.getSecretKey()).map((Function1 & Serializable & scala.Serializable)authSecret -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(SecurityManager$.MODULE$.ENV_AUTH_SECRET())).withValue(authSecret)).build())) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$)), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(((Option)this.kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CLASS_PATH())).map((Function1 & Serializable & scala.Serializable)cp -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_CLASSPATH())).withValue(cp)).build())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)((IterableLike)userOpts.$plus$plus((GenTraversableOnce)sparkOpts, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String opt = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(index).toString())).withValue(opt)).build();
            return envVar;
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq requiredPorts = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort()))}))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
            return containerPort;
        }, Seq$.MODULE$.canBuildFrom());
        Container executorContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod2.container()).withName((String)Option$.MODULE$.apply((Object)pod2.container().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME()))).withImage(this.executorContainerImage())).withImagePullPolicy(this.kubernetesConf.imagePullPolicy())).editOrNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryQuantity).addToRequests("cpu", executorCpuQuantity).addToLimits((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executorResourceQuantities).asJava())).endResources()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_USER()).withValue(Utils$.MODULE$.getCurrentUserName())).endEnv()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(executorEnv).asJava())).withPorts((List)JavaConverters$.MODULE$.seqAsJavaListConverter(requiredPorts).asJava())).addToArgs(new String[]{"executor"})).build();
        Container containerWithLimitCores = (Container)this.executorLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> {
            Quantity executorCpuLimitQuantity = new Quantity(limitCores);
            return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(executorContainer).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> executorContainer);
        Option ownerReference = this.kubernetesConf.driverPod().map((Function1 & Serializable & scala.Serializable)pod -> ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withController(Predef$.MODULE$.boolean2Boolean(true))).withApiVersion(pod.getApiVersion())).withKind(pod.getKind())).withName(pod.getMetadata().getName())).withUid(pod.getMetadata().getUid())).build());
        Pod executorPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod2.pod()).editOrNewMetadata().withName(name2).addToLabels((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.labels()).asJava()).addToAnnotations((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.annotations()).asJava()).addToOwnerReferences((OwnerReference[])Option$.MODULE$.option2Iterable(ownerReference).toSeq().toArray(ClassTag$.MODULE$.apply(OwnerReference.class)))).endMetadata()).editOrNewSpec().withHostname(hostname).withRestartPolicy("Never").addToNodeSelector((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.kubernetesConf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        PodSpec podSpec = executorPod.getSpec();
        ((Option)this.kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_SCHEDULER_NAME())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            podSpec.setSchedulerName(x$1);
            return BoxedUnit.UNIT;
        });
        return new SparkPod(executorPod, containerWithLimitCores);
    }

    public BasicExecutorFeatureStep(KubernetesExecutorConf kubernetesConf, SecurityManager secMgr) {
        this.kubernetesConf = kubernetesConf;
        this.secMgr = secMgr;
        KubernetesFeatureConfigStep.$init$(this);
        this.executorContainerImage = (String)kubernetesConf.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the executor container image");
        });
        this.blockManagerPort = kubernetesConf.sparkConf().getInt("spark.blockmanager.port", Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        this.executorPodNamePrefix = kubernetesConf.resourceNamePrefix();
        this.driverUrl = RpcEndpointAddress$.MODULE$.apply((String)kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS()), kubernetesConf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.executorMemoryMiB = BoxesRunTime.unboxToLong(kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        this.executorMemoryString = kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().defaultValueString());
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(BoxesRunTime.unboxToDouble((Object)$this.kubernetesConf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) * (double)this.executorMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.executorMemoryWithOverhead = this.executorMemoryMiB() + this.memoryOverheadMiB();
        String string = kubernetesConf.get(Config$.MODULE$.APP_RESOURCE_TYPE());
        Some some = new Some((Object)Constants$.MODULE$.APP_RESOURCE_TYPE_PYTHON());
        this.executorMemoryTotal = !(string != null ? !string.equals(some) : some != null) ? this.executorMemoryWithOverhead() + (long)BoxesRunTime.unboxToInt((Object)((Option)kubernetesConf.get(Python$.MODULE$.PYSPARK_EXECUTOR_MEMORY())).map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$1 -> (int)x$1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) : this.executorMemoryWithOverhead();
        this.executorCores = BoxesRunTime.unboxToInt((Object)kubernetesConf.sparkConf().get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()));
        this.executorCoresRequest = kubernetesConf.sparkConf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES()) ? (String)((Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES())).get() : ((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString();
        this.executorLimitCores = (Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
    }
}

