/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!\u0002\u0011\"\u0001\u001dj\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011]\u0002!\u0011!Q\u0001\naB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001b\u0001\u0005\u0002)Dq!\u001e\u0001C\u0002\u0013Ec\u000f\u0003\u0004~\u0001\u0001\u0006Ia\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\t9\u0001\u0001Q\u0001\n\u0005\u0005\u0001\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\t\u0019\u0002\u0001Q\u0001\n\u00055\u0001\u0002CA\u000b\u0001\u0011\u0005\u0011%a\u0006\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011q\t\u0001\u0005B\u0005%\u0003bBA&\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\ty\u0006\u0001C!\u0003CBq!a\u0019\u0001\t\u0003\n)\u0007C\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u0012\u0001\u0005R\u0005=\u0005bBAT\u0001\u0011E\u0013\u0011\u0016\u0004\u0007\u0003c\u0003A!a-\t\r%dB\u0011AA[\u0011\u001d\tI\f\bC!\u0003wCa\"!4\u0001!\u0003\r\t\u0011!C\u0005\u0003\u000b\nyMA\u0011Lk\n,'O\\3uKN\u001cE.^:uKJ\u001c6\r[3ek2,'OQ1dW\u0016tGM\u0003\u0002#G\u0005\u00191\u000eO:\u000b\u0005\u0011*\u0013aB2mkN$XM\u001d\u0006\u0003M\u001d\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\"\u0001\u0001\u0018\u0011\u0005=\u0002T\"A\u0012\n\u0005E\u001a#!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0004\u0001A\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017AA:d!\tI$(D\u0001(\u0013\tYtE\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0011ahR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007G2LWM\u001c;\u000b\u0005\t\u001b\u0015AC6vE\u0016\u0014h.\u001a;fg*\u0011A)R\u0001\bM\u0006\u0014'/[29\u0015\u00051\u0015AA5p\u0013\tAuH\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u0006yQ\r_3dkR|'oU3sm&\u001cW\r\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005=\u0003\u0016\u0001B;uS2T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u0019\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011akV\u0007\u0002C%\u0011\u0001,\t\u0002\u001b\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;t'R|'/Z\u0001\ra>$\u0017\t\u001c7pG\u0006$xN\u001d\t\u0003-nK!\u0001X\u0011\u0003+\u0015CXmY;u_J\u0004v\u000eZ:BY2|7-\u0019;pe\u0006)B.\u001b4fGf\u001cG.Z#wK:$\b*\u00198eY\u0016\u0014\bC\u0001,`\u0013\t\u0001\u0017E\u0001\u000fFq\u0016\u001cW\u000f^8s!>$7\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:\u0002\u0017]\fGo\u00195Fm\u0016tGo\u001d\t\u0003-\u000eL!\u0001Z\u0011\u0003?\u0015CXmY;u_J\u0004v\u000eZ:XCR\u001c\u0007n\u00158baNDw\u000e^*pkJ\u001cW-\u0001\u0006q_2dWI^3oiN\u0004\"AV4\n\u0005!\f#!I#yK\u000e,Ho\u001c:Q_\u0012\u001c\bk\u001c7mS:<7K\\1qg\"|GoU8ve\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0006lY6tw\u000e]9sgR\u0004\"A\u0016\u0001\t\u000b\u0019R\u0001\u0019A\u001a\t\u000b]R\u0001\u0019\u0001\u001d\t\u000bqR\u0001\u0019A\u001f\t\u000b%S\u0001\u0019\u0001&\t\u000bQS\u0001\u0019A+\t\u000beS\u0001\u0019\u0001.\t\u000buS\u0001\u0019\u00010\t\u000b\u0005T\u0001\u0019\u00012\t\u000b\u0015T\u0001\u0019\u00014\u0002%5LgNU3hSN$XM]3e%\u0006$\u0018n\\\u000b\u0002oB\u0011\u0001p_\u0007\u0002s*\t!0A\u0003tG\u0006d\u0017-\u0003\u0002}s\n1Ai\\;cY\u0016\f1#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_\u0002\n\u0001#\u001b8ji&\fG.\u0012=fGV$xN]:\u0016\u0005\u0005\u0005\u0001c\u0001=\u0002\u0004%\u0019\u0011QA=\u0003\u0007%sG/A\tj]&$\u0018.\u00197Fq\u0016\u001cW\u000f^8sg\u0002\nQc\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148/\u0006\u0002\u0002\u000eA\u0019\u00010a\u0004\n\u0007\u0005E\u0011PA\u0004C_>dW-\u00198\u0002-MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u0002\n\u0001\u0003Z8SK6|g/Z#yK\u000e,Ho\u001c:\u0015\r\u0005e\u0011qDA\u001d!\rA\u00181D\u0005\u0004\u0003;I(\u0001B+oSRDq!!\t\u0012\u0001\u0004\t\u0019#\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u0004B!!\n\u000249!\u0011qEA\u0018!\r\tI#_\u0007\u0003\u0003WQ1!!\f3\u0003\u0019a$o\\8u}%\u0019\u0011\u0011G=\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\rM#(/\u001b8h\u0015\r\t\t$\u001f\u0005\b\u0003w\t\u0002\u0019AA\u001f\u0003\u0019\u0011X-Y:p]B\u0019A'a\u0010\n\u0007\u0005\u0005SE\u0001\nFq\u0016\u001cW\u000f^8s\u0019>\u001c8OU3bg>t\u0017!D1qa2L7-\u0019;j_:LE\r\u0006\u0002\u0002$\u0005)1\u000f^1siR\u0011\u0011\u0011D\u0001\u0005gR|\u0007/A\fe_J+\u0017/^3tiR{G/\u00197Fq\u0016\u001cW\u000f^8sgR!\u0011\u0011KA.!\u0019\t\u0019&a\u0016\u0002\u000e5\u0011\u0011Q\u000b\u0006\u0003\u001bfLA!!\u0017\u0002V\t1a)\u001e;ve\u0016Dq!!\u0018\u0016\u0001\u0004\t\t!\u0001\bsKF,Xm\u001d;fIR{G/\u00197\u0002;M,hMZ5dS\u0016tGOU3t_V\u00148-Z:SK\u001eL7\u000f^3sK\u0012$\"!!\u0004\u0002\u001d\u001d,G/\u0012=fGV$xN]%egR\u0011\u0011q\r\t\u0007\u0003S\n\u0019(a\t\u000f\t\u0005-\u0014q\u000e\b\u0005\u0003S\ti'C\u0001{\u0013\r\t\t(_\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)(a\u001e\u0003\u0007M+\u0017OC\u0002\u0002re\fq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u0003#\ni\bC\u0004\u0002\u0000a\u0001\r!a\u001a\u0002\u0017\u0015DXmY;u_JLEm]\u0001\u0015GJ,\u0017\r^3Ee&4XM]#oIB|\u0017N\u001c;\u0015\u0005\u0005\u0015\u0005\u0003BAD\u0003\u0013k\u0011\u0001A\u0005\u0004\u0003\u0017\u0003$A\u0004#sSZ,'/\u00128ea>Lg\u000e^\u0001\u0013GJ,\u0017\r^3U_.,g.T1oC\u001e,'\u000f\u0006\u0002\u0002\u0012B)\u00010a%\u0002\u0018&\u0019\u0011QS=\u0003\r=\u0003H/[8o!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b\u0001b]3dkJLG/\u001f\u0006\u0004\u0003C;\u0013A\u00023fa2|\u00170\u0003\u0003\u0002&\u0006m%\u0001\b%bI>|\u0007\u000fR3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u000eSN\u0014E.Y2lY&\u001cH/\u001a3\u0015\r\u00055\u00111VAW\u0011\u001d\t\tc\u0007a\u0001\u0003GAq!a,\u001c\u0001\u0004\t\u0019#\u0001\u0005i_N$h.Y7f\u0005aYUOY3s]\u0016$Xm\u001d#sSZ,'/\u00128ea>Lg\u000e^\n\u00049\u0005\u0015ECAA\\!\r\t9\tH\u0001\u000f_:$\u0015n]2p]:,7\r^3e)\u0011\tI\"!0\t\u000f\u0005}f\u00041\u0001\u0002B\u0006Q!\u000f]2BI\u0012\u0014Xm]:\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bT1!a2(\u0003\r\u0011\boY\u0005\u0005\u0003\u0017\f)M\u0001\u0006Sa\u000e\fE\r\u001a:fgN\f1c];qKJ$\u0013\r\u001d9mS\u000e\fG/[8o\u0013\u0012LA!a\u0011\u0002R&\u0019\u00111[\u0013\u0003!M\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final SparkContext sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    private final ScheduledExecutorService executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteExecutors;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        block0: {
            if (!this.isExecutorActive(executorId)) break block0;
            this.removeExecutor(executorId, reason);
        }
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        super.start();
        this.podAllocator.setTotalExpectedExecutors(this.initialExecutors());
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId());
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
    }

    public void stop() {
        super.stop();
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteExecutors()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        this.podAllocator.setTotalExpectedExecutors(requestedTotal);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (((PodList)running.list()).getItems().isEmpty()) break block0;
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$2(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isBlacklisted(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

