/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.util.Locale;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import scala.Option;

public final class KubernetesConf$ {
    public static KubernetesConf$ MODULE$;

    static {
        new KubernetesConf$();
    }

    public KubernetesDriverConf createDriverConf(SparkConf sparkConf, String appId, MainAppResource mainAppResource, String mainClass, String[] appArgs) {
        KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
        return new KubernetesDriverConf(sparkConf.clone(), appId, mainAppResource, mainClass, appArgs);
    }

    public KubernetesExecutorConf createExecutorConf(SparkConf sparkConf, String executorId, String appId, Option<Pod> driverPod) {
        return new KubernetesExecutorConf(sparkConf.clone(), appId, executorId, driverPod);
    }

    public String getResourceNamePrefix(String appName) {
        String id = KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1());
        return new StringBuilder(1).append(appName).append("-").append(id).toString().trim().toLowerCase(Locale.ROOT).replaceAll("\\s+", "-").replaceAll("\\.", "-").replaceAll("[^a-z0-9\\-]", "").replaceAll("-+", "-");
    }

    public String buildKubernetesResourceName(String vendorDomain, String resourceName) {
        return new StringBuilder(1).append(vendorDomain).append("/").append(resourceName).toString();
    }

    private KubernetesConf$() {
        MODULE$ = this;
    }
}

