/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!B\u0004\t\u00019!\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u000bE\u0002A\u0011\u0001\u001a\t\u000be\u0002A\u0011\t\u001e\t\u000b\u0001\u0003A\u0011I!\t\u000bA\u0003A\u0011I)\t\u000b%\u0004A\u0011\u00026\u0003/5{WO\u001c;W_2,X.Z:GK\u0006$XO]3Ti\u0016\u0004(BA\u0005\u000b\u0003!1W-\u0019;ve\u0016\u001c(BA\u0006\r\u0003\rY\u0007h\u001d\u0006\u0003\u001b9\ta\u0001Z3qY>L(BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011\u0001C\u0005\u0003=!\u00111dS;cKJtW\r^3t\r\u0016\fG/\u001e:f\u0007>tg-[4Ti\u0016\u0004\u0018AD6vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u0002\u0001a\t\u0011\u0003\u0006E\u0002$I\u0019j\u0011AC\u0005\u0003K)\u0011abS;cKJtW\r^3t\u0007>tg\r\u0005\u0002(Q1\u0001A!C\u0015\u0002\u0003\u0003\u0005\tQ!\u0001+\u0005\ryF%M\t\u0003W9\u0002\"A\u0006\u0017\n\u00055:\"a\u0002(pi\"Lgn\u001a\t\u0003G=J!\u0001\r\u0006\u00035-+(-\u001a:oKR,7OU8mKN\u0003XmY5gS\u000e\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t\u0019D\u0007\u0005\u0002\u001d\u0001!)qD\u0001a\u0001kA\u0012a\u0007\u000f\t\u0004G\u0011:\u0004CA\u00149\t%IC'!A\u0001\u0002\u000b\u0005!&\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0002<}A\u00111\u0005P\u0005\u0003{)\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006\u007f\r\u0001\raO\u0001\u0004a>$\u0017\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\u0012A\u0011\t\u0005\u0007*kUJ\u0004\u0002E\u0011B\u0011QiF\u0007\u0002\r*\u0011q\tI\u0001\u0007yI|w\u000e\u001e \n\u0005%;\u0012A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n\u0019Q*\u00199\u000b\u0005%;\u0002CA\"O\u0013\tyEJ\u0001\u0004TiJLgnZ\u0001!O\u0016$\u0018\t\u001a3ji&|g.\u00197Lk\n,'O\\3uKN\u0014Vm]8ve\u000e,7\u000fF\u0001S!\r\u0019\u0006l\u0017\b\u0003)Zs!!R+\n\u0003aI!aV\f\u0002\u000fA\f7m[1hK&\u0011\u0011L\u0017\u0002\u0004'\u0016\f(BA,\u0018!\tav-D\u0001^\u0015\tqv,A\u0003n_\u0012,GN\u0003\u0002aC\u0006\u0019\u0011\r]5\u000b\u0005\t\u001c\u0017AC6vE\u0016\u0014h.\u001a;fg*\u0011A-Z\u0001\bM\u0006\u0014'/[29\u0015\u00051\u0017AA5p\u0013\tAWLA\u0006ICNlU\r^1eCR\f\u0017\u0001E2p]N$(/^2u->dW/\\3t)\tYw\u000fE\u0002TY:L!!\u001c.\u0003\u0011%#XM]1cY\u0016\u0004BAF8ri&\u0011\u0001o\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005q\u0013\u0018BA:^\u0005-1v\u000e\\;nK6{WO\u001c;\u0011\u0005q+\u0018B\u0001<^\u0005\u00191v\u000e\\;nK\")\u0001P\u0002a\u0001s\u0006Yao\u001c7v[\u0016\u001c\u0006/Z2t!\r\u0019FN\u001f\u0019\u0003w~\u00042a\t?\u007f\u0013\ti(B\u0001\u000bLk\n,'O\\3uKN4v\u000e\\;nKN\u0003Xm\u0019\t\u0003O}$1\"!\u0001x\u0003\u0003\u0005\tQ!\u0001\u0002\u0004\t\u0019q\f\n\u001a\u0012\u0007-\n)\u0001E\u0002$\u0003\u000fI1!!\u0003\u000b\u0005qYUOY3s]\u0016$Xm\u001d,pYVlWm\u00159fG&4\u0017nY\"p]\u001a\u0004")
public class MountVolumesFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Tuple2 tuple2 = this.constructVolumes(this.kubernetesConf.roleVolumes()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable volumeMounts = (Iterable)tuple2._1();
        Iterable volumes = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)volumeMounts, (Object)volumes);
        Tuple2 tuple23 = tuple22;
        Iterable volumeMounts2 = (Iterable)tuple23._1();
        Iterable volumes2 = (Iterable)tuple23._2();
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editSpec().addToVolumes((Volume[])volumes2.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        Container containerWithVolumeMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])volumeMounts2.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithVolumeMounts);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Iterable<Tuple2<VolumeMount, Volume>> constructVolumes(Iterable<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>> volumeSpecs) {
        return (Iterable)volumeSpecs.map((Function1 & Serializable & scala.Serializable)spec -> {
            VolumeBuilder volumeBuilder;
            VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withMountPath(spec.mountPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly()))).withName(spec.volumeName())).build();
            Object t = spec.volumeConf();
            if (t instanceof KubernetesHostPathVolumeConf) {
                KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)t;
                String hostPath = kubernetesHostPathVolumeConf.hostPath();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withHostPath(((HostPathVolumeSourceBuilder)new HostPathVolumeSourceBuilder().withPath(hostPath)).build());
            } else if (t instanceof KubernetesPVCVolumeConf) {
                KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)t;
                String claimName = kubernetesPVCVolumeConf.claimName();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly())));
            } else if (t instanceof KubernetesEmptyDirVolumeConf) {
                KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)t;
                Option<String> medium = kubernetesEmptyDirVolumeConf.medium();
                Option<String> sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withEmptyDir(new EmptyDirVolumeSource((String)medium.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), new Quantity((String)sizeLimit.orNull(Predef$.MODULE$.$conforms()))));
            } else {
                throw new MatchError(t);
            }
            VolumeBuilder volumeBuilder2 = volumeBuilder;
            Volume volume = ((VolumeBuilder)volumeBuilder2.withName(spec.volumeName())).build();
            return new Tuple2((Object)volumeMount, (Object)volume);
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public MountVolumesFeatureStep(KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

