/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class KubernetesUtils$ {
    public static KubernetesUtils$ MODULE$;

    static {
        new KubernetesUtils$();
    }

    public Map<String, String> parsePrefixedKeyValuePairs(SparkConf sparkConf, String prefix) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(prefix))).toMap(Predef$.MODULE$.$conforms());
    }

    public void requireNandDefined(Option<?> opt1, Option<?> opt2, String errMessage) {
        opt1.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            Predef$.MODULE$.require(opt2.isEmpty(), (Function0 & java.io.Serializable & Serializable)() -> errMessage$1);
            return BoxedUnit.UNIT;
        });
    }

    public Iterable<String> resolveFileUrisAndPath(Iterable<String> fileUris) {
        return (Iterable)fileUris.map((Function1 & java.io.Serializable & Serializable)uri -> MODULE$.resolveFileUri((String)uri), Iterable$.MODULE$.canBuildFrom());
    }

    public String resolveFileUri(String uri) {
        URI fileUri = Utils$.MODULE$.resolveURI(uri);
        String fileScheme = (String)Option$.MODULE$.apply((Object)fileUri.getScheme()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "file");
        String string = fileScheme;
        String string2 = "local".equals(string) ? fileUri.getPath() : uri;
        return string2;
    }

    public String parseMasterUrl(String url) {
        return url.substring("k8s://".length());
    }

    public Option<Pod> buildPodWithServiceAccount(Option<String> serviceAccount, SparkPod pod) {
        return serviceAccount.map((Function1 & java.io.Serializable & Serializable)account -> ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editOrNewSpec().withServiceAccount(account).withServiceAccountName(account)).endSpec()).build());
    }

    private KubernetesUtils$() {
        MODULE$ = this;
    }
}

