/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features.bindings;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3QAB\u0004\u0001\u001fUA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006S\u0001!\tA\u000b\u0005\u0006]\u0001!\te\f\u0005\u0006k\u0001!\tE\u000e\u0005\u0006\u000b\u0002!\tE\u0012\u0002\u0018!f$\bn\u001c8Ee&4XM\u001d$fCR,(/Z*uKBT!\u0001C\u0005\u0002\u0011\tLg\u000eZ5oONT!AC\u0006\u0002\u0011\u0019,\u0017\r^;sKNT!\u0001D\u0007\u0002\u0007-D4O\u0003\u0002\u000f\u001f\u00051A-\u001a9m_fT!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\t\u0011\"\u0003\u0002 \u0013\tY2*\u001e2fe:,G/Z:GK\u0006$XO]3D_:4\u0017nZ*uKB\fab[;cKJtW\r^3t\u0007>tgm\u0001\u0001\u0011\u0007\r\"c%D\u0001\f\u0013\t)3B\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0011\u0005\r:\u0013B\u0001\u0015\f\u0005qYUOY3s]\u0016$Xm\u001d#sSZ,'o\u00159fG&4\u0017nY\"p]\u001a\fa\u0001P5oSRtDCA\u0016.!\ta\u0003!D\u0001\b\u0011\u0015\u0001#\u00011\u0001#\u00031\u0019wN\u001c4jOV\u0014X\rU8e)\t\u00014\u0007\u0005\u0002$c%\u0011!g\u0003\u0002\t'B\f'o\u001b)pI\")Ag\u0001a\u0001a\u0005\u0019\u0001o\u001c3\u0002A\u001d,G/\u00113eSRLwN\\1m!>$7+_:uK6\u0004&o\u001c9feRLWm\u001d\u000b\u0002oA!\u0001h\u0010\"C\u001d\tIT\b\u0005\u0002;15\t1H\u0003\u0002=C\u00051AH]8pizJ!A\u0010\r\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015IA\u0002NCBT!A\u0010\r\u0011\u0005a\u001a\u0015B\u0001#B\u0005\u0019\u0019FO]5oO\u0006\u0001s-\u001a;BI\u0012LG/[8oC2\\UOY3s]\u0016$Xm\u001d*fg>,(oY3t)\u00059\u0005c\u0001%N!:\u0011\u0011j\u0013\b\u0003u)K\u0011!G\u0005\u0003\u0019b\tq\u0001]1dW\u0006<W-\u0003\u0002O\u001f\n\u00191+Z9\u000b\u00051C\u0002CA)]\u001b\u0005\u0011&BA*U\u0003\u0015iw\u000eZ3m\u0015\t)f+A\u0002ba&T!a\u0016-\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002Z5\u00069a-\u00192sS\u000eD$\"A.\u0002\u0005%|\u0017BA/S\u0005-A\u0015m]'fi\u0006$\u0017\r^1")
public class PythonDriverFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        KubernetesDriverSpecificConf roleConf = this.kubernetesConf.roleSpecificConf();
        Predef$.MODULE$.require(roleConf.mainAppResource().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "PySpark Main Resource must be defined");
        Option maybePythonArgs = Option$.MODULE$.apply(roleConf.appArgs()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).map((Function1 & Serializable & scala.Serializable)pyArgs -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_ARGS())).withValue(pyArgs.mkString(" "))).build());
        Option maybePythonFiles = this.kubernetesConf.pyFiles().map((Function1 & Serializable & scala.Serializable)pyFiles -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_FILES())).withValue(KubernetesUtils$.MODULE$.resolveFileUrisAndPath((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])pyFiles.split(","))).mkString(":"))).build());
        Seq envSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_PRIMARY())).withValue(KubernetesUtils$.MODULE$.resolveFileUri((String)this.kubernetesConf.pySparkMainResource().get()))).build(), ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_MAJOR_PYTHON_VERSION())).withValue(this.kubernetesConf.pySparkPythonVersion())).build()}));
        Seq pythonEnvs = (Seq)((TraversableLike)envSeq.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maybePythonArgs).toSeq(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maybePythonFiles).toSeq(), Seq$.MODULE$.canBuildFrom());
        Container withPythonPrimaryContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(pythonEnvs).asJava())).addToArgs(new String[]{"driver-py"})).addToArgs(new String[]{"--properties-file", Constants$.MODULE$.SPARK_CONF_PATH()})).addToArgs(new String[]{"--class", roleConf.mainClass()})).build();
        return new SparkPod(pod.pod(), withPythonPrimaryContainer);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.APP_RESOURCE_TYPE().key()), (Object)"python")}));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public PythonDriverFeatureStep(KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

