/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Closeable;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db!B\u0001\u0003\u0001!q!aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK*\u00111\u0001B\u0001\u0004Wb\u001a(BA\u0003\u0007\u0003\u001d\u0019G.^:uKJT!a\u0002\u0005\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0014\u0007\u0001yQ\u0003\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-ei\u0011a\u0006\u0006\u00031!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00035]\u0011q\u0001T8hO&tw\r\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001f\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016\u001c\u0001\u0001\u0005\u0002 A5\t!!\u0003\u0002\"\u0005\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0011QEL\u0007\u0002M)\u0011q\u0005K\u0001\u0007G2LWM\u001c;\u000b\u0005%R\u0013AC6vE\u0016\u0014h.\u001a;fg*\u00111\u0006L\u0001\bM\u0006\u0014'/[29\u0015\u0005i\u0013AA5p\u0013\tycE\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2a\r\u001b6!\ty\u0002\u0001C\u0003\u001da\u0001\u0007a\u0004C\u0003$a\u0001\u0007A\u0005C\u00058\u0001\u0001\u0007\t\u0019!C\u0005q\u0005yq/\u0019;dQ\u000e{gN\\3di&|g.F\u0001:!\tQd(D\u0001<\u0015\tiCHC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}Z$!C\"m_N,\u0017M\u00197f\u0011%\t\u0005\u00011AA\u0002\u0013%!)A\nxCR\u001c\u0007nQ8o]\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011\u0001\u0003R\u0005\u0003\u000bF\u0011A!\u00168ji\"9q\tQA\u0001\u0002\u0004I\u0014a\u0001=%c!I\u0011\n\u0001a\u0001\u0002\u0003\u0006K!O\u0001\u0011o\u0006$8\r[\"p]:,7\r^5p]\u0002BQa\u0013\u0001\u0005\u00021\u000bQa\u001d;beR$\"aQ'\t\u000b9S\u0005\u0019A(\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e!\t\u0001vK\u0004\u0002R+B\u0011!+E\u0007\u0002'*\u0011A+H\u0001\u0007yI|w\u000e\u001e \n\u0005Y\u000b\u0012A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV\t\t\u000bm\u0003A\u0011\u0001/\u0002\tM$x\u000e\u001d\u000b\u0002\u0007\u001a!a\f\u0001\u0003`\u0005M)\u00050Z2vi>\u0014\bk\u001c3t/\u0006$8\r[3s'\ri\u0006M\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003Gr\nA\u0001\\1oO&\u0011QM\u0019\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\u0015:\u0017.\u0003\u0002iM\t9q+\u0019;dQ\u0016\u0014\bC\u00016p\u001b\u0005Y'B\u00017n\u0003\u0015iw\u000eZ3m\u0015\tq\u0007&A\u0002ba&L!\u0001]6\u0003\u0007A{G\rC\u00032;\u0012\u0005!\u000fF\u0001t!\t!X,D\u0001\u0001\u0011\u00151X\f\"\u0011x\u00035)g/\u001a8u%\u0016\u001cW-\u001b<fIR!1\t_A\n\u0011\u0015IX\u000f1\u0001{\u0003\u0019\t7\r^5p]B\u001910!\u0004\u000f\u0007q\fIAD\u0002~\u0003\u000fq1A`A\u0003\u001d\ry\u00181\u0001\b\u0004%\u0006\u0005\u0011\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&C\u0002\u0002\f\u0019\nqaV1uG\",'/\u0003\u0003\u0002\u0010\u0005E!AB!di&|gNC\u0002\u0002\f\u0019Ba!!\u0006v\u0001\u0004I\u0017a\u00019pI\"9\u0011\u0011D/\u0005B\u0005m\u0011aB8o\u00072|7/\u001a\u000b\u0004\u0007\u0006u\u0001\u0002CA\u0010\u0003/\u0001\r!!\t\u0002\u0003\u0015\u00042!JA\u0012\u0013\r\t)C\n\u0002\u001a\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\u0005pY3qi&|g\u000e")
public class ExecutorPodsWatchSnapshotSource
implements Logging {
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore;
    private final KubernetesClient kubernetesClient;
    private Closeable watchConnection;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Closeable watchConnection() {
        return this.watchConnection;
    }

    private void watchConnection_$eq(Closeable x$1) {
        this.watchConnection = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.watchConnection() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start the watcher twice.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Starting watch for pods with labels ").append(Constants$.MODULE$.SPARK_APP_ID_LABEL()).append("=").append(applicationId).append(",").append(new StringBuilder(3).append(" ").append(Constants$.MODULE$.SPARK_ROLE_LABEL()).append("=").append(Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).append(".").toString()).toString());
        this.watchConnection_$eq((Closeable)((Watchable)((Filterable)this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).watch((Object)new ExecutorPodsWatcher()));
    }

    public void stop() {
        block0: {
            if (this.watchConnection() == null) break block0;
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.watchConnection().close());
            this.watchConnection_$eq(null);
        }
    }

    public ExecutorPodsWatchSnapshotSource(ExecutorPodsSnapshotsStore snapshotsStore, KubernetesClient kubernetesClient) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore = snapshotsStore;
        this.kubernetesClient = kubernetesClient;
        Logging.$init$((Logging)this);
    }

    public class ExecutorPodsWatcher
    implements Watcher<Pod> {
        public void eventReceived(Watcher.Action action, Pod pod) {
            String podName = pod.getMetadata().getName();
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received executor pod update for pod named ").append(podName).append(", action ").append(action).toString());
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore.updatePod(pod);
        }

        public void onClose(KubernetesClientException e) {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kubernetes client has been closed (this is expected if the application is shutting down.)", (Throwable)e);
        }

        public /* synthetic */ ExecutorPodsWatchSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer() {
            return ExecutorPodsWatchSnapshotSource.this;
        }

        public ExecutorPodsWatcher() {
            if (ExecutorPodsWatchSnapshotSource.this == null) {
                throw null;
            }
        }
    }
}

